/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import java.io.Serializable;
import java.util.Iterator;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.LabelInfo;
import org.spoofax.terms.Term;
import org.spoofax.terms.TermVisitor;

public class TokenKindManager
implements Serializable {
    private static final long serialVersionUID = 856473135736955433L;
    private static final int RANGE_START = 0;
    private static final int RANGE_END = 1;

    public IToken.Kind getTokenKind(LabelInfo label) {
        if (label == null) {
            return IToken.Kind.TK_STRING;
        }
        if (label.isLayout()) {
            return IToken.Kind.TK_LAYOUT;
        }
        if (label.isLexical()) {
            if (TokenKindManager.isStringLiteral(label)) {
                return IToken.Kind.TK_STRING;
            }
            if (TokenKindManager.isNumberLiteral(label)) {
                return IToken.Kind.TK_NUMBER;
            }
            return IToken.Kind.TK_IDENTIFIER;
        }
        if (label.isVar()) {
            return IToken.Kind.TK_VAR;
        }
        if (TokenKindManager.isOperator(label)) {
            return IToken.Kind.TK_OPERATOR;
        }
        return IToken.Kind.TK_KEYWORD;
    }

    protected static boolean isOperator(LabelInfo label) {
        if (!label.isLiteral()) {
            return false;
        }
        IStrategoString lit2 = (IStrategoString)Term.termAt(label.getRHS(), 0);
        String contents = lit2.stringValue();
        int i = 0;
        while (i < contents.length()) {
            char c = contents.charAt(i);
            if (Character.isLetter(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static boolean isStringLiteral(LabelInfo label) {
        return TokenKindManager.topdownHasSpaces(label.getLHS());
    }

    private static boolean topdownHasSpaces(IStrategoTerm term) {
        Iterator<IStrategoTerm> iterator = TermVisitor.tryGetListIterator(term);
        int i = 0;
        int max2 = term.getSubtermCount();
        while (i < max2) {
            IStrategoTerm child;
            IStrategoTerm iStrategoTerm = child = iterator == null ? term.getSubterm(i) : iterator.next();
            if (TokenKindManager.isRangeAppl(child)) {
                int start = Term.intAt(child, 0);
                int end = Term.intAt(child, 1);
                if (start <= 32 && 32 <= end) {
                    return true;
                }
            } else if (TokenKindManager.topdownHasSpaces(child)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isRangeAppl(IStrategoTerm child) {
        return Term.isTermAppl(child) && ((IStrategoAppl)child).getName().equals("range");
    }

    protected static boolean isNumberLiteral(LabelInfo label) {
        IStrategoTerm range = TokenKindManager.getFirstRange(label.getLHS());
        return range != null && Term.intAt(range, 0) == 48 && Term.intAt(range, 1) == 57;
    }

    private static IStrategoTerm getFirstRange(IStrategoTerm term) {
        int i = 0;
        while (i < term.getSubtermCount()) {
            Object child = Term.termAt(term, i);
            if (TokenKindManager.isRangeAppl(child)) {
                return child;
            }
            if ((child = TokenKindManager.getFirstRange(child)) != null) {
                return child;
            }
            ++i;
        }
        return null;
    }
}

