/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITreeFactory;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.terms.StrategoListIterator;
import org.spoofax.terms.StrategoSubList;
import org.spoofax.terms.Term;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.attachments.ParentAttachment;
import org.spoofax.terms.util.NotImplementedException;

public class TermTreeFactory
implements ITreeFactory<IStrategoTerm> {
    private final ITermFactory originalFactory;
    private ITermFactory factory;
    private boolean enableTokens;

    public TermTreeFactory() {
        this(new TermFactory());
    }

    public TermTreeFactory(ITermFactory factory) {
        this.originalFactory = factory;
        this.setEnableTokens(false);
    }

    @Override
    public void setEnableTokens(boolean enableTokens) {
        this.enableTokens = enableTokens;
        this.factory = this.originalFactory;
    }

    public ITermFactory getTermFactory() {
        return this.factory;
    }

    public ITermFactory getOriginalTermFactory() {
        return this.originalFactory;
    }

    public IStrategoConstructor createConstructor(String name2, int childCount) {
        return this.factory.makeConstructor(name2, childCount);
    }

    @Override
    public IStrategoTerm createNonTerminal(String sort, String constructor, IToken leftToken, IToken rightToken, List<IStrategoTerm> children, boolean isCompletion, boolean isNestedCompletion, boolean isSinglePlaceholderCompletion) {
        IStrategoConstructor cons = this.factory.makeConstructor(constructor, children.size());
        IStrategoAppl result = this.factory.makeAppl(cons, children.toArray(new IStrategoTerm[children.size()]));
        this.configure(result, sort, leftToken, rightToken, false, false, isCompletion, isNestedCompletion, isSinglePlaceholderCompletion);
        return result;
    }

    @Override
    public IStrategoTerm createIntTerminal(String sort, IToken token, int value) {
        IStrategoInt result = this.factory.makeInt(value);
        this.configure(result, sort, token, token, false, false, false, false, false);
        return result;
    }

    @Override
    public IStrategoTerm createRealTerminal(String sort, IToken token, double value) {
        IStrategoReal result = this.factory.makeReal(value);
        this.configure(result, sort, token, token, false, false, false, false, false);
        return result;
    }

    @Override
    public IStrategoTerm createStringTerminal(String sort, IToken leftToken, IToken rightToken, String value, boolean caseInsensitive) {
        if (caseInsensitive) {
            value = value.toLowerCase();
        }
        IStrategoString result = this.factory.makeString(value);
        this.configure(result, sort, leftToken, rightToken, false, false, false, false, false);
        return result;
    }

    @Override
    public IStrategoTerm createTuple(String elementSort, IToken leftToken, IToken rightToken, List<IStrategoTerm> children) {
        IStrategoTuple result = this.factory.makeTuple(TermTreeFactory.toArray(children));
        this.configure(result, elementSort, leftToken, rightToken, true, false, false, false, false);
        return result;
    }

    @Override
    public IStrategoTerm createAmb(List<IStrategoTerm> alternatives, IToken leftToken, IToken rightToken, boolean isCompletion, boolean isNestedCompletion, boolean isSinglePlaceholderCompletion) {
        ArrayList<Object> alternativesInList = new ArrayList<Object>();
        alternativesInList.add(this.createList((String)null, leftToken, rightToken, (List)alternatives));
        return this.createNonTerminal((String)null, "amb", leftToken, rightToken, alternativesInList, isCompletion, isNestedCompletion, isSinglePlaceholderCompletion);
    }

    @Override
    public IStrategoTerm createList(String elementSort, IToken leftToken, IToken rightToken, List<IStrategoTerm> children) {
        IStrategoList result = this.factory.makeList(TermTreeFactory.toArray(children));
        this.configure(result, elementSort, leftToken, rightToken, true, false, false, false, false);
        return result;
    }

    @Override
    public IStrategoTerm createSublist(IStrategoList list2, IStrategoTerm firstChild, IStrategoTerm lastChild) {
        ArrayList<IStrategoTerm> children = new ArrayList<IStrategoTerm>();
        boolean isStartChildFound = false;
        int indexStart = -1;
        int indexEnd = -1;
        int i = 0;
        for (IStrategoTerm child : StrategoListIterator.iterable(list2)) {
            if (child == firstChild) {
                indexStart = i;
                isStartChildFound = true;
            }
            if (isStartChildFound) {
                children.add(child);
                if (child == lastChild) {
                    indexEnd = i;
                    break;
                }
            }
            ++i;
        }
        assert (indexStart >= 0 && indexStart <= indexEnd);
        IStrategoList wrapped = this.factory.makeList(children);
        StrategoSubList result = new StrategoSubList(list2, wrapped, indexStart, indexEnd);
        ParentAttachment.putParent(result, ParentAttachment.get(list2));
        if (ImploderAttachment.get(firstChild) != null && ImploderAttachment.get(lastChild) != null) {
            ImploderAttachment.putImploderAttachment(result, true, ImploderAttachment.getElementSort(list2), this.getLeftToken(firstChild), this.getRightToken(lastChild), false, false, false, false);
        }
        return result;
    }

    @Override
    public IStrategoTerm recreateNode(IStrategoTerm oldNode, IToken leftToken, IToken rightToken, List<IStrategoTerm> children) {
        ImploderAttachment it = oldNode.getAttachment(ImploderAttachment.TYPE);
        switch (oldNode.getType()) {
            case INT: {
                return this.createIntTerminal(ImploderAttachment.getSort(oldNode), leftToken, ((IStrategoInt)oldNode).intValue());
            }
            case APPL: {
                if (it == null) {
                    return this.createNonTerminal(ImploderAttachment.getSort(oldNode), ((IStrategoAppl)oldNode).getName(), leftToken, rightToken, (List)children, false, false, false);
                }
                return this.createNonTerminal(ImploderAttachment.getSort(oldNode), ((IStrategoAppl)oldNode).getName(), leftToken, rightToken, (List)children, it.isCompletion(), it.isNestedCompletion(), it.isSinglePlaceholderCompletion());
            }
            case LIST: {
                return this.createList(ImploderAttachment.getElementSort(oldNode), leftToken, rightToken, (List)children);
            }
            case STRING: {
                if (it == null) {
                    return this.createStringTerminal(ImploderAttachment.getSort(oldNode), leftToken, rightToken, ((IStrategoString)oldNode).stringValue(), false);
                }
                return this.createStringTerminal(ImploderAttachment.getSort(oldNode), leftToken, rightToken, ((IStrategoString)oldNode).stringValue(), !((IStrategoString)oldNode).stringValue().equals(it.toString()));
            }
            case TUPLE: {
                return this.createTuple(ImploderAttachment.getElementSort(oldNode), leftToken, rightToken, (List)children);
            }
            case REAL: {
                return this.createRealTerminal(ImploderAttachment.getElementSort(oldNode), leftToken, ((IStrategoReal)oldNode).realValue());
            }
        }
        throw new NotImplementedException("Recreating term of type " + (Object)((Object)oldNode.getType()) + " (" + oldNode + ") not supported");
    }

    @Override
    public String tryGetStringValue(IStrategoTerm node) {
        return Term.isTermString(node) ? ((IStrategoString)node).stringValue() : null;
    }

    @Override
    public IStrategoTerm createInjection(String sort, IToken leftToken, IToken rightToken, IStrategoTerm injected, boolean isCompletion, boolean isNestedCompletion, boolean isSinglePlaceholderCompletion, boolean isBracket) {
        IStrategoTerm result = injected;
        if (isBracket) {
            if (result instanceof IStrategoAppl && ((IStrategoAppl)result).getConstructor().getName().equals("amb")) {
                IStrategoTerm ambList = result.getSubterm(0);
                this.configureAmbNodes(ambList, isBracket, isCompletion, isNestedCompletion, isSinglePlaceholderCompletion);
                return result;
            }
            IToken left = leftToken;
            IToken right = rightToken;
            if (ImploderAttachment.get(result).isCompletion()) {
                this.configure(result, result.getAttachment(ImploderAttachment.TYPE).getSort(), left, right, false, isBracket, true, false, isSinglePlaceholderCompletion);
            } else {
                this.configure(result, result.getAttachment(ImploderAttachment.TYPE).getSort(), left, right, false, isBracket, isCompletion, isNestedCompletion, isSinglePlaceholderCompletion);
            }
        }
        String injectedSort = ImploderAttachment.get(injected).getSort();
        if (sort != null && !Objects.equals(sort, injectedSort)) {
            ImploderAttachment.get(result).pushInjection(sort);
        }
        return result;
    }

    private void configureAmbNodes(IStrategoTerm result, boolean isBracket, boolean isCompletion, boolean isNestedCompletion, boolean isSinglePlaceholderCompletion) {
        int i = 0;
        while (i < result.getSubtermCount()) {
            IStrategoTerm child = result.getSubterm(i);
            if (child instanceof IStrategoAppl) {
                if (((IStrategoAppl)child).getConstructor().getName().equals("amb")) {
                    IStrategoTerm ambList = child.getSubterm(0);
                    this.configureAmbNodes(ambList, isBracket, isCompletion, isNestedCompletion, isSinglePlaceholderCompletion);
                } else {
                    IToken left = this.getLeftToken(child);
                    IToken right = this.getRightToken(child);
                    if (ImploderAttachment.get(child).isCompletion()) {
                        this.configure(child, child.getAttachment(ImploderAttachment.TYPE).getSort(), left, right, false, isBracket, true, false, isSinglePlaceholderCompletion);
                    } else {
                        this.configure(child, child.getAttachment(ImploderAttachment.TYPE).getSort(), left, right, false, isBracket, isCompletion, isNestedCompletion, isSinglePlaceholderCompletion);
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public Iterable<IStrategoTerm> getChildren(IStrategoTerm node) {
        if (node instanceof Iterable) {
            IStrategoTerm result = node;
            return result;
        }
        if (node.getSubtermCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IStrategoTerm> children = new ArrayList<IStrategoTerm>(node.getSubtermCount());
        int i = 0;
        int max2 = node.getSubtermCount();
        while (i < max2) {
            children.add(node.getSubterm(i));
            ++i;
        }
        return children;
    }

    private static IStrategoTerm[] toArray(List<IStrategoTerm> children) {
        return children.toArray(new IStrategoTerm[children.size()]);
    }

    @Override
    public final IToken getLeftToken(IStrategoTerm term) {
        return ImploderAttachment.getLeftToken(term);
    }

    @Override
    public final IToken getRightToken(IStrategoTerm term) {
        return ImploderAttachment.getRightToken(term);
    }

    @Override
    public Iterable<IStrategoTerm> tryGetAmbChildren(IStrategoTerm node) {
        if (Term.isTermAppl(node) && "amb".equals(((IStrategoAppl)node).getName())) {
            return StrategoListIterator.iterable((IStrategoList)node.getSubterm(0));
        }
        return null;
    }

    @Override
    public IStrategoTerm createTop(IStrategoTerm tree, String filename, int ambiguityCount) {
        return tree;
    }

    protected void configure(IStrategoTerm term, String sort, IToken leftToken, IToken rightToken, boolean isListOrTuple, boolean isBracket, boolean isCompletion, boolean isNestedCompletion, boolean isSinglePlaceholderCompletion) {
        assert (isListOrTuple == (term.getType() == TermType.TUPLE || term.getType() == TermType.LIST));
        if (this.enableTokens) {
            rightToken = rightToken != null ? rightToken : leftToken;
        }
        ImploderAttachment.putImploderAttachment(term, isListOrTuple, sort, leftToken, rightToken, isBracket, isCompletion, isNestedCompletion, isSinglePlaceholderCompletion);
        if (term.getType() == TermType.LIST) {
            IStrategoList sublist = (IStrategoList)term;
            while (!sublist.isEmpty()) {
                IToken lastRightToken = this.getRightToken(sublist.head());
                leftToken = (sublist = sublist.tail()).isEmpty() ? lastRightToken : this.getLeftToken(sublist.head());
                ImploderAttachment.putImploderAttachment(sublist, isListOrTuple, sort, leftToken, rightToken, isBracket, isCompletion, isNestedCompletion, isSinglePlaceholderCompletion);
            }
        }
    }
}

