/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.metaborg.util.functions.PartialFunction2;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;

public class Injections {
    private static final String INJ_ANNO = "inj";

    public static IStrategoTerm explicate(IStrategoTerm term, PartialFunction2<String, String, String> injName, ITermFactory factory) {
        String sort;
        IStrategoTerm result;
        ImmutableList injections = ImmutableList.copyOf(ImploderAttachment.get(term).getInjections()).reverse();
        switch (term.getType()) {
            case APPL: {
                IStrategoAppl appl = (IStrategoAppl)term;
                IStrategoTerm[] subterms = Arrays.stream(appl.getAllSubterms()).map(subterm -> Injections.explicate(subterm, injName, factory)).collect(Collectors.toList()).toArray(new IStrategoTerm[appl.getSubtermCount()]);
                result = factory.makeAppl(appl.getConstructor(), subterms, appl.getAnnotations());
                sort = ImploderAttachment.get(term).getSort();
                break;
            }
            case TUPLE: {
                IStrategoTuple tuple2 = (IStrategoTuple)term;
                IStrategoTerm[] subterms = Arrays.stream(tuple2.getAllSubterms()).map(subterm -> Injections.explicate(subterm, injName, factory)).collect(Collectors.toList()).toArray(new IStrategoTerm[tuple2.getSubtermCount()]);
                result = factory.makeTuple(subterms, tuple2.getAnnotations());
                List componentSorts = Arrays.stream(term.getAllSubterms()).map(t -> ImploderAttachment.get(t).getSort()).collect(Collectors.toList());
                sort = "Tuple_" + String.join((CharSequence)"_", componentSorts) + "_";
                break;
            }
            case LIST: {
                IStrategoList list2 = (IStrategoList)term;
                IStrategoTerm[] subterms = Arrays.stream(list2.getAllSubterms()).map(subterm -> Injections.explicate(subterm, injName, factory)).collect(Collectors.toList()).toArray(new IStrategoTerm[list2.getSubtermCount()]);
                result = factory.makeList(subterms, list2.getAnnotations());
                String elementSort = ImploderAttachment.get(term).getElementSort();
                sort = "List_" + elementSort + "_";
                break;
            }
            default: {
                result = term;
                sort = ImploderAttachment.get(term).getSort();
            }
        }
        result = factory.copyAttachments(term, result);
        ImploderAttachment.get(result).clearInjections();
        for (String injection : injections) {
            Optional name2 = (Optional)injName.apply(sort, injection);
            if (!name2.isPresent()) continue;
            IStrategoConstructor cons = factory.makeConstructor((String)name2.get(), 1);
            IStrategoAppl anno = factory.makeAppl(INJ_ANNO, factory.makeString(sort), factory.makeString(injection));
            ImploderAttachment ia = ImploderAttachment.get(result);
            result = factory.makeAppl(cons, new IStrategoTerm[]{result}, factory.makeList(anno));
            sort = injection;
            if (ia == null) continue;
            ImploderAttachment.putImploderAttachment(result, false, sort, ia.getLeftToken(), ia.getRightToken(), false, false, false, false);
        }
        return result;
    }
}

