/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.AbstractParseNode;
import org.spoofax.jsglr.client.Action;
import org.spoofax.jsglr.client.ActionItem;
import org.spoofax.jsglr.client.ActionState;
import org.spoofax.jsglr.client.AmbiguityManager;
import org.spoofax.jsglr.client.Asfix2TreeBuilder;
import org.spoofax.jsglr.client.Disambiguator;
import org.spoofax.jsglr.client.FilterException;
import org.spoofax.jsglr.client.FineGrainedRecovery;
import org.spoofax.jsglr.client.FineGrainedSetting;
import org.spoofax.jsglr.client.Frame;
import org.spoofax.jsglr.client.ITreeBuilder;
import org.spoofax.jsglr.client.IntegratedRecoverySettings;
import org.spoofax.jsglr.client.Link;
import org.spoofax.jsglr.client.Measures;
import org.spoofax.jsglr.client.MultiBadTokenException;
import org.spoofax.jsglr.client.NullTreeBuilder;
import org.spoofax.jsglr.client.ParseException;
import org.spoofax.jsglr.client.ParseNode;
import org.spoofax.jsglr.client.ParseProductionNode;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.client.ParseTimeoutException;
import org.spoofax.jsglr.client.ParserHistory;
import org.spoofax.jsglr.client.Path;
import org.spoofax.jsglr.client.PathListPool;
import org.spoofax.jsglr.client.PooledPathList;
import org.spoofax.jsglr.client.Production;
import org.spoofax.jsglr.client.RangeList;
import org.spoofax.jsglr.client.RecoveryConnector;
import org.spoofax.jsglr.client.RecoveryPerformance;
import org.spoofax.jsglr.client.Reduce;
import org.spoofax.jsglr.client.ReduceLookahead;
import org.spoofax.jsglr.client.SGLRParseResult;
import org.spoofax.jsglr.client.Shift;
import org.spoofax.jsglr.client.State;
import org.spoofax.jsglr.client.TaskCancellationException;
import org.spoofax.jsglr.client.TokenOffset;
import org.spoofax.jsglr.client.indentation.LayoutFilter;
import org.spoofax.jsglr.shared.ArrayDeque;
import org.spoofax.jsglr.shared.BadTokenException;
import org.spoofax.jsglr.shared.SGLRException;
import org.spoofax.jsglr.shared.TokenExpectedException;
import org.spoofax.jsglr.shared.Tools;
import org.spoofax.terms.util.PushbackStringIterator;

public class SGLR {
    private static final boolean ENFORCE_NEWLINE_FILTER = true;
    private static final boolean PARSE_TIME_LAYOUT_FITER = true;
    private int layoutFiltering;
    private int enforcedNewlineSkip = 0;
    private RecoveryPerformance performanceMeasuring;
    private final Set<BadTokenException> collectedErrors = new LinkedHashSet<BadTokenException>();
    public static final int EOF = -1;
    static final int TAB_SIZE = 8;
    protected static boolean WORK_AROUND_MULTIPLE_LOOKAHEAD;
    private static long parseTime;
    private static int parseCount;
    protected Frame startFrame;
    private long startTime;
    protected volatile boolean asyncAborted;
    protected Frame acceptingStack;
    protected Frame lastAcceptingStack;
    protected int lastAcceptTokenSeen;
    protected final ArrayDeque<Frame> activeStacks;
    private ParseTable parseTable;
    private TokenOffset currentToken;
    private int currentTokenOffset = 0;
    private boolean applyCompletionProd = true;
    private boolean readNonLayout = false;
    private int currentIndentation;
    private int tokensSeen;
    protected int lineNumber;
    protected int columnNumber;
    protected int lastLineNumber;
    protected int lastColumnNumber;
    private int startOffset;
    private final ArrayDeque<ActionState> forShifter;
    private ArrayDeque<Frame> forActor;
    private ArrayDeque<Frame> forActorDelayed;
    private int maxBranches;
    private int maxToken;
    private int maxLine;
    private int maxColumn;
    private int maxTokenNumber;
    private AmbiguityManager ambiguityManager;
    protected Disambiguator disambiguator;
    private int rejectCount;
    private int reductionCount;
    protected PushbackStringIterator currentInputStream;
    private PathListPool pathCache = PathListPool.getInstance();
    private ArrayDeque<Frame> activeStacksWorkQueue = new ArrayDeque();
    private ArrayDeque<Frame> recoverStacks;
    private ParserHistory history;
    private RecoveryConnector recoverIntegrator;
    private ITreeBuilder treeBuilder;
    private AbstractParseNode parseTree;
    protected boolean useIntegratedRecovery;
    private boolean triedRecovery = false;
    private boolean isNewCompletionMode;
    private boolean isParseMaxMode;
    private boolean isFineGrainedMode;
    private int fineGrainedStartLocation;
    private int fineGrainedRecoverMax;
    private int cursorLocation;
    private LayoutFilter layoutFilter;
    int count = 0;
    int count2 = 0;
    private static int traceCallCount;

    static {
        parseTime = 0L;
        parseCount = 0;
        traceCallCount = 0;
    }

    public int getCursorLocation() {
        return this.cursorLocation;
    }

    public boolean isSetCursorLocation() {
        return this.cursorLocation > 0 && this.cursorLocation != Integer.MAX_VALUE;
    }

    public void setCompletionParse(boolean isCompletionMode, int cursorLocation) {
        this.isNewCompletionMode = isCompletionMode;
        this.cursorLocation = cursorLocation;
    }

    public void setParseMaxMode(boolean isParseMaxMode) {
        this.isParseMaxMode = isParseMaxMode;
    }

    public void setDisambiguatorTimeout(long timeout) {
        this.disambiguator.setTimeout(timeout);
    }

    protected ArrayDeque<Frame> getRecoverStacks() {
        return this.recoverStacks;
    }

    public Set<BadTokenException> getCollectedErrors() {
        return this.collectedErrors;
    }

    public int getEnforcedNewlineSkips() {
        return this.enforcedNewlineSkip;
    }

    public int getLayoutFilteringCount() {
        return this.layoutFiltering;
    }

    public int getLayoutFilterCallCount() {
        return this.layoutFilter.getFilterCallCount();
    }

    public void setTimeout(int timeout) {
        throw new UnsupportedOperationException("Use org.spoofax.jsglr.io.SGLR for setting a timeout");
    }

    protected void initParseTimer() {
    }

    @Deprecated
    public SGLR(ITermFactory pf, ParseTable parseTable) {
        this(new Asfix2TreeBuilder(pf), parseTable);
    }

    @Deprecated
    public SGLR(ParseTable parseTable) {
        this(new Asfix2TreeBuilder(), parseTable);
    }

    public SGLR(ITreeBuilder treeBuilder, ParseTable parseTable) {
        assert (parseTable != null);
        this.parseTable = parseTable;
        this.activeStacks = new ArrayDeque();
        this.forActor = new ArrayDeque();
        this.forActorDelayed = new ArrayDeque();
        this.forShifter = new ArrayDeque();
        this.disambiguator = new Disambiguator();
        this.useIntegratedRecovery = false;
        this.setUseStructureRecovery(false);
        this.history = new ParserHistory();
        this.setCompletionParse(false, Integer.MAX_VALUE);
        this.setTreeBuilder(treeBuilder);
        this.layoutFilter = new LayoutFilter(parseTable, true);
    }

    protected void setFinegrainedRecoverMode(boolean fineGrainedMode) {
        this.isFineGrainedMode = fineGrainedMode;
        this.recoverStacks = new ArrayDeque();
    }

    protected void setFineGrainedStartLocation(int fineGrainedStartLocation) {
        this.fineGrainedStartLocation = fineGrainedStartLocation;
    }

    protected void setFineGrainedRecoverMax(int fineGrainedRecoverMax) {
        this.fineGrainedRecoverMax = fineGrainedRecoverMax;
    }

    public RecoveryPerformance getPerformanceMeasuring() {
        return this.performanceMeasuring;
    }

    @Deprecated
    public void asyncAbort() {
        this.asyncCancel();
    }

    public void asyncCancel() {
        this.asyncAborted = true;
    }

    public void asyncCancelReset() {
        this.asyncAborted = false;
    }

    @Deprecated
    public static boolean isDebugging() {
        return false;
    }

    public static boolean isLogging() {
        return Tools.logging;
    }

    private Frame initActiveStacks() {
        this.activeStacks.clear();
        Frame st0 = this.newStack(this.parseTable.getInitialState());
        this.addStack(st0);
        return st0;
    }

    public Object parseMax(String input, String filename, String startSymbol) throws BadTokenException, TokenExpectedException, ParseException, SGLRException, InterruptedException {
        this.setParseMaxMode(true);
        return this.parse((String)input, (String)filename, (String)startSymbol).output;
    }

    public Set<IStrategoTerm> findLongestLeftContextReductions(ArrayDeque<Frame> prefixStackStructure, int startOffset, int endOffset, String inputFragment) throws InterruptedException {
        HashSet<AbstractParseNode> maxPrefixReductions = new HashSet<AbstractParseNode>();
        int maxLength = 0;
        int maxPrefixReductionOffset = -1;
        this.initParseVariables(inputFragment, null);
        if (prefixStackStructure != null) {
            this.activeStacks.clear();
            this.acceptingStack = null;
            this.activeStacks.addAll(prefixStackStructure);
        }
        this.currentInputStream.setOffset(startOffset);
        this.tokensSeen = startOffset;
        this.getHistory().setTokenIndex(startOffset);
        do {
            this.readNextToken();
            this.parseCharacter();
            int j = 0;
            while (j < this.forShifter.size()) {
                ActionState as = this.forShifter.get(j);
                if (!this.parseTable.hasRejects() || !as.st.allLinksRejected()) {
                    Frame fr = as.st;
                    int i = 0;
                    while (i < fr.stepsCount) {
                        Link lnk = fr.steps[i];
                        int length = lnk.getLength();
                        AbstractParseNode parseNode = lnk.label;
                        if (length > this.currentInputStream.getOffset() - startOffset) {
                            if (length > maxLength) {
                                maxLength = length;
                                maxPrefixReductionOffset = this.tokensSeen;
                                maxPrefixReductions.clear();
                                maxPrefixReductions.add(parseNode);
                            } else if (length == maxLength && this.tokensSeen == maxPrefixReductionOffset) {
                                maxPrefixReductions.add(parseNode);
                            }
                        }
                        ++i;
                    }
                }
                ++j;
            }
            this.shifter();
        } while (this.tokensSeen < endOffset && this.activeStacks.size() > 0);
        if (this.acceptingStack != null) {
            int i = 0;
            while (i < this.acceptingStack.stepsCount) {
                Link lnk = this.acceptingStack.steps[i];
                int length = lnk.getLength();
                AbstractParseNode parseNode = lnk.label;
                if (length > this.currentInputStream.getOffset() - startOffset) {
                    if (length > maxLength) {
                        maxLength = length;
                        maxPrefixReductionOffset = this.tokensSeen;
                        maxPrefixReductions.clear();
                        maxPrefixReductions.add(parseNode);
                    } else if (length == maxLength && this.tokensSeen == maxPrefixReductionOffset) {
                        maxPrefixReductions.add(parseNode);
                    }
                }
                ++i;
            }
        }
        HashSet<IStrategoTerm> result = new HashSet<IStrategoTerm>();
        for (AbstractParseNode node : maxPrefixReductions) {
            int startReductionOffset = maxPrefixReductionOffset - maxLength - 1;
            assert (startReductionOffset <= startOffset);
            if (this.getTreeBuilder() instanceof NullTreeBuilder) continue;
            try {
                this.getTreeBuilder().reset(startReductionOffset);
                IStrategoTerm candidate = (IStrategoTerm)this.disambiguator.applyFilters(this, node, null, startReductionOffset, this.tokensSeen);
                if (candidate == null) continue;
                result.add(candidate);
            }
            catch (FilterException e) {
                e.printStackTrace();
            }
            catch (SGLRException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public ArrayDeque<Frame> parseInputPart(ArrayDeque<Frame> stackStructure, int startOffset, int endOffset, String inputFragment, boolean useRecovery) throws InterruptedException {
        if (startOffset == endOffset) {
            return stackStructure;
        }
        assert (startOffset < endOffset);
        this.initParseVariables(inputFragment, null);
        this.currentInputStream.setOffset(startOffset);
        this.tokensSeen = startOffset;
        this.getHistory().setTokenIndex(startOffset);
        FineGrainedRecovery fgRecovery = null;
        if (useRecovery) {
            FineGrainedSetting fgSettings = FineGrainedSetting.createDefaultSetting();
            fgSettings.setEndOffsetFragment(endOffset);
            fgRecovery = new FineGrainedRecovery(this, fgSettings);
        }
        if (stackStructure != null) {
            this.activeStacks.clear();
            this.acceptingStack = null;
            this.activeStacks.addAll(stackStructure);
        }
        return this.parseInputPart(endOffset, fgRecovery, useRecovery);
    }

    private ArrayDeque<Frame> parseInputPart(int endParseOffset, FineGrainedRecovery fgRecovery, boolean useRecovery) throws InterruptedException {
        try {
            do {
                assert (this.getHistory().getTokenIndex() == this.currentInputStream.getOffset());
                assert (this.currentInputStream.getOffset() <= endParseOffset);
                this.readNextToken();
                this.history.keepTokenAndState(this);
                this.doParseStep();
                if (this.currentInputStream.getOffset() != endParseOffset || this.activeStacks.size() <= 0) continue;
                ArrayDeque<Frame> stackNodes = new ArrayDeque<Frame>();
                stackNodes.addAll(this.activeStacks);
                ArrayDeque<Frame> arrayDeque = stackNodes;
                return arrayDeque;
            } while (this.getCurrentToken().getToken() != -1 && this.activeStacks.size() > 0);
            if (useRecovery && this.activeStacks.isEmpty() && this.acceptingStack == null) {
                int failureOffset = this.getParserLocation();
                int failureLineIndex = this.getHistory().getLineOfTokenPosition(failureOffset - 1);
                fgRecovery.recover(failureOffset, failureLineIndex);
                if (this.acceptingStack == null && this.activeStacks.size() > 0 && this.currentInputStream.getOffset() != endParseOffset) {
                    ArrayDeque<Frame> arrayDeque = this.parseInputPart(endParseOffset, fgRecovery, useRecovery);
                    return arrayDeque;
                }
            }
            ArrayDeque<Frame> stackNodes = new ArrayDeque<Frame>();
            stackNodes.addAll(this.activeStacks);
            if (this.acceptingStack != null) {
                stackNodes.add(this.acceptingStack);
            }
            ArrayDeque<Frame> arrayDeque = stackNodes;
            return arrayDeque;
        }
        finally {
            this.activeStacks.clear();
            this.activeStacksWorkQueue.clear();
            this.forShifter.clear();
            this.history.clear();
            if (this.recoverStacks != null) {
                this.recoverStacks.clear();
            }
        }
    }

    public SGLRParseResult parse(String input, String filename, String startSymbol) throws BadTokenException, TokenExpectedException, ParseException, SGLRException, InterruptedException {
        this.logBeforeParsing();
        this.initParseVariables(input, filename);
        this.startTime = System.currentTimeMillis();
        this.initParseTimer();
        this.getPerformanceMeasuring().startParse();
        SGLRParseResult result = this.sglrParse(startSymbol);
        return result;
    }

    private SGLRParseResult sglrParse(String startSymbol) throws BadTokenException, TokenExpectedException, ParseException, SGLRException, InterruptedException {
        Object[] result;
        if (this.isParseMaxMode) {
            this.disambiguator.initializeFromParser(this);
        }
        try {
            do {
                Frame accept;
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                this.readNextToken();
                this.history.keepTokenAndState(this);
                this.logBeforeNextParseStep();
                this.doParseStep();
                if (!this.isParseMaxMode || (accept = this.checkImmediateAcceptance(startSymbol)) == null) continue;
                this.lastAcceptingStack = accept;
                this.lastAcceptTokenSeen = this.tokensSeen;
            } while (this.currentToken.getToken() != -1 && this.activeStacks.size() > 0);
            if (this.acceptingStack != null) {
                this.lastAcceptingStack = this.acceptingStack;
                this.lastAcceptTokenSeen = this.tokensSeen;
            } else if (this.isParseMaxMode) {
                this.acceptingStack = this.lastAcceptingStack;
            }
            if (this.acceptingStack == null) {
                this.collectedErrors.add(this.createBadTokenException());
            }
            if (this.useIntegratedRecovery && this.acceptingStack == null) {
                this.recoverIntegrator.recover();
                this.triedRecovery = true;
                if (this.acceptingStack == null && this.activeStacks.size() > 0) {
                    SGLRParseResult sGLRParseResult = this.sglrParse(startSymbol);
                    return sGLRParseResult;
                }
            }
            try {
                this.getPerformanceMeasuring().endParse(this.acceptingStack != null);
            }
            catch (TaskCancellationException e) {
                throw new ParseTimeoutException(this, this.currentToken.getToken(), this.tokensSeen - 1, this.lineNumber, this.columnNumber, this.collectedErrors);
            }
        }
        finally {
            this.activeStacks.clear();
            this.activeStacksWorkQueue.clear();
            this.forShifter.clear();
            this.history.clear();
            if (this.recoverStacks != null) {
                this.recoverStacks.clear();
            }
        }
        this.logAfterParsing();
        if (this.acceptingStack == null) {
            BadTokenException bad = this.createBadTokenException();
            if (this.collectedErrors.isEmpty()) {
                throw bad;
            }
            this.collectedErrors.add(bad);
            throw new MultiBadTokenException(this, this.collectedErrors);
        }
        Link s = this.acceptingStack.findDirectLink(this.startFrame);
        if (s == null) {
            throw new ParseException(this, "Accepting stack has no link");
        }
        assert (s.recoverCount <= s.recoverWeight);
        this.performanceMeasuring.setRecoverCount(s.recoverCount);
        this.logParseResult(s);
        Tools.debug("recoveries: ", s.recoverCount);
        if (this.getTreeBuilder() instanceof NullTreeBuilder) {
            result = null;
        } else {
            this.parseTree = s.label;
            result = this.disambiguator.applyFilters(this, s.label, startSymbol, this.tokensSeen);
            if (this.isParseMaxMode) {
                result = new Object[]{result, this.lastAcceptTokenSeen};
            }
        }
        if (this.triedRecovery && result == null) {
            switch (this.collectedErrors.size()) {
                case 0: {
                    throw new ParseException(this, "Parsing failed without indicating an error, please notify Spoofax developers.");
                }
                case 1: {
                    throw this.collectedErrors.iterator().next();
                }
            }
            throw new MultiBadTokenException(this, this.collectedErrors);
        }
        return new SGLRParseResult(result);
    }

    void readNextToken() {
        this.logCurrentToken();
        this.setCurrentToken(this.getNextToken());
    }

    protected void setCurrentToken(TokenOffset tok) {
        switch (this.currentToken.getToken()) {
            case -2: 
            case 10: {
                this.currentIndentation = 0;
                break;
            }
            case 9: {
                this.currentIndentation = (this.currentIndentation / 8 + 1) * 8;
                break;
            }
            default: {
                ++this.currentIndentation;
            }
        }
        this.currentToken.setToken(tok.getToken());
        this.currentToken.setOffset(tok.getOffset());
    }

    protected TokenOffset getCurrentToken() {
        return this.currentToken;
    }

    protected void doParseStep() throws InterruptedException {
        this.parseCharacter();
        this.shifter();
    }

    private void initParseVariables(String input, String filename) {
        this.forActor.clear();
        this.forActorDelayed.clear();
        this.forShifter.clear();
        this.history.clear();
        this.startFrame = this.initActiveStacks();
        this.currentToken = new TokenOffset();
        this.currentIndentation = 0;
        this.tokensSeen = 0;
        this.currentInputStream = new PushbackStringIterator(input);
        this.acceptingStack = null;
        this.collectedErrors.clear();
        this.history = new ParserHistory();
        this.performanceMeasuring = new RecoveryPerformance();
        this.getTreeBuilder().initializeInput(input, filename);
        PooledPathList.resetPerformanceCounters();
        this.pathCache.resetPerformanceCounters();
        this.ambiguityManager = new AmbiguityManager(input.length());
        this.parseTree = null;
        this.enforcedNewlineSkip = 0;
        this.layoutFiltering = 0;
        if (this.getTreeBuilder().getTokenizer() != null) {
            this.lineNumber = this.getTreeBuilder().getTokenizer().getEndLine();
            this.columnNumber = this.getTreeBuilder().getTokenizer().getEndColumn();
            this.startOffset = this.getTreeBuilder().getTokenizer().getStartOffset();
        } else {
            this.lineNumber = 1;
            this.columnNumber = 0;
        }
    }

    private BadTokenException createBadTokenException() {
        Action action;
        Frame singlePreviousStack;
        Frame frame = singlePreviousStack = this.activeStacks.size() == 1 ? this.activeStacks.get(0) : null;
        if (singlePreviousStack != null && (action = singlePreviousStack.peek().getSingularAction()) != null && action.getActionItems().length == 1) {
            int token;
            StringBuilder expected = new StringBuilder();
            while ((token = action.getSingularRange()) != -2) {
                if (token == -1) {
                    expected.append("EOF");
                } else {
                    expected.appendCodePoint(token);
                }
                ActionItem[] items = action.getActionItems();
                if (items.length != 1 || items[0].type != 2) break;
                Shift shift = (Shift)items[0];
                action = this.parseTable.getState(shift.nextState).getSingularAction();
                if (action != null) continue;
            }
            if (expected.length() > 0) {
                return new TokenExpectedException(this, expected.toString(), this.currentToken.getToken(), this.tokensSeen + this.startOffset - 1, this.lineNumber, this.columnNumber);
            }
        }
        return new BadTokenException(this, this.currentToken.getToken(), this.tokensSeen + this.startOffset - 1, this.lineNumber, this.columnNumber);
    }

    private void shifter() {
        this.logBeforeShifter();
        this.activeStacks.clear();
        ParseProductionNode prod = new ParseProductionNode(this.currentToken.getToken(), this.lastLineNumber, this.lastColumnNumber);
        while (this.forShifter.size() > 0) {
            ActionState as = this.forShifter.remove();
            if (!this.parseTable.hasRejects() || !as.st.allLinksRejected()) {
                Frame st1 = this.findStack(this.activeStacks, as.s);
                if (st1 == null) {
                    st1 = this.newStack(as.s);
                    this.addStack(st1);
                }
                st1.addLink(as.st, prod, 1, this.lastLineNumber, this.lastColumnNumber);
                continue;
            }
            if (!Tools.logging) continue;
            Tools.logger("Shifter: skipping rejected stack with state ", as.st.state.stateNumber);
        }
        this.logAfterShifter();
    }

    protected void addStack(Frame st1) {
        this.activeStacks.addFirst(st1);
    }

    private void parseCharacter() throws InterruptedException {
        this.logBeforeParseCharacter();
        this.activeStacksWorkQueue.clear();
        this.activeStacksWorkQueue.addAll(this.activeStacks);
        this.forActorDelayed.clear();
        this.forShifter.clear();
        while (this.activeStacksWorkQueue.size() > 0 || this.forActor.size() > 0) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            Frame st2 = this.pickStackNodeFromActivesOrForActor(this.activeStacksWorkQueue);
            if (!st2.allLinksRejected()) {
                this.actor(st2);
            }
            if (this.activeStacksWorkQueue.size() != 0 || this.forActor.size() != 0) continue;
            this.fillForActorWithDelayedFrames();
        }
    }

    private void fillForActorWithDelayedFrames() {
        ArrayDeque<Frame> empty = this.forActor;
        this.forActor = this.forActorDelayed;
        empty.clear();
        this.forActorDelayed = empty;
    }

    private Frame pickStackNodeFromActivesOrForActor(ArrayDeque<Frame> actives) {
        Frame st2 = actives.size() > 0 ? actives.remove() : this.forActor.remove();
        return st2;
    }

    private void actor(Frame st2) throws InterruptedException {
        State s = st2.peek();
        this.logBeforeActor(st2, s);
        Action[] actionArray = s.getActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionItem red;
            ActionItem ai;
            int n3;
            int n4;
            ActionItem[] actionItemArray;
            Action action = actionArray[n2];
            if (action.accepts(this.currentToken.getToken())) {
                actionItemArray = action.getActionItems();
                n4 = actionItemArray.length;
                n3 = 0;
                while (n3 < n4) {
                    ai = actionItemArray[n3];
                    switch (ai.type) {
                        case 2: {
                            Shift sh = (Shift)ai;
                            ActionState actState = new ActionState(st2, this.parseTable.getState(sh.nextState));
                            actState.currentToken = this.currentToken.getToken();
                            this.addShiftPair(actState);
                            this.statsRecordParsers();
                            break;
                        }
                        case 1: {
                            red = (Reduce)ai;
                            this.doReductions(st2, red.production);
                            break;
                        }
                        case 4: {
                            red = (ReduceLookahead)ai;
                            if (!this.checkLookahead((ReduceLookahead)red)) break;
                            this.doReductions(st2, ((ReduceLookahead)red).production);
                            break;
                        }
                        case 3: {
                            if (st2.allLinksRejected()) break;
                            this.acceptingStack = st2;
                            if (!Tools.logging) break;
                            Tools.logger("Reached the accept state");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown action type: " + ai.type);
                        }
                    }
                    ++n3;
                }
            } else if (this.reducingNewCompletionProd(action)) {
                actionItemArray = action.getActionItems();
                n4 = actionItemArray.length;
                n3 = 0;
                while (n3 < n4) {
                    ai = actionItemArray[n3];
                    switch (ai.type) {
                        case 1: {
                            red = (Reduce)ai;
                            if (!red.production.isNewCompletionProduction()) break;
                            this.doReductions(st2, red.production);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown action type: " + ai.type);
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private boolean reducingNewCompletionProd(Action action) {
        return this.currentToken.getOffset() >= this.cursorLocation && this.applyCompletionProd;
    }

    private boolean checkLookahead(ReduceLookahead red) {
        return this.doCheckLookahead(red, red.getCharRanges());
    }

    private boolean doCheckLookahead(ReduceLookahead red, RangeList[] charClass) {
        if (charClass.length == 0) {
            return true;
        }
        boolean permit = false;
        int offset = -1;
        int[] readChars = new int[charClass.length];
        int i = 0;
        while (i < charClass.length) {
            int c = this.currentInputStream.read();
            readChars[++offset] = c;
            if (c == -1) {
                permit = true;
                break;
            }
            if (!charClass[i].within(c)) {
                permit = true;
                break;
            }
            ++i;
        }
        int j = offset;
        while (j >= 0) {
            int c = readChars[j];
            if (c != -1) {
                this.currentInputStream.unread(c);
            }
            --j;
        }
        return permit;
    }

    private void addShiftPair(ActionState state) {
        this.forShifter.add(state);
    }

    private void statsRecordParsers() {
        if (this.forShifter.size() > this.maxBranches) {
            this.maxBranches = this.forShifter.size();
            this.maxToken = this.currentToken.getToken();
            this.maxColumn = this.columnNumber;
            this.maxLine = this.lineNumber;
            this.maxTokenNumber = this.tokensSeen;
        }
    }

    private void doReductions(Frame st2, Production prod) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.isNewCompletionMode ? (this.isFineGrainedMode ? prod.isNewCompletionProduction() && !prod.isRecoverProduction() : prod.isRecoverProduction() && !prod.isNewCompletionProduction()) : (this.isFineGrainedMode ? prod.isNewCompletionProduction() && !prod.isRecoverProduction() : prod.isRecoverProduction() || prod.isNewCompletionProduction())) {
            return;
        }
        PooledPathList paths = this.pathCache.create();
        try {
            st2.findAllPaths(paths, prod.arity);
            this.logBeforeDoReductions(st2, prod, paths.size());
            this.reduceAllPaths(prod, paths);
            this.logAfterDoReductions();
        }
        finally {
            this.pathCache.endCreate(paths);
        }
    }

    private void doLimitedReductions(Frame st2, Production prod, Link l) throws InterruptedException {
        if (this.isNewCompletionMode ? (this.isFineGrainedMode ? prod.isNewCompletionProduction() && !prod.isRecoverProduction() : prod.isRecoverProduction() && !prod.isNewCompletionProduction()) : (this.isFineGrainedMode ? prod.isNewCompletionProduction() && !prod.isRecoverProduction() : prod.isRecoverProduction() || prod.isNewCompletionProduction())) {
            return;
        }
        PooledPathList limitedPool = this.pathCache.create();
        try {
            st2.findLimitedPaths(limitedPool, prod.arity, l);
            this.logBeforeLimitedReductions(st2, prod, l, limitedPool);
            this.reduceAllPaths(prod, limitedPool);
        }
        finally {
            this.pathCache.endCreate(limitedPool);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void reduceAllPaths(Production prod, PooledPathList paths) throws InterruptedException {
        int i = 0;
        while (i < paths.size()) {
            block9: {
                State next;
                Frame st0;
                AbstractParseNode[] kids;
                Path path;
                block12: {
                    block13: {
                        block11: {
                            block10: {
                                path = paths.get(i);
                                kids = path.getParseNodes();
                                st0 = path.getEnd();
                                next = this.parseTable.go(st0.state, prod.label);
                                this.logReductionPath(prod, path, st0, next);
                                if (this.layoutFilter.hasValidLayout(prod.label, kids)) break block10;
                                ++this.layoutFiltering;
                                break block9;
                            }
                            this.layoutFiltering += this.layoutFilter.getDisambiguationCount();
                            if (!this.parseTable.getLabel(prod.label).getAttributes().isNewlineEnforced()) break block11;
                            boolean hasNewline = false;
                            int j = kids.length - 1;
                            while (j >= 0) {
                                int status = kids[j].getLayoutStatus();
                                if (status == 2) {
                                    hasNewline = true;
                                    break;
                                }
                                if (status == 0) {
                                    hasNewline = false;
                                    break;
                                }
                                --j;
                            }
                            if (hasNewline) break block11;
                            ++this.enforcedNewlineSkip;
                            break block9;
                        }
                        if (!this.checkMaxRecoverCount(prod, path)) break block9;
                        if (!prod.isRecoverProduction()) break block12;
                        if (this.isFineGrainedMode || !prod.isNewCompletionProduction()) break block13;
                        this.reducer(st0, next, prod, kids, path);
                        break block9;
                    }
                    if (prod.isNewCompletionProduction()) {
                        if (this.currentToken.getOffset() >= this.cursorLocation && this.applyCompletionProd && this.isNewCompletionMode) {
                            this.reducer(st0, next, prod, kids, path);
                            break block9;
                        } else {
                            this.reducerRecoverProduction(st0, next, prod, kids, path);
                        }
                        break block9;
                    } else {
                        this.reducerRecoverProduction(st0, next, prod, kids, path);
                    }
                    break block9;
                }
                this.reducer(st0, next, prod, kids, path);
            }
            ++i;
        }
        if (this.asyncAborted) {
            throw new TaskCancellationException("Long-running parse job aborted");
        }
    }

    private boolean checkMaxRecoverCount(Production prod, Path path) {
        return this.checkRecoverCountLocal(prod, path) && this.checkRecoverCountGlobal(prod, path);
    }

    private boolean checkRecoverCountLocal(Production prod, Path path) {
        return !this.isFineGrainedMode || this.calcRecoverCount(prod, path) <= this.fineGrainedRecoverMax || this.getHistory().getTokenIndex() - path.getLength() < this.fineGrainedStartLocation;
    }

    private boolean checkRecoverCountGlobal(Production prod, Path path) {
        return this.calcRecoverCount(prod, path) <= this.recoverIntegrator.getMaxNumberOfRecoverApplicationsGlobal();
    }

    private void reducer(Frame st0, State s, Production prod, AbstractParseNode[] kids, Path path) throws InterruptedException {
        this.logBeforeReducer(s, prod, path.getLength());
        this.increaseReductionCount();
        int length = path.getLength();
        int numberOfRecoveries = this.calcRecoverCount(prod, path);
        int numberOfCompleted = path.getCompletedCount();
        int insertionNodes = this.countInsertionNodes(kids, false);
        int placeholderNodes = this.countInsertionNodes(kids, true);
        int layoutTerms = this.countLayoutTerms(kids);
        int emptyTerms = this.countEmtpyTerms(kids);
        boolean proposalNode = false;
        boolean nestedProposalNode = false;
        boolean proposalSinglePlaceholder = false;
        if (numberOfCompleted > 1) {
            return;
        }
        if (kids.length > 0) {
            AbstractParseNode rightNode;
            AbstractParseNode leftNode;
            if ((kids[0].containsProposal() || kids[0].containsProposal()) && insertionNodes == kids.length - layoutTerms - emptyTerms - 1 && this.checkRecursiveProd((leftNode = this.getFirstNonAmbNode(kids[0])).getLabel(), prod.label)) {
                return;
            }
            int last = kids.length - 1;
            if ((kids[last].containsProposal() || kids[last].containsProposal()) && insertionNodes == kids.length - layoutTerms - emptyTerms - 1 && this.checkRecursiveProd((rightNode = this.getFirstNonAmbNode(kids[last])).getLabel(), prod.label)) {
                return;
            }
        }
        if (!this.isFineGrainedMode && this.isNewCompletionMode) {
            if (prod.isNewCompletionProduction() && (this.currentToken.getOffset() < this.cursorLocation || !this.applyCompletionProd)) {
                return;
            }
            if (!prod.isNewCompletionProduction() && insertionNodes > 0) {
                if (!this.checkPlaceholderRequirements(kids)) {
                    return;
                }
                if (numberOfCompleted == 0) {
                    if (insertionNodes == 1 && placeholderNodes == 1) {
                        proposalSinglePlaceholder = true;
                    }
                    proposalNode = true;
                } else if (numberOfCompleted > 0) {
                    nestedProposalNode = true;
                }
            }
        }
        if (proposalNode || nestedProposalNode) {
            numberOfCompleted = 1;
        }
        AbstractParseNode t = prod.apply(kids, path.getParentCount() > 0 ? path.getParent().getLink().getLine() : this.lineNumber, path.getParentCount() > 0 ? path.getParent().getLink().getColumn() : this.columnNumber, this.parseTable.getLabel(prod.label).isLayout(), this.parseTable.getLabel(prod.label).getAttributes().isIgnoreLayout(), proposalNode, nestedProposalNode, proposalSinglePlaceholder);
        if (numberOfCompleted == 1) {
            t.setContaintsProposal(true);
        }
        int recoverWeight = this.calcRecoverWeight(prod, path);
        Frame st1 = this.findStack(this.activeStacks, s);
        if (st1 == null) {
            this.addNewStack(st0, s, prod, length, numberOfRecoveries, numberOfCompleted, insertionNodes, recoverWeight, t);
        } else {
            Link nl = st1.findDirectLink(st0);
            if (nl != null) {
                this.logAmbiguity(st0, prod, st1, nl);
                if (prod.isRejectProduction()) {
                    nl.reject();
                }
                if (recoverWeight == 0 && nl.recoverWeight == 0 || nl.isRejected()) {
                    if (prod.isNewCompletionProduction() && nl.length == 1 && nl.placeholderCount == 1) {
                        this.createAmbNode(t, nl);
                    }
                    if (!prod.isNewCompletionProduction()) {
                        if (!nl.hasCompletedLabel && numberOfCompleted == 0) {
                            this.createAmbNode(t, nl);
                        }
                        if (nl.hasCompletedLabel && numberOfCompleted == 0) {
                            nl.label = t;
                            nl.recoverCount = numberOfRecoveries;
                            nl.recoverWeight = recoverWeight;
                            nl.hasCompletedLabel = numberOfCompleted == 1;
                            nl.placeholderCount = insertionNodes;
                        }
                        if (nl.hasCompletedLabel && numberOfCompleted > 0) {
                            this.createAmbNode(t, nl);
                        }
                    }
                } else if (recoverWeight < nl.recoverWeight) {
                    nl.label = t;
                    nl.recoverCount = numberOfRecoveries;
                    nl.recoverWeight = recoverWeight;
                    nl.hasCompletedLabel = numberOfCompleted == 1;
                    nl.placeholderCount = insertionNodes;
                    this.actorOnActiveStacksOverNewLink(nl);
                } else if (recoverWeight == nl.recoverWeight) {
                    nl.label = t;
                }
            } else {
                nl = st1.addLink(st0, t, length, t.getLine(), t.getColumn());
                nl.recoverWeight = recoverWeight;
                nl.recoverCount = numberOfRecoveries;
                nl.hasCompletedLabel = numberOfCompleted == 1;
                nl.placeholderCount = insertionNodes;
                if (prod.isRejectProduction()) {
                    nl.reject();
                    this.increaseRejectCount();
                }
                this.logAddedLink(st0, st1, nl);
                this.actorOnActiveStacksOverNewLink(nl);
            }
        }
    }

    private AbstractParseNode getFirstNonAmbNode(AbstractParseNode abstractParseNode) {
        if (abstractParseNode.isAmbNode()) {
            return this.getFirstNonAmbNode(abstractParseNode.getChildren()[0]);
        }
        return abstractParseNode;
    }

    private boolean checkRecursiveProd(int label, int label2) {
        IStrategoTerm lhsSort2;
        IStrategoTerm lhsSort = this.parseTable.getProduction(label).getSubterm(1);
        return lhsSort.equals(lhsSort2 = this.parseTable.getProduction(label2).getSubterm(1));
    }

    private int countInsertionNodes(AbstractParseNode[] kids, boolean countOnlyPlaceholders) {
        int insertions = 0;
        int i = 0;
        while (i < kids.length) {
            boolean isAmbInsertion = this.isAmbInsertion(kids[i], countOnlyPlaceholders);
            if (kids[i].isPlaceholderInsertionNode() || isAmbInsertion) {
                ++insertions;
            }
            if (!countOnlyPlaceholders && kids[i].isLiteralCompletionNode()) {
                ++insertions;
            }
            ++i;
        }
        return insertions;
    }

    private int countEmtpyTerms(AbstractParseNode[] kids) {
        int emptyTerms = 0;
        int i = 0;
        while (i < kids.length) {
            if (!(!kids[i].isEmpty() || kids[i].isLayout() || kids[i].isProposal() || kids[i].isNestedProposal() || kids[i].isPlaceholderInsertionNode() || kids[i].isLiteralCompletionNode())) {
                ++emptyTerms;
            }
            ++i;
        }
        return emptyTerms;
    }

    private int countLayoutTerms(AbstractParseNode[] kids) {
        int layoutTerms = 0;
        int i = 0;
        while (i < kids.length) {
            if (kids[i].isLayout()) {
                ++layoutTerms;
            }
            ++i;
        }
        return layoutTerms;
    }

    boolean isLayout(int token) {
        return token == 32 || token == 10 || token == 9;
    }

    private boolean checkPlaceholderRequirements(AbstractParseNode[] kids) {
        if (this.currentToken.getOffset() < this.cursorLocation) {
            return false;
        }
        return this.onlyAdjacentPlaceholders(kids);
    }

    private boolean onlyAdjacentPlaceholders(AbstractParseNode[] kids) {
        boolean seenPlaceholder = false;
        boolean changedTerm = false;
        boolean onlyPlaceholders = true;
        int i = 0;
        while (i < kids.length) {
            boolean isAmbPlaceholder = this.isAmbInsertion(kids[i], false);
            if (kids[i].isPlaceholderInsertionNode() || kids[i].isLiteralCompletionNode() || isAmbPlaceholder) {
                if (seenPlaceholder && changedTerm) {
                    return false;
                }
                seenPlaceholder = true;
            } else if (!kids[i].isLayout() && !this.isEmptyNode(kids[i])) {
                onlyPlaceholders = false;
                if (seenPlaceholder) {
                    changedTerm = true;
                }
            }
            ++i;
        }
        return !onlyPlaceholders;
    }

    private boolean isEmptyNode(AbstractParseNode abstractParseNode) {
        return abstractParseNode.getChildren().length == 0;
    }

    private boolean isAmbInsertion(AbstractParseNode abstractParseNode, boolean countOnlyPlaceholders) {
        boolean isAmbInsertion = false;
        if (abstractParseNode.isAmbNode()) {
            AbstractParseNode[] ambNodes = abstractParseNode.getChildren();
            int i = 0;
            while (i < ambNodes.length) {
                if (ambNodes[i].isPlaceholderInsertionNode()) {
                    isAmbInsertion = true;
                    break;
                }
                if (!countOnlyPlaceholders && ambNodes[i].isLiteralCompletionNode()) {
                    isAmbInsertion = true;
                    break;
                }
                if (ambNodes[i].isAmbNode() && (isAmbInsertion = this.isAmbInsertion(ambNodes[i], countOnlyPlaceholders))) break;
                ++i;
            }
        }
        return isAmbInsertion;
    }

    private void reducerRecoverProduction(Frame st0, State s, Production prod, AbstractParseNode[] kids, Path path) {
        Link lnActive;
        assert (prod.isRecoverProduction());
        int length = path.getLength();
        int numberOfRecoveries = this.calcRecoverCount(prod, path);
        int recoverWeight = this.calcRecoverWeight(prod, path);
        AbstractParseNode t = prod.apply(kids, this.lineNumber, this.columnNumber, this.parseTable.getLabel(prod.label).isLayout(), this.parseTable.getLabel(prod.label).getAttributes().isIgnoreLayout(), false, false, false);
        Frame stActive = this.findStack(this.activeStacks, s);
        if (stActive != null && (lnActive = stActive.findDirectLink(st0)) != null) {
            return;
        }
        Frame stRecover = this.findStack(this.recoverStacks, s);
        if (stRecover != null) {
            Link nlRecover = stRecover.findDirectLink(st0);
            if (nlRecover != null) {
                return;
            }
            nlRecover = stRecover.addLink(st0, t, length, t.getLine(), t.getColumn());
            nlRecover.recoverCount = numberOfRecoveries;
            nlRecover.recoverWeight = recoverWeight;
            return;
        }
        this.addNewRecoverStack(st0, s, prod, length, numberOfRecoveries, recoverWeight, t);
    }

    private void createAmbNode(AbstractParseNode t, Link nl) {
        nl.addAmbiguity(t, this.tokensSeen);
        this.ambiguityManager.increaseAmbiguityCalls();
    }

    private Link addNewStack(Frame st0, State s, Production prod, int length, int numberOfRecoveries, int numberOfCompleted, int numberOfPlaceholders, int recoverWeight, AbstractParseNode t) {
        Frame st1 = this.newStack(s);
        Link nl = st1.addLink(st0, t, length, t.getLine(), t.getColumn());
        nl.recoverCount = numberOfRecoveries;
        nl.recoverWeight = recoverWeight;
        nl.hasCompletedLabel = numberOfCompleted == 1;
        nl.placeholderCount = numberOfPlaceholders;
        this.addStack(st1);
        this.forActorDelayed.addFirst(st1);
        if (prod.isRejectProduction()) {
            if (Tools.logging) {
                Tools.logger("Reject [new]");
            }
            nl.reject();
            this.increaseRejectCount();
        }
        return nl;
    }

    private void addNewRecoverStack(Frame st0, State s, Production prod, int length, int numberOfRecoveries, int recoverWeight, AbstractParseNode t) {
        if (!this.isFineGrainedMode || prod.isRejectProduction()) {
            return;
        }
        Frame st1 = this.newStack(s);
        Link nl = st1.addLink(st0, t, length, t.getLine(), t.getColumn());
        nl.recoverCount = numberOfRecoveries;
        nl.recoverWeight = recoverWeight;
        this.recoverStacks.addFirst(st1);
    }

    private void actorOnActiveStacksOverNewLink(Link nl) throws InterruptedException {
        int sz = this.activeStacks.size();
        int i = 0;
        while (i < sz) {
            int pos = this.activeStacks.size() - sz + i;
            Frame st2 = this.activeStacks.get(pos);
            if (!(st2.allLinksRejected() || this.inReduceStacks(this.forActor, st2) || this.inReduceStacks(this.forActorDelayed, st2))) {
                Action[] actionArray = st2.peek().getActions();
                int n = actionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Action action = actionArray[n2];
                    if (action.accepts(this.currentToken.getToken())) {
                        ActionItem[] actionItemArray = action.getActionItems();
                        int n3 = actionItemArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ActionItem ai = actionItemArray[n4];
                            switch (ai.type) {
                                case 1: {
                                    Reduce red = (Reduce)ai;
                                    this.doLimitedReductions(st2, red.production, nl);
                                    break;
                                }
                                case 4: {
                                    ReduceLookahead red2 = (ReduceLookahead)ai;
                                    if (!this.checkLookahead(red2)) break;
                                    this.doLimitedReductions(st2, red2.production, nl);
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            ++i;
        }
    }

    private int calcRecoverCount(Production prod, Path path) {
        int result = path.getRecoverCount();
        if (this.isNewCompletionMode && !this.isFineGrainedMode && prod.isNewCompletionProduction()) {
            return result;
        }
        if (prod.isRecoverProduction() || prod.isCompletionProduction()) {
            ++result;
        }
        return result;
    }

    private int calcRecoverWeight(Production prod, Path path) {
        int result = path.getRecoverWeight();
        if (this.isNewCompletionMode && !this.isFineGrainedMode && prod.isNewCompletionProduction()) {
            return result;
        }
        if (prod.isRecoverProduction() || prod.isCompletionProduction()) {
            ++result;
            if (path.getLength() > 0 && !prod.isCompletionProduction()) {
                ++result;
            }
        }
        return result;
    }

    private boolean inReduceStacks(Queue<Frame> q, Frame frame) {
        return q.contains(frame);
    }

    protected Frame newStack(State s) {
        return new Frame(s);
    }

    private void increaseReductionCount() {
        ++this.reductionCount;
    }

    protected void increaseRejectCount() {
        ++this.rejectCount;
    }

    protected int getRejectCount() {
        return this.rejectCount;
    }

    Frame findStack(ArrayDeque<Frame> stacks, State s) {
        int desiredState = s.stateNumber;
        int size = stacks.size();
        int i = 0;
        while (i < size) {
            Frame stack = stacks.get(i);
            if (stack.state.stateNumber == desiredState) {
                return stack;
            }
            ++i;
        }
        return null;
    }

    private TokenOffset getNextToken() {
        int ch = this.currentInputStream.read();
        TokenOffset to2 = new TokenOffset(ch, this.currentTokenOffset);
        if (this.applyCompletionProd && this.readNonLayout) {
            this.setApplyCompletionProd(false);
        }
        if (this.currentTokenOffset >= this.cursorLocation && !this.isLayout(ch)) {
            this.readNonLayout = true;
        }
        this.updateLineAndColumnInfo(ch);
        if (ch == -1) {
            return new TokenOffset(-1, Integer.MAX_VALUE);
        }
        ++this.currentTokenOffset;
        return to2;
    }

    protected void updateLineAndColumnInfo(int ch) {
        ++this.tokensSeen;
        this.lastLineNumber = this.lineNumber++;
        this.lastColumnNumber = this.columnNumber++;
        switch (ch) {
            case 10: {
                this.columnNumber = 0;
                break;
            }
            case 9: {
                this.columnNumber = (this.columnNumber / 8 + 1) * 8;
                break;
            }
            case -1: {
                break;
            }
        }
    }

    public ParseTable getParseTable() {
        return this.parseTable;
    }

    public void setTreeBuilder(ITreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        this.parseTable.initializeTreeBuilder(treeBuilder);
    }

    public ITreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    AmbiguityManager getAmbiguityManager() {
        return this.ambiguityManager;
    }

    public long getAmbiguitiesCount() {
        return this.disambiguator.getAmbiguityCount();
    }

    public Disambiguator getDisambiguator() {
        return this.disambiguator;
    }

    public void setDisambiguator(Disambiguator disambiguator) {
        this.disambiguator = disambiguator;
    }

    @Deprecated
    public ITermFactory getFactory() {
        return this.parseTable.getFactory();
    }

    protected int getReductionCount() {
        return this.reductionCount;
    }

    protected int getRejectionCount() {
        return this.rejectCount;
    }

    static void TRACE(String string) {
        System.out.println("[" + traceCallCount + "] " + string + "\n");
        ++traceCallCount;
    }

    private String dumpActiveStacks() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (this.activeStacks == null) {
            sb.append(" GSS unitialized");
        } else {
            sb.append("{").append(this.activeStacks.size()).append("} ");
            for (Frame f : this.activeStacks) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(f.dumpStack());
                first = false;
            }
        }
        return sb.toString();
    }

    private void logParseResult(Link s) {
        if (Tools.measuring) {
            Measures m = new Measures();
            m.setTime(System.currentTimeMillis() - this.startTime);
            m.setReductionCount(this.reductionCount);
            m.setFramesCreated(Frame.framesCreated);
            m.setLinkedCreated(Link.linksCreated);
            m.setAvoidCount(s.recoverCount);
            m.setParseTime(parseTime);
            Measures.setParseCount(++parseCount);
            m.setAverageParseTime((int)parseTime / parseCount);
            m.setRecoverTime(-1L);
            Tools.setMeasures(m);
        }
    }

    private void logBeforeParsing() {
    }

    private void logAfterParsing() throws BadTokenException, TokenExpectedException {
        if (SGLR.isLogging()) {
            Tools.logger("Number of lines: ", this.lineNumber);
            Tools.logger("Maximum ", this.maxBranches, " parse branches reached at token ", this.logCharify(this.maxToken), ", line ", this.maxLine, ", column ", this.maxColumn, " (token #", this.maxTokenNumber, ")");
            long elapsed = System.currentTimeMillis() - this.startTime;
            Tools.logger("Parse time: " + (float)elapsed / 1000.0f + "s");
        }
    }

    private void logCurrentToken() {
        if (SGLR.isLogging()) {
            Tools.logger("Current token (#", this.tokensSeen, "): ", this.logCharify(this.currentToken.getToken()));
        }
    }

    private void logAfterShifter() {
    }

    private void logBeforeShifter() {
        if (Tools.logging) {
            Tools.logger("#", this.tokensSeen, ": shifting ", this.forShifter.size(), " parser(s) -- token ", this.logCharify(this.currentToken.getToken()), ", line ", this.lineNumber, ", column ", this.columnNumber);
        }
    }

    private void logBeforeParseCharacter() {
    }

    private void logBeforeNextParseStep() {
    }

    private String logCharify(int currentToken) {
        switch (currentToken) {
            case 32: {
                return "\\32";
            }
            case -1: {
                return "EOF";
            }
            case 10: {
                return "\\n";
            }
            case 0: {
                return "\\0";
            }
        }
        return new String(Character.toChars(currentToken));
    }

    private void logBeforeActor(Frame st2, State s) {
        Object actionItems = null;
    }

    private void logAfterDoReductions() {
    }

    private void logReductionPath(Production prod, Path path, Frame st0, State next) {
        if (Tools.logging) {
            Tools.logger("Goto(", st0.peek().stateNumber, ",", String.valueOf(prod.label) + ") == ", next.stateNumber);
        }
    }

    private void logBeforeDoReductions(Frame st2, Production prod, int pathsCount) {
    }

    private void logBeforeLimitedReductions(Frame st2, Production prod, Link l, PooledPathList paths) {
    }

    private void logReductionInfo(Frame st2, Production prod) {
        Tools.debug(" state : ", st2.peek().stateNumber);
        Tools.debug(" token : ", this.currentToken);
        Tools.debug(" label : ", prod.label);
        Tools.debug(" arity : ", prod.arity);
        Tools.debug(" stack : ", st2.dumpStack());
    }

    private void logAddedLink(Frame st0, Frame st1, Link nl) {
    }

    private void logBeforeReducer(State s, Production prod, int length) {
        if (Tools.logging) {
            Tools.logger("Reducing; state ", s.stateNumber, ", token: ", this.logCharify(this.currentToken.getToken()), ", production: ", prod.label);
        }
    }

    private void TRACE_ActiveStacks() {
        SGLR.TRACE("SG_ - #active stacks: " + this.activeStacks.size());
        SGLR.TRACE("SG_ - #for_actor stacks: " + this.forActor.size());
        SGLR.TRACE("SG_ - #for_actor_delayed stacks: " + this.forActorDelayed.size());
    }

    private void logAmbiguity(Frame st0, Production prod, Frame st1, Link nl) {
        if (Tools.logging) {
            Tools.logger("Ambiguity: direct link ", st0.state.stateNumber, " -> ", st1.state.stateNumber, " ", prod.isRejectProduction() ? "{reject}" : "");
            if (nl.label.isParseNode()) {
                Tools.logger("nl is ", nl.isRejected() ? "{reject}" : "", " for ", ((ParseNode)nl.label).getLabel());
            }
        }
    }

    public AbstractParseNode getParseTree() {
        return this.parseTree;
    }

    private Frame checkImmediateAcceptance(String startSymbol) throws InterruptedException {
        if (this.acceptingStack == null) {
            int tmpToken = this.currentToken.getToken();
            int tmpTokenOffset = this.currentToken.getOffset();
            ArrayDeque<Frame> tmpActiveStacks = new ArrayDeque<Frame>(this.activeStacks);
            ArrayDeque<Frame> tmpForActor = new ArrayDeque<Frame>(this.forActor);
            this.currentToken.setToken(-1);
            this.currentToken.setOffset(Integer.MAX_VALUE);
            try {
                this.parseCharacter();
            }
            finally {
                this.currentToken.setToken(tmpToken);
                this.currentToken.setOffset(tmpTokenOffset);
                this.activeStacks.clear();
                this.activeStacks.addAll(tmpActiveStacks);
                this.forActor.clear();
                this.forActor.addAll(tmpForActor);
            }
        }
        if (this.acceptingStack != null) {
            AbstractParseNode node = null;
            try {
                node = this.disambiguator.applyTopSortFilter(startSymbol, this.acceptingStack.findDirectLink((Frame)this.startFrame).label);
            }
            catch (SGLRException sGLRException) {
                // empty catch block
            }
            if (node == null) {
                this.acceptingStack = null;
            }
        }
        Frame result = this.acceptingStack;
        this.acceptingStack = null;
        return result;
    }

    public boolean getApplyCompletionProd() {
        return this.applyCompletionProd;
    }

    public boolean getReadNonLayout() {
        return this.readNonLayout;
    }

    public void setUseStructureRecovery(boolean useRecovery) {
        this.useIntegratedRecovery = useRecovery;
        this.recoverIntegrator = new RecoveryConnector(this);
    }

    public void setUseStructureRecovery(boolean useRecovery, IntegratedRecoverySettings settings, FineGrainedSetting fgSettings) {
        this.useIntegratedRecovery = useRecovery;
        this.recoverIntegrator = new RecoveryConnector(this, settings, fgSettings);
    }

    public boolean isNewCompletionMode() {
        return this.isNewCompletionMode;
    }

    public void setNewCompletionMode(boolean isNewCompletionMode) {
        this.isNewCompletionMode = isNewCompletionMode;
    }

    public ParserHistory getHistory() {
        return this.history;
    }

    public int getParserLocation() {
        return this.getHistory().getTokenIndex();
    }

    public void setReadNonLayout(boolean readNonLayout) {
        this.readNonLayout = readNonLayout;
    }

    public void setApplyCompletionProd(boolean applyCompletionProd) {
        this.applyCompletionProd = applyCompletionProd;
    }
}

