/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.io.Serializable;
import java.util.ArrayList;
import org.spoofax.jsglr.client.AbstractParseNode;
import org.spoofax.jsglr.client.Link;
import org.spoofax.jsglr.client.Path;
import org.spoofax.jsglr.client.PooledPathList;
import org.spoofax.jsglr.client.State;

public class Frame
implements Serializable {
    private static final long serialVersionUID = -4757644376472129935L;
    public static int framesCreated = 0;
    public final State state;
    protected Link[] steps;
    protected int stepsCount;

    public Frame(State s) {
        this.state = s;
        this.steps = new Link[20];
        this.stepsCount = 0;
        ++framesCreated;
    }

    public boolean allLinksRejected() {
        if (this.stepsCount == 0) {
            return false;
        }
        int i = 0;
        while (i < this.stepsCount) {
            if (!this.steps[i].isRejected()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public State peek() {
        return this.state;
    }

    public Link peekLink() {
        if (this.stepsCount == 0) {
            return null;
        }
        return this.steps[0];
    }

    public Link[] peekLinks() {
        return this.steps;
    }

    public void findAllPaths(PooledPathList pool, int arity2) throws InterruptedException {
        this.doComputePathsToRoot(pool, null, arity2, 0, 0);
    }

    private void doComputePathsToRoot(PooledPathList pool, Path node, int arity2, int parentCount, int length) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (arity2 == 0) {
            pool.rememberPath(node, null, this, length, parentCount);
        } else {
            int i = 1;
            while (i <= this.stepsCount) {
                Link link = this.steps[this.stepsCount - i];
                Path n = pool.makePath(node, link, this, link.getLength(), parentCount);
                link.parent.doComputePathsToRoot(pool, n, arity2 - 1, parentCount + 1, length + link.getLength());
                ++i;
            }
        }
    }

    public Frame getRoot() {
        if (this.stepsCount == 0) {
            return this;
        }
        return this.steps[0].parent.getRoot();
    }

    public Link findDirectLink(Frame st0) {
        int i = 0;
        while (i < this.stepsCount) {
            if (this.steps[i].parent == st0) {
                return this.steps[i];
            }
            ++i;
        }
        return null;
    }

    public ArrayList<Link> getAllLinks() {
        ArrayList<Link> links = new ArrayList<Link>();
        int i = 0;
        while (i < this.stepsCount) {
            links.add(this.steps[i]);
            ++i;
        }
        return links;
    }

    public Link addLink(Frame st0, AbstractParseNode n, int length, int line, int column) {
        if (this.stepsCount >= this.steps.length) {
            this.resizeSteps();
        }
        Link link = new Link(st0, n, length, line, column);
        this.steps[this.stepsCount++] = link;
        return link;
    }

    public Link addLink(Link ln) {
        if (this.stepsCount >= this.steps.length) {
            this.resizeSteps();
        }
        Link link = ln;
        this.steps[this.stepsCount++] = link;
        return link;
    }

    private void resizeSteps() {
        Link[] newSteps = new Link[this.steps.length * 2];
        System.arraycopy(this.steps, 0, newSteps, 0, this.steps.length);
        this.steps = newSteps;
    }

    public String dumpStack() {
        StringBuilder sb = new StringBuilder();
        sb.append("GSS [\n").append(this.doDumpStack(2)).append("\n  ]");
        return sb.toString();
    }

    public String doDumpStack(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(this.state.stateNumber);
        if (this.stepsCount > 1) {
            sb.append(" ( ");
            Link[] linkArray = this.steps;
            int n = this.steps.length;
            int n2 = 0;
            while (n2 < n) {
                Link s = linkArray[n2];
                if (s == null) break;
                sb.append(s.parent.doDumpStack(indent + 1));
                sb.append(" | ");
                ++n2;
            }
            sb.append(")");
        } else {
            Link[] linkArray = this.steps;
            int n = this.steps.length;
            int n3 = 0;
            while (n3 < n) {
                Link s = linkArray[n3];
                if (s == null) break;
                sb.append(" <").append(s.label).append("> ").append(s.parent.state.stateNumber).append("\n");
                if (indent <= 5) {
                    sb.append(s.parent.doDumpStack(indent + 1));
                }
                ++n3;
            }
        }
        return sb.toString();
    }

    public String dumpStackCompact() {
        StringBuilder sb = new StringBuilder();
        sb.append("GSS [").append(this.doDumpStackCompact()).append(" ]");
        return sb.toString();
    }

    public String doDumpStackCompact() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(this.state.stateNumber);
        if (this.stepsCount > 1) {
            sb.append(" ( ");
            Link[] linkArray = this.steps;
            int n = this.steps.length;
            int n2 = 0;
            while (n2 < n) {
                Link s = linkArray[n2];
                if (s == null) break;
                sb.append(s.parent.doDumpStackCompact());
                sb.append(" | ");
                ++n2;
            }
            sb.append(")");
        } else {
            Link[] linkArray = this.steps;
            int n = this.steps.length;
            int n3 = 0;
            while (n3 < n) {
                Link s = linkArray[n3];
                if (s == null) break;
                sb.append(", ").append(s.parent.doDumpStackCompact());
                ++n3;
            }
        }
        return sb.toString();
    }

    public void findLimitedPaths(PooledPathList pool, int arity2, Link l) throws InterruptedException {
        if (this.findLink(arity2, l)) {
            this.doComputePathsToRoot(pool, null, l, false, arity2, 0, 0);
        }
    }

    private void TRACE_DumpLinks(Link[] st2) {
        int i = 0;
        while (i < this.stepsCount) {
            Link link = st2[this.stepsCount - i - 1];
            ++i;
        }
    }

    private boolean findLink(int arity2, Link l0) {
        if (arity2 > 0) {
            int i = 0;
            while (i < this.stepsCount) {
                Link l1 = this.steps[this.stepsCount - i - 1];
                if (l0 == l1) {
                    return true;
                }
                if (arity2 > 1 && l1.parent.findLink(arity2 - 1, l0)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void doComputePathsToRoot(PooledPathList pool, Path node, Link l, boolean seen, int arity2, int parentCount, int length) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (arity2 == 0 && seen) {
            pool.rememberPath(node, null, this, length, parentCount);
        } else if (arity2 > 0) {
            int i = 0;
            while (i < this.stepsCount) {
                Link ln = this.steps[this.stepsCount - i - 1];
                boolean seenIt = seen || ln == l;
                Path n = pool.makePath(node, ln, this, ln.getLength(), parentCount);
                ln.parent.doComputePathsToRoot(pool, n, l, seenIt, arity2 - 1, parentCount + 1, length + ln.getLength());
                ++i;
            }
        }
    }

    public void clear() {
        if (this.steps != null) {
            int i = 0;
            while (i < this.stepsCount) {
                this.steps[i].clear();
                this.steps[i] = null;
                ++i;
            }
            this.steps = null;
            this.stepsCount = 0;
        }
    }
}

