/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.terms;

import java.util.HashMap;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.StrategoAnnotation;

public class TermConverter {
    private final ITermFactory factory;
    private final HashMap<IStrategoConstructor, IStrategoConstructor> constructors = new HashMap();
    private boolean isOriginEnabled;

    public TermConverter(ITermFactory factory) {
        this.factory = factory;
    }

    public void setOriginEnabled(boolean isOriginEnabled) {
        this.isOriginEnabled = isOriginEnabled;
    }

    public IStrategoTerm[] convertAll(IStrategoTerm[] terms) {
        IStrategoTerm[] results = new IStrategoTerm[terms.length];
        int i = 0;
        while (i < terms.length) {
            results[i] = this.convert(terms[i]);
            ++i;
        }
        return results;
    }

    public static IStrategoTerm convert(ITermFactory factory, IStrategoTerm term) {
        return new TermConverter(factory).convert(term);
    }

    public IStrategoTerm convert(IStrategoTerm term) {
        IStrategoTerm result;
        switch (term.getType()) {
            case APPL: {
                IStrategoAppl appl = (IStrategoAppl)term;
                IStrategoTerm[] terms = appl.getAllSubterms();
                IStrategoTerm[] subTerms = new IStrategoTerm[terms.length];
                int i = 0;
                while (i < terms.length) {
                    subTerms[i] = this.convert(terms[i]);
                    ++i;
                }
                IStrategoConstructor ctor = this.convert(appl.getConstructor());
                result = this.annotate(this.factory.makeAppl(ctor, subTerms), appl);
                break;
            }
            case LIST: {
                IStrategoList list2 = (IStrategoList)term;
                IStrategoTerm[] terms2 = list2.getAllSubterms();
                IStrategoTerm[] subTerms2 = new IStrategoTerm[terms2.length];
                int i = 0;
                while (i < terms2.length) {
                    subTerms2[i] = this.convert(terms2[i]);
                    ++i;
                }
                result = this.annotate(this.factory.makeList(subTerms2), list2);
                break;
            }
            case CTOR: {
                result = this.convert((IStrategoConstructor)term);
                break;
            }
            case INT: {
                result = this.convert((IStrategoInt)term);
                break;
            }
            case REAL: {
                result = this.convert((IStrategoReal)term);
                break;
            }
            case STRING: {
                result = this.convert((IStrategoString)term);
                break;
            }
            case TUPLE: {
                result = this.convert((IStrategoTuple)term);
                break;
            }
            case BLOB: {
                result = term;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown term type: " + term.getClass().getName());
            }
        }
        if (this.isOriginEnabled) {
            this.factory.replaceTerm(result, term);
        }
        return result;
    }

    public IStrategoTerm convertShallow(IStrategoTerm term, IStrategoTerm[] kids, IStrategoList annos) {
        switch (term.getType()) {
            case APPL: {
                IStrategoConstructor cons = ((IStrategoAppl)term).getConstructor();
                return this.factory.makeAppl(cons, kids, annos);
            }
            case LIST: {
                return this.factory.makeList(kids, annos);
            }
            case INT: {
                int i = ((IStrategoInt)term).intValue();
                return this.factory.annotateTerm(this.factory.makeInt(i), annos);
            }
            case REAL: {
                double r = ((IStrategoReal)term).realValue();
                return this.factory.annotateTerm(this.factory.makeReal(r), annos);
            }
            case STRING: {
                String s = ((IStrategoString)term).stringValue();
                return this.factory.annotateTerm(this.factory.makeString(s), annos);
            }
            case TUPLE: {
                return this.factory.makeTuple(kids, annos);
            }
            case BLOB: {
                return new StrategoAnnotation(this.factory, term, annos);
            }
            case CTOR: {
                return this.convert((IStrategoConstructor)term);
            }
        }
        throw new IllegalStateException("Unknown term type: " + term.getClass().getName());
    }

    public final IStrategoAppl convert(IStrategoAppl term) {
        IStrategoTerm[] subTerms = this.convertAll(term.getAllSubterms());
        IStrategoConstructor ctor = this.convert(term.getConstructor());
        return this.annotate(this.factory.makeAppl(ctor, subTerms), term);
    }

    public IStrategoConstructor convert(IStrategoConstructor constructor) {
        IStrategoConstructor cached = this.constructors.get(constructor);
        if (cached == null) {
            cached = this.factory.makeConstructor(constructor.getName(), constructor.getArity());
            this.constructors.put(constructor, cached);
        }
        return cached;
    }

    public IStrategoInt convert(IStrategoInt term) {
        if (term.isUniqueValueTerm()) {
            throw new IllegalArgumentException("Cannot recreate a tree that contains <newterm> terms:" + term);
        }
        return this.annotate(this.factory.makeInt(term.intValue()), term);
    }

    public final IStrategoList convert(IStrategoList term) {
        IStrategoTerm[] subterms = this.convertAll(term.getAllSubterms());
        return this.annotate(this.factory.makeList(subterms), term);
    }

    public IStrategoReal convert(IStrategoReal term) {
        return this.annotate(this.factory.makeReal(term.realValue()), term);
    }

    public IStrategoString convert(IStrategoString term) {
        return this.annotate(this.factory.makeString(term.stringValue()), term);
    }

    public IStrategoTuple convert(IStrategoTuple term) {
        IStrategoTerm[] subterms = this.convertAll(term.getAllSubterms());
        return this.annotate(this.factory.makeTuple(subterms), term);
    }

    protected <T extends IStrategoTerm> T annotate(T term, T input) {
        IStrategoList annotations = input.getAnnotations();
        if (annotations == null || annotations.isEmpty()) {
            return term;
        }
        return (T)this.factory.annotateTerm(term, this.convert(annotations));
    }
}

