/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.stratego.All;
import org.spoofax.interpreter.stratego.Hook;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;

public class One
extends Strategy {
    protected Strategy body;

    public One(Strategy body) {
        this.body = body;
    }

    @Override
    public IConstruct eval(IContext env) throws InterpreterException {
        One.debug("One.eval() - ", env.current());
        IStrategoTerm t = env.current();
        switch (t.getType()) {
            case INT: 
            case REAL: 
            case STRING: {
                return this.getHook().pop().onFailure(env);
            }
            case APPL: {
                return this.eval(env, 0, (IStrategoTerm[])t.getAllSubterms().clone());
            }
            case LIST: 
            case TUPLE: {
                IStrategoTerm[] subterms = t.getAllSubterms();
                assert (All.isCopy(t, subterms));
                return this.eval(env, 0, subterms);
            }
            case BLOB: {
                return this.getHook().pop().onFailure(env);
            }
        }
        throw new InterpreterException("Unknown ATerm type " + (Object)((Object)t.getType()));
    }

    protected IConstruct eval(IContext env, final int n, final IStrategoTerm[] list2) throws InterpreterException {
        final IStrategoTerm old = env.current();
        if (n >= old.getSubtermCount()) {
            return this.getHook().pop().onFailure(env);
        }
        final One th = this;
        env.setCurrent(list2[n]);
        this.body.getHook().push(new Hook(){

            @Override
            public IConstruct onFailure(IContext env) throws InterpreterException {
                env.setCurrent(old);
                return One.this.eval(env, n + 1, list2);
            }

            @Override
            public IConstruct onSuccess(IContext env) throws InterpreterException {
                list2[n] = env.current();
                switch (old.getType()) {
                    case LIST: {
                        env.setCurrent(env.getFactory().replaceList(list2, (IStrategoList)old));
                        break;
                    }
                    case APPL: {
                        IStrategoAppl appl = (IStrategoAppl)old;
                        env.setCurrent(env.getFactory().replaceAppl(appl.getConstructor(), list2, (IStrategoAppl)old));
                        break;
                    }
                    case TUPLE: {
                        env.setCurrent(env.getFactory().replaceTuple(list2, (IStrategoTuple)old));
                        break;
                    }
                    default: {
                        throw new InterpreterException("Children of neither a list nor an appl.");
                    }
                }
                return th.getHook().pop().onSuccess(env);
            }
        });
        return this.body;
    }

    @Override
    public void prettyPrint(StupidFormatter sf) {
        sf.append("One(\n");
        sf.bump(4);
        this.body.prettyPrint(sf);
        sf.append(")");
        sf.unbump(4);
    }
}

