/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.stratego.Hook;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;

public class All
extends Strategy {
    protected Strategy body;

    public All(Strategy body) {
        this.body = body;
    }

    @Override
    public IConstruct eval(IContext env) throws InterpreterException {
        All.debug("All.eval() - ", env.current());
        IStrategoTerm t = env.current();
        switch (t.getType()) {
            case INT: 
            case REAL: 
            case STRING: {
                return this.getHook().pop().onSuccess(env);
            }
            case APPL: {
                return this.evalAll(env, true, false, 0, (IStrategoTerm[])t.getAllSubterms().clone());
            }
            case LIST: 
            case TUPLE: {
                IStrategoTerm[] subterms = t.getAllSubterms();
                assert (All.isCopy(t, subterms));
                return this.evalAll(env, false, false, 0, subterms);
            }
            case BLOB: {
                return this.getHook().pop().onSuccess(env);
            }
        }
        throw new InterpreterException("Unknown ATerm type " + (Object)((Object)t.getType()));
    }

    static boolean isCopy(IStrategoTerm parent, IStrategoTerm[] kids) {
        if (kids.length > 0) {
            IStrategoTerm subterm;
            kids[0] = null;
            IStrategoTerm iStrategoTerm = subterm = parent.getSubtermCount() > 0 ? parent.getSubterm(0) : null;
            if (subterm == null) {
                return false;
            }
            kids[0] = subterm;
        }
        return true;
    }

    protected IConstruct evalAll(IContext env, final boolean needsClone, final boolean madeChanges, final int i, final IStrategoTerm[] list2) throws InterpreterException {
        IStrategoTerm old = env.current();
        if (i >= old.getSubtermCount()) {
            if (madeChanges) {
                switch (old.getType()) {
                    case APPL: {
                        env.setCurrent(env.getFactory().replaceAppl(((IStrategoAppl)old).getConstructor(), list2, (IStrategoAppl)old));
                        break;
                    }
                    case LIST: {
                        env.setCurrent(env.getFactory().replaceList(list2, (IStrategoList)old));
                        break;
                    }
                    case TUPLE: {
                        env.setCurrent(env.getFactory().replaceTuple(list2, (IStrategoTuple)old));
                    }
                }
            }
            return this.getHook().pop().onSuccess(env);
        }
        final IStrategoTerm child = list2[i];
        env.setCurrent(child);
        final All th = this;
        this.body.getHook().push(new Hook(old){
            IStrategoTerm oldterm;
            {
                this.oldterm = iStrategoTerm;
            }

            @Override
            public IConstruct onSuccess(IContext env) throws InterpreterException {
                IStrategoTerm newChild = env.current();
                if (newChild != child) {
                    IStrategoTerm[] newList = needsClone ? (IStrategoTerm[])list2.clone() : list2;
                    newList[i] = newChild;
                    env.setCurrent(this.oldterm);
                    return All.this.evalAll(env, false, true, i + 1, newList);
                }
                env.setCurrent(this.oldterm);
                return All.this.evalAll(env, needsClone, madeChanges, i + 1, list2);
            }

            @Override
            public IConstruct onFailure(IContext env) throws InterpreterException {
                return th.getHook().pop().onFailure(env);
            }
        });
        return this.body.eval(env);
    }

    @Override
    public String toString() {
        return "All(" + this.body.toString() + ")";
    }

    @Override
    public void prettyPrint(StupidFormatter sf) {
        sf.append("all(");
        sf.bump(4);
        this.body.prettyPrint(sf);
        sf.append(")");
        sf.unbump(4);
    }
}

