/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.ssl;

import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class SSL_mkterm
extends AbstractPrimitive {
    public SSL_mkterm() {
        super("SSL_mkterm", 0, 2);
    }

    @Override
    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        switch (tvars[0].getType()) {
            case STRING: {
                IStrategoString string = (IStrategoString)tvars[0];
                return this.makeString(env, string) || this.makeAppl(env, string, tvars[1]);
            }
            case INT: 
            case REAL: {
                env.setCurrent(tvars[0]);
                return true;
            }
            case LIST: {
                if (!TermUtils.isList(tvars[1])) {
                    return false;
                }
                env.setCurrent(tvars[1]);
                return true;
            }
        }
        return false;
    }

    private boolean makeString(IContext env, IStrategoString input) {
        String value = input.stringValue();
        if (!value.startsWith("\"")) {
            return false;
        }
        env.setCurrent(env.getFactory().parseFromString(String.valueOf(value) + "\""));
        return true;
    }

    private boolean makeAppl(IContext env, IStrategoString nameTerm, IStrategoTerm argsTerm) {
        if (!TermUtils.isList(argsTerm)) {
            return false;
        }
        String name2 = nameTerm.stringValue();
        int i = 0;
        while (i < name2.length()) {
            char c = name2.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '-' && c != '+' && c != '*' && c != '$') {
                name2 = name2.substring(0, i);
                break;
            }
            ++i;
        }
        IStrategoList args = (IStrategoList)argsTerm;
        if (name2.length() == 0) {
            env.setCurrent(env.getFactory().makeTuple(args.getAllSubterms()));
        } else {
            IStrategoConstructor cons = env.getFactory().makeConstructor(name2, args.size());
            env.setCurrent(env.getFactory().makeAppl(cons, args.getAllSubterms()));
        }
        return true;
    }
}

