/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.treediff;

import java.util.ArrayList;
import org.spoofax.interpreter.library.jsglr.treediff.HelperFunctions;
import org.spoofax.interpreter.library.jsglr.treediff.LCS;
import org.spoofax.interpreter.library.jsglr.treediff.LCSCommand;
import org.spoofax.interpreter.library.jsglr.treediff.TermMatchAttachment;
import org.spoofax.interpreter.terms.IStrategoTerm;

public abstract class AbstractTreeMatcher {
    private LCS<IStrategoTerm> lcs;
    private boolean tryMatchingMovedTerms;

    public AbstractTreeMatcher(LCSCommand<IStrategoTerm> lcsCommand, boolean tryMatchingMovedTerms) {
        this.lcs = new LCS<IStrategoTerm>(lcsCommand);
        this.tryMatchingMovedTerms = tryMatchingMovedTerms;
    }

    public void constructMatching(IStrategoTerm root1, IStrategoTerm root2) {
        HelperFunctions.setParentAttachments(root1);
        HelperFunctions.setParentAttachments(root2);
        this.matchLeafnodesUsingLCS(root1, root2);
        this.matchTerminalsBottomUp(root1, root2);
        this.matchTermsTopdown(root1, root2);
    }

    private void matchLeafnodesUsingLCS(IStrategoTerm trm1, IStrategoTerm trm2) {
        ArrayList<IStrategoTerm> leafNodes1 = HelperFunctions.collectLeafnodes(trm1);
        ArrayList<IStrategoTerm> leafNodes2 = HelperFunctions.collectLeafnodes(trm2);
        this.lcs.createLCSResultsOptimized(leafNodes1, leafNodes2);
        int i = 0;
        while (i < this.lcs.getLCSSize()) {
            TermMatchAttachment.forceMatchTerms(this.lcs.getResultLCS1().get(i), this.lcs.getResultLCS2().get(i));
            ++i;
        }
        if (this.tryMatchingMovedTerms) {
            this.lcs.createLCSResults(this.lcs.getResultUnmatched1(), this.lcs.getResultUnmatched2());
            i = 0;
            while (i < this.lcs.getLCSSize()) {
                TermMatchAttachment.forceMatchTerms(this.lcs.getResultLCS1().get(i), this.lcs.getResultLCS2().get(i));
                ++i;
            }
        }
    }

    abstract ArrayList<IStrategoTerm> getCandidateMatchTerms(IStrategoTerm var1, IStrategoTerm var2);

    abstract double matchingScore(IStrategoTerm var1, IStrategoTerm var2);

    private void matchTerminalsBottomUp(IStrategoTerm root1, IStrategoTerm t2) {
        int i = 0;
        while (i < t2.getSubtermCount()) {
            this.matchTerminalsBottomUp(root1, t2.getSubterm(i));
            ++i;
        }
        this.tryMatchTerminalNode(root1, t2);
    }

    private void tryMatchTerminalNode(IStrategoTerm root1, IStrategoTerm t2) {
        IStrategoTerm t1 = this.findBestMatch(root1, t2);
        if (t1 != null) {
            this.matchTerminalNode(root1, t2, t1);
        }
    }

    private void matchTerminalNode(IStrategoTerm root1, IStrategoTerm t2, IStrategoTerm t1) {
        IStrategoTerm prev_t2 = TermMatchAttachment.getMatchedTerm(t1);
        TermMatchAttachment.forceMatchTerms(t1, t2);
        if (prev_t2 != null) {
            assert (TermMatchAttachment.getMatchedTerm(prev_t2) == null);
            this.tryMatchTerminalNode(root1, prev_t2);
        }
    }

    private IStrategoTerm findBestMatch(IStrategoTerm root1, IStrategoTerm t2) {
        ArrayList<IStrategoTerm> candidates = this.getCandidateMatchTerms(root1, t2);
        candidates = this.removeDuplicates(candidates);
        IStrategoTerm t1 = null;
        int i = 0;
        while (i < candidates.size()) {
            IStrategoTerm t1_candidate = candidates.get(i);
            if (this.isBetterCandidate(t1, t1_candidate, t2)) {
                t1 = t1_candidate;
            }
            ++i;
        }
        return t1;
    }

    private ArrayList<IStrategoTerm> removeDuplicates(ArrayList<IStrategoTerm> candidates) {
        ArrayList<IStrategoTerm> candidateSet = new ArrayList<IStrategoTerm>();
        for (IStrategoTerm c : candidates) {
            if (this.contains(candidateSet, c)) continue;
            candidateSet.add(c);
        }
        return candidateSet;
    }

    boolean contains(ArrayList<IStrategoTerm> terms, IStrategoTerm t) {
        for (IStrategoTerm trm : terms) {
            if (t != trm) continue;
            return true;
        }
        return false;
    }

    private boolean isBetterCandidate(IStrategoTerm prevc1, IStrategoTerm c1, IStrategoTerm t2) {
        double c1_t2;
        if (prevc1 == c1) {
            return false;
        }
        double prevc1_t2 = this.matchingScore(prevc1, t2);
        if (prevc1_t2 > (c1_t2 = this.matchingScore(c1, t2))) {
            return false;
        }
        IStrategoTerm c2 = TermMatchAttachment.getMatchedTerm(c1);
        double c1_c2 = this.matchingScore(c1, c2);
        if (c1_c2 >= c1_t2) {
            return false;
        }
        if (c1_t2 > prevc1_t2) {
            return true;
        }
        IStrategoTerm prevc2 = TermMatchAttachment.getMatchedTerm(prevc1);
        double prevc1_prevc2 = this.matchingScore(prevc1, prevc2);
        assert (prevc1_prevc2 <= prevc1_t2) : "term should not be a candidate for rematching with a term that has lower score";
        return c1_c2 < prevc1_prevc2;
    }

    private void matchTermsTopdown(IStrategoTerm root1, IStrategoTerm trm2) {
        int i;
        IStrategoTerm trm1 = TermMatchAttachment.getMatchedTerm(trm2);
        if (HelperFunctions.haveSameSignature(trm1, trm2) && trm1.getSubtermCount() == trm2.getSubtermCount()) {
            i = 0;
            while (i < trm2.getSubtermCount()) {
                IStrategoTerm trm2ChildPartner;
                IStrategoTerm trm2Child = trm2.getSubterm(i);
                IStrategoTerm trm1Child = trm1.getSubterm(i);
                if (trm1Child != (trm2ChildPartner = TermMatchAttachment.getMatchedTerm(trm2Child)) && this.hasBetterOrEqualMatchingScore(trm2ChildPartner, trm1Child, trm2Child)) {
                    this.matchTerminalNode(root1, trm1Child, trm2Child);
                }
                ++i;
            }
        }
        i = trm2.getSubtermCount() - 1;
        while (i >= 0) {
            this.matchTermsTopdown(root1, trm2.getSubterm(i));
            --i;
        }
    }

    private boolean hasBetterOrEqualMatchingScore(IStrategoTerm oldCandidate, IStrategoTerm newCandidate, IStrategoTerm trm) {
        return !this.isBetterCandidate(newCandidate, oldCandidate, trm) && this.matchingScore(newCandidate, trm) > 0.0;
    }
}

