/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.library.IOperatorRegistry;

public abstract class AbstractStrategoOperatorRegistry
implements IOperatorRegistry {
    private final Map<String, AbstractPrimitive> registry;

    protected AbstractStrategoOperatorRegistry() {
        this(16);
    }

    protected AbstractStrategoOperatorRegistry(int initialCapacity) {
        this.registry = new HashMap<String, AbstractPrimitive>(initialCapacity);
    }

    @Deprecated
    protected Map<String, AbstractPrimitive> getRegistry() {
        return this.registry;
    }

    @Deprecated
    protected void add(String name2, AbstractPrimitive prim) {
        this.registry.put(name2, prim);
    }

    public void add(AbstractPrimitive prim) {
        AbstractPrimitive old = this.registry.put(prim.getName(), prim);
        if (old != null) {
            this.onDuplicatePrimitiveAddition(old, prim);
        }
    }

    protected void onDuplicatePrimitiveAddition(AbstractPrimitive first, AbstractPrimitive second) {
        throw new RuntimeException("Attempted to add a primitive of name " + second.name + ", but one already existed in the OperatorRegistry. ");
    }

    @Override
    public AbstractPrimitive get(String name2) {
        return this.registry.get(name2);
    }

    protected static void attach(Interpreter intp, AbstractStrategoOperatorRegistry op, String ctreeFile) throws IOException, InterpreterException {
        InputStream ins = op.getClass().getClassLoader().getResourceAsStream(ctreeFile);
        if (ins == null) {
            throw new IOException("Failed to load internal library " + ctreeFile);
        }
        intp.load(ins);
        intp.addOperatorRegistry(op);
    }
}

