/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import org.spoofax.interpreter.core.Context;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Pair;
import org.spoofax.interpreter.core.StrategoSignature;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.core.VarScope;
import org.spoofax.interpreter.stratego.All;
import org.spoofax.interpreter.stratego.Build;
import org.spoofax.interpreter.stratego.CallDynamic;
import org.spoofax.interpreter.stratego.CallT;
import org.spoofax.interpreter.stratego.ExtSDef;
import org.spoofax.interpreter.stratego.Fail;
import org.spoofax.interpreter.stratego.GuardedLChoice;
import org.spoofax.interpreter.stratego.Id;
import org.spoofax.interpreter.stratego.ImportTerm;
import org.spoofax.interpreter.stratego.Let;
import org.spoofax.interpreter.stratego.Match;
import org.spoofax.interpreter.stratego.One;
import org.spoofax.interpreter.stratego.OpDecl;
import org.spoofax.interpreter.stratego.PrimT;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.stratego.Scope;
import org.spoofax.interpreter.stratego.Seq;
import org.spoofax.interpreter.stratego.Some;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.util.DebugUtil;
import org.spoofax.terms.io.binary.TermReader;
import org.spoofax.terms.util.TermUtils;

public class StrategoCoreLoader {
    private Context context;

    StrategoCoreLoader(Context context) {
        this.context = context;
    }

    private ExtSDef parseExtSDef(IStrategoAppl t) {
        String name2 = TermUtils.toJavaStringAt(t, 0);
        IStrategoList svars = TermUtils.toListAt(t, 1);
        IStrategoList tvars = TermUtils.toListAt(t, 2);
        DebugUtil.debug((Object)"name  : ", (Object)name2);
        SDefT.SVar[] realsvars = this.makeSVars(svars);
        String[] realtvars = this.makeVars(tvars);
        VarScope oldScope = this.context.getVarScope();
        VarScope newScope = new VarScope(oldScope);
        return new ExtSDef(name2, realsvars, realtvars, newScope);
    }

    private Strategy parseStrategy(IStrategoAppl appl) throws InterpreterException {
        StrategoSignature sign;
        IStrategoConstructor ctor = appl.getConstructor();
        if (ctor.equals((sign = this.context.getStrategoSignature()).getBuild())) {
            return this.parseBuild(appl);
        }
        if (ctor.equals(sign.getScope())) {
            return this.parseScope(appl);
        }
        if (ctor.equals(sign.getSeq())) {
            return this.parseSeq(appl);
        }
        if (ctor.equals(sign.getGuardedLChoice())) {
            return this.parseGuardedLChoice(appl);
        }
        if (ctor.equals(sign.getMatch())) {
            return this.parseMatch(appl);
        }
        if (ctor.equals(sign.getId())) {
            return this.parseId(appl);
        }
        if (ctor.equals(sign.getCallT())) {
            return this.parseCallT(appl);
        }
        if (ctor.equals(sign.getPrimT())) {
            return this.parsePrimT(appl);
        }
        if (ctor.equals(sign.getLet())) {
            return this.parseLet(appl);
        }
        if (ctor.equals(sign.getFail())) {
            return this.makeFail(appl);
        }
        if (ctor.equals(sign.getId())) {
            return this.makeId(appl);
        }
        if (ctor.equals(sign.getAll())) {
            return this.makeAll(appl);
        }
        if (ctor.equals(sign.getOne())) {
            return this.makeOne(appl);
        }
        if (ctor.equals(sign.getSome())) {
            return this.makeSome(appl);
        }
        if (ctor.equals(sign.getImportTerm())) {
            return this.makeImportTerm(appl);
        }
        if (ctor.equals(sign.getCallDynamic())) {
            return this.parseCallDynamic(appl);
        }
        throw new InterpreterException("Unknown op '" + ctor + "'");
    }

    private Strategy makeImportTerm(IStrategoAppl appl) {
        IStrategoString str = TermUtils.toStringAt(appl, 0);
        return new ImportTerm(str.stringValue());
    }

    private Strategy makeId(IStrategoAppl appl) {
        return new Id();
    }

    private Some makeSome(IStrategoAppl t) throws InterpreterException {
        Strategy body = this.parseStrategy(TermUtils.toApplAt(t, 0));
        return new Some(body);
    }

    private One makeOne(IStrategoAppl t) throws InterpreterException {
        Strategy body = this.parseStrategy(TermUtils.toApplAt(t, 0));
        return new One(body);
    }

    private All makeAll(IStrategoAppl t) throws InterpreterException {
        Strategy body = this.parseStrategy(TermUtils.toApplAt(t, 0));
        return new All(body);
    }

    private Strategy makeFail(IStrategoAppl appl) {
        return new Fail();
    }

    private Let parseLet(IStrategoAppl t) throws InterpreterException {
        IStrategoTerm[] l = TermUtils.toListAt(t, 0).getAllSubterms();
        SDefT[] defs = new SDefT[l.length];
        int i = 0;
        while (i < l.length) {
            defs[i] = this.parseSDefT(TermUtils.toAppl(l[i]));
            ++i;
        }
        Strategy body = this.parseStrategy(TermUtils.toApplAt(t, 1));
        return new Let(defs, body);
    }

    public SDefT parseSDefT(IStrategoAppl t) throws InterpreterException {
        DebugUtil.debug((Object)"parseSDefT()");
        String name2 = TermUtils.toJavaStringAt(t, 0);
        IStrategoList svars = TermUtils.toListAt(t, 1);
        IStrategoList tvars = TermUtils.toListAt(t, 2);
        DebugUtil.debug((Object)" name  : ", (Object)name2);
        DebugUtil.debug((Object)" svars : ", (Object)svars);
        SDefT.SVar[] realsvars = this.makeSVars(svars);
        DebugUtil.debug((Object)" svars : ", (Object)realsvars);
        DebugUtil.debug((Object)" tvars : ", (Object)tvars);
        String[] realtvars = this.makeVars(tvars);
        DebugUtil.debug((Object)" tvars : ", (Object)realtvars);
        VarScope newScope = new VarScope(this.context.getVarScope());
        this.context.setVarScope(newScope);
        Strategy body = this.parseStrategy(TermUtils.toApplAt(t, 3));
        this.context.popVarScope();
        DebugUtil.debug((Object)" +name: ", (Object)name2);
        return new SDefT(name2, realsvars, realtvars, body, newScope);
    }

    private String[] makeVars(IStrategoList svars) {
        IStrategoTerm[] sv = svars.getAllSubterms();
        String[] realsvars = new String[sv.length];
        DebugUtil.debug((Object)" vars  : ", (Object)svars);
        int j = 0;
        while (j < svars.size()) {
            realsvars[j] = TermUtils.toJavaStringAt(sv[j], 0);
            ++j;
        }
        return realsvars;
    }

    private SDefT.SVar[] makeSVars(IStrategoList svars) {
        DebugUtil.debug((Object)"makeSVars()");
        IStrategoTerm[] sv = svars.getAllSubterms();
        SDefT.SVar[] realsvars = new SDefT.SVar[sv.length];
        DebugUtil.debug((Object)" vars  : ", (Object)svars);
        int j = 0;
        while (j < sv.length) {
            IStrategoAppl t = (IStrategoAppl)sv[j];
            SDefT.ArgType type = this.parseArgType(TermUtils.toApplAt(t, 1));
            String name2 = TermUtils.toJavaStringAt(t, 0);
            realsvars[j] = new SDefT.SVar(name2, type);
            ++j;
        }
        DebugUtil.debug((Object)"       : ", (Object)realsvars);
        return realsvars;
    }

    private SDefT.ArgType parseArgType(IStrategoAppl t) {
        if (Tools.isFunType(t, this.context)) {
            IStrategoList l = TermUtils.toListAt(t, 0);
            ArrayList<SDefT.ArgType> ch = new ArrayList<SDefT.ArgType>();
            int i = 0;
            while (i < l.size()) {
                ch.add(this.parseArgType(TermUtils.toApplAt(l, i)));
                ++i;
            }
            return new SDefT.FunType(ch);
        }
        if (Tools.isConstType(t, this.context)) {
            return SDefT.ConstType.INSTANCE;
        }
        return null;
    }

    private PrimT parsePrimT(IStrategoAppl t) throws InterpreterException {
        String name2 = TermUtils.toJavaStringAt(t, 0);
        Strategy[] svars = this.parseStrategyList(TermUtils.toListAt(t, 1));
        IStrategoTerm[] tvars = this.parseTermList(TermUtils.toListAt(t, 2));
        return new PrimT(name2, svars, tvars);
    }

    private Strategy parseCallT(IStrategoAppl t) throws InterpreterException {
        DebugUtil.debug((Object)"parseCallT()");
        String name2 = TermUtils.toJavaStringAt(TermUtils.toApplAt(t, 0), 0);
        DebugUtil.debug((Object)" name  : ", (Object)name2);
        IStrategoList svars = TermUtils.toListAt(t, 1);
        Strategy[] realsvars = this.parseStrategyList(svars);
        IStrategoTerm[] realtvars = this.parseTermList(TermUtils.toListAt(t, 2));
        DebugUtil.debug((Object)" -svars : ", (Object)realsvars);
        DebugUtil.debug((Object)" -tvars : ", (Object)realtvars);
        return new CallT(name2, realsvars, realtvars);
    }

    private Strategy parseCallDynamic(IStrategoAppl t) throws InterpreterException {
        DebugUtil.debug((Object)"parseDynamicCall()");
        IStrategoTerm sref = t.getSubterm(0);
        DebugUtil.debug((Object)" name  : ", (Object)sref);
        IStrategoList svars = TermUtils.toListAt(t, 1);
        Strategy[] realsvars = this.parseStrategyList(svars);
        IStrategoTerm[] realtvars = this.parseTermList(TermUtils.toListAt(t, 2));
        DebugUtil.debug((Object)" -svars : ", (Object)realsvars);
        DebugUtil.debug((Object)" -tvars : ", (Object)realtvars);
        return new CallDynamic(sref, realsvars, realtvars);
    }

    private IStrategoTerm[] parseTermList(IStrategoList tvars) {
        return tvars.getAllSubterms();
    }

    private Strategy[] parseStrategyList(IStrategoList svars) throws InterpreterException {
        IStrategoTerm[] sv = svars.getAllSubterms();
        Strategy[] v = new Strategy[sv.length];
        int i = 0;
        while (i < sv.length) {
            v[i] = this.parseStrategy((IStrategoAppl)sv[i]);
            ++i;
        }
        return v;
    }

    private Id parseId(IStrategoAppl t) {
        return new Id();
    }

    private Match parseMatch(IStrategoAppl t) {
        IStrategoAppl u = TermUtils.toApplAt(t, 0);
        return new Match(u);
    }

    private GuardedLChoice parseGuardedLChoice(IStrategoAppl t) throws InterpreterException {
        LinkedList<Pair<Strategy, Strategy>> s = new LinkedList<Pair<Strategy, Strategy>>();
        IStrategoConstructor ctor = this.context.getStrategoSignature().getGuardedLChoice();
        while (t.getConstructor().equals(ctor)) {
            s.add(new Pair<Strategy, Strategy>(this.parseStrategy(TermUtils.toApplAt(t, 0)), this.parseStrategy(TermUtils.toApplAt(t, 1))));
            t = TermUtils.toApplAt(t, 2);
        }
        s.add(new Pair<Strategy, Object>(this.parseStrategy(t), null));
        return new GuardedLChoice(s.toArray(new Pair[0]));
    }

    private Seq parseSeq(IStrategoAppl t) throws InterpreterException {
        LinkedList<Strategy> s = new LinkedList<Strategy>();
        StrategoSignature sign = this.context.getStrategoSignature();
        while (t.getConstructor().equals(sign.getSeq())) {
            s.add(this.parseStrategy(TermUtils.toApplAt(t, 0)));
            t = TermUtils.toApplAt(t, 1);
        }
        s.add(this.parseStrategy(t));
        return new Seq(s.toArray(new Strategy[0]));
    }

    private Scope parseScope(IStrategoAppl t) throws InterpreterException {
        IStrategoList vars = TermUtils.toListAt(t, 0);
        ArrayList<String> realvars = new ArrayList<String>(vars.size());
        int i = 0;
        while (i < vars.size()) {
            realvars.add(TermUtils.toJavaStringAt(vars, i));
            ++i;
        }
        Strategy body = this.parseStrategy(TermUtils.toApplAt(t, 1));
        return new Scope(realvars, body);
    }

    private Build parseBuild(IStrategoAppl t) {
        IStrategoAppl u = TermUtils.toApplAt(t, 0);
        return new Build(u);
    }

    @Deprecated
    public void load(String path) throws IOException, InterpreterException {
        this.doLoad(new TermReader(this.context.getProgramFactory()).parseFromFile(path));
    }

    public void load(IStrategoTerm prg) throws InterpreterException {
        this.doLoad(prg);
    }

    private void doLoad(IStrategoTerm prg) throws InterpreterException {
        DebugUtil.debug((Object)prg);
        IStrategoList list2 = TermUtils.toListAt(prg, 0);
        if (!list2.isEmpty()) {
            IStrategoAppl sign = TermUtils.toApplAt(list2, 0);
            IStrategoAppl strats = TermUtils.toApplAt(list2, 1);
            this.loadConstructors(TermUtils.toListAt(TermUtils.toApplAt(TermUtils.toListAt(sign, 0), 0), 0));
            this.loadStrategies(TermUtils.toListAt(strats, 0));
        }
    }

    private void loadConstructors(IStrategoList list2) {
        while (!list2.isEmpty()) {
            IStrategoAppl opDecl = (IStrategoAppl)list2.head();
            if (!opDecl.getConstructor().getName().equals("OpDeclInj") && !opDecl.getConstructor().getName().equals("ExtOpDeclInj")) {
                String name2 = TermUtils.toJavaStringAt(opDecl, 0);
                SDefT.ArgType argType = this.parseArgType(TermUtils.toApplAt(opDecl, 1));
                this.context.addOpDecl(name2, new OpDecl(name2, argType));
            }
            list2 = list2.tail();
        }
    }

    private void loadStrategies(IStrategoList list2) throws InterpreterException {
        while (!list2.isEmpty()) {
            IStrategoAppl t = (IStrategoAppl)list2.head();
            if (Tools.isSDefT(t, this.context)) {
                SDefT def = this.parseSDefT(t);
                this.context.addSVar(def.getName(), def);
            }
            list2 = list2.tail();
        }
    }

    @Deprecated
    public void load(InputStream stream) throws InterpreterException, IOException {
        if (stream == null) {
            throw new IOException("Could not load Stratego core input from null stream");
        }
        this.doLoad(new TermReader(this.context.getProgramFactory()).parseFromStream(stream));
    }
}

