/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.log;

import java.io.OutputStream;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.ILoggerProvider;
import org.metaborg.util.log.Level;
import org.metaborg.util.log.LoggingOutputStream;
import org.metaborg.util.log.Slf4jLoggerProvider;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class LoggerUtils {
    private static final String CONTEXT_ID = "contextid";
    private static final Slf4jLoggerProvider loggerProvider = new Slf4jLoggerProvider();

    public static ILoggerProvider getDefaultLoggerProvider() {
        return loggerProvider;
    }

    private static ILogger logger(Logger slf4jlogger) {
        return loggerProvider.getLogger(slf4jlogger);
    }

    public static ILogger logger(Class<?> clazz) {
        return loggerProvider.getLogger(clazz);
    }

    public static ILogger logger(String name2) {
        return loggerProvider.getLogger(name2);
    }

    public static void setContextId(String contextId) {
        MDC.put((String)CONTEXT_ID, (String)contextId);
    }

    public static void clearContextId() {
        MDC.remove((String)CONTEXT_ID);
    }

    public static OutputStream stream(ILogger logger, Level level, String ... excludePatterns) {
        return new LoggingOutputStream(logger, level, excludePatterns);
    }

    public static OutputStream stream(ILogger logger, String ... excludePatterns) {
        return new LoggingOutputStream(logger, Level.Info, excludePatterns);
    }

    public static OutputStream stream(Logger slf4jlogger, Level level, String ... excludePatterns) {
        return new LoggingOutputStream(LoggerUtils.logger(slf4jlogger), level, excludePatterns);
    }

    public static OutputStream stream(Logger slf4jlogger, String ... excludePatterns) {
        return new LoggingOutputStream(LoggerUtils.logger(slf4jlogger), Level.Info, excludePatterns);
    }

    public static OutputStream stream(Class<?> clazz, Level level, String ... excludePatterns) {
        return new LoggingOutputStream(LoggerUtils.logger(clazz), level, excludePatterns);
    }

    public static OutputStream stream(Class<?> clazz, String ... excludePatterns) {
        return new LoggingOutputStream(LoggerUtils.logger(clazz), Level.Info, excludePatterns);
    }

    public static OutputStream stream(String name2, Level level, String ... excludePatterns) {
        return new LoggingOutputStream(LoggerUtils.logger(name2), level, excludePatterns);
    }

    public static OutputStream stream(String name2, String ... excludePatterns) {
        return new LoggingOutputStream(LoggerUtils.logger(name2), Level.Info, excludePatterns);
    }
}

