/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.future;

import java.util.Iterator;
import org.metaborg.util.functions.CheckedFunction1;
import org.metaborg.util.functions.CheckedFunction2;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.IFuture;

public final class Futures {
    private Futures() {
    }

    public static <T, U> IFuture<U> reduce(U initial, Iterable<T> items, CheckedFunction2<U, T, IFuture<U>, ? extends Throwable> f) {
        return Futures.reduce(initial, items.iterator(), f);
    }

    private static <T, U> IFuture<U> reduce(U initial, Iterator<T> items, CheckedFunction2<U, T, IFuture<U>, ? extends Throwable> f) {
        if (items.hasNext()) {
            try {
                return f.apply(initial, items.next()).thenCompose(next -> Futures.reduce(next, items, f));
            }
            catch (Throwable ex) {
                return CompletableFuture.completedExceptionally(ex);
            }
        }
        return CompletableFuture.completedFuture(initial);
    }

    public static <T> IFuture<Boolean> noneMatch(Iterable<T> items, CheckedFunction1<T, IFuture<Boolean>, InterruptedException> p) {
        return Futures.noneMatch(items.iterator(), p);
    }

    private static <T> IFuture<Boolean> noneMatch(Iterator<T> items, CheckedFunction1<T, IFuture<Boolean>, ? extends Throwable> p) {
        if (items.hasNext()) {
            try {
                return p.apply(items.next()).thenCompose(match -> match != false ? CompletableFuture.completedFuture(false) : Futures.noneMatch(items, p));
            }
            catch (Throwable ex) {
                return CompletableFuture.completedExceptionally(ex);
            }
        }
        return CompletableFuture.completedFuture(true);
    }
}

