/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.future;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.metaborg.util.functions.CheckedAction1;
import org.metaborg.util.functions.CheckedAction2;
import org.metaborg.util.functions.CheckedFunction1;
import org.metaborg.util.functions.CheckedFunction2;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.tuple.Tuple3;
import org.metaborg.util.tuple.Tuple4;

public class AggregateFuture<T>
implements IFuture<List<T>> {
    private static final ILogger logger = LoggerUtils.logger(AggregateFuture.class);
    private Object lock = new Object();
    private volatile int remaining;
    private final T[] results;
    private final CompletableFuture<List<T>> result;

    @SafeVarargs
    public AggregateFuture(IFuture<? extends T> ... futures) {
        this(Arrays.asList(futures));
    }

    public AggregateFuture(Iterable<? extends IFuture<? extends T>> futures) {
        ArrayList futureList = Lists.newArrayList(futures);
        int count = futureList.size();
        this.results = new Object[count];
        this.result = new CompletableFuture();
        logger.trace("{} initialized with {}: {}", this, count, futureList);
        this.remaining = count;
        int i = 0;
        while (i < count) {
            int j = i;
            ((IFuture)futureList.get(i)).whenComplete((? super T r, Throwable ex) -> this.whenComplete(j, (T)r, (Throwable)ex));
            ++i;
        }
        this.fireIfComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void whenComplete(int i, T r, Throwable ex) {
        Object object = this.lock;
        synchronized (object) {
            if (this.remaining > 0) {
                if (ex != null) {
                    logger.trace("{} completed {}: exception", this, i);
                    this.remaining = -1;
                } else if (this.remaining > 0) {
                    logger.trace("{} completed {}: value", this, i);
                    --this.remaining;
                    this.results[i] = r;
                }
            }
        }
        if (ex != null) {
            this.result.completeExceptionally(ex);
        } else {
            this.fireIfComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireIfComplete() {
        List<T> results;
        Object object = this.lock;
        synchronized (object) {
            if (this.remaining == 0) {
                logger.trace("{} done: completed all", this);
                results = Arrays.asList(this.results);
            } else {
                logger.trace("{} open: {} remaining", this, this.remaining);
                results = null;
            }
        }
        if (results != null) {
            this.result.complete(results);
        }
    }

    @Override
    public <U> IFuture<U> handle(CheckedFunction2<? super List<T>, Throwable, ? extends U, ? extends Throwable> handler) {
        return this.result.handle(handler);
    }

    @Override
    public IFuture<List<T>> whenComplete(CheckedAction2<? super List<T>, Throwable, ? extends Throwable> handler) {
        return this.result.whenComplete(handler);
    }

    @Override
    public <U> IFuture<U> thenApply(CheckedFunction1<? super List<T>, ? extends U, ? extends Throwable> handler) {
        return this.result.thenApply(handler);
    }

    @Override
    public IFuture<Void> thenAccept(CheckedAction1<? super List<T>, ? extends Throwable> handler) {
        return this.result.thenAccept(handler);
    }

    @Override
    public <U> IFuture<U> thenCompose(CheckedFunction1<? super List<T>, ? extends IFuture<? extends U>, ? extends Throwable> handler) {
        return this.result.thenCompose(handler);
    }

    @Override
    public <U> IFuture<U> compose(CheckedFunction2<? super List<T>, Throwable, ? extends IFuture<? extends U>, ? extends Throwable> handler) {
        return this.result.compose(handler);
    }

    @Override
    public boolean isDone() {
        return this.result.isDone();
    }

    @Override
    public java.util.concurrent.CompletableFuture<List<T>> asJavaCompletion() {
        return this.result.asJavaCompletion();
    }

    public static <T1, T2> IFuture<Tuple2<T1, T2>> apply(IFuture<T1> f1, IFuture<T2> f2) {
        return new AggregateFuture(f1, f2).thenApply(rs -> Tuple2.of(rs.get(0), rs.get(1)));
    }

    public static <T1, T2, T3> IFuture<Tuple3<T1, T2, T3>> apply(IFuture<T1> f1, IFuture<T2> f2, IFuture<T3> f3) {
        return new AggregateFuture(f1, f2, f3).thenApply(rs -> Tuple3.of(rs.get(0), rs.get(1), rs.get(2)));
    }

    public static <T1, T2, T3, T4> IFuture<Tuple4<T1, T2, T3, T4>> apply(IFuture<T1> f1, IFuture<T2> f2, IFuture<T3> f3, IFuture<T4> f4) {
        return new AggregateFuture(f1, f2, f3, f4).thenApply(rs -> Tuple4.of(rs.get(0), rs.get(1), rs.get(2), rs.get(3)));
    }

    public static <T, U> IFuture<List<U>> forAll(Iterable<T> items, Function1<T, IFuture<U>> toFuture) {
        ArrayList futures = new ArrayList();
        items.forEach(item -> {
            boolean bl = futures.add((IFuture)toFuture.apply(item));
        });
        return new AggregateFuture<T>(futures);
    }
}

