/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.tracing;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.context.ContextException;
import org.metaborg.core.context.IContext;
import org.metaborg.core.context.IContextService;
import org.metaborg.core.language.FacetContribution;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.project.IProject;
import org.metaborg.core.project.IProjectService;
import org.metaborg.core.source.ISourceLocation;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.core.source.SourceRegion;
import org.metaborg.core.tracing.Resolution;
import org.metaborg.core.tracing.ResolutionTarget;
import org.metaborg.spoofax.core.stratego.IStrategoRuntimeService;
import org.metaborg.spoofax.core.tracing.ISpoofaxResolverService;
import org.metaborg.spoofax.core.tracing.ISpoofaxTracingService;
import org.metaborg.spoofax.core.tracing.ResolverFacet;
import org.metaborg.spoofax.core.tracing.TracingCommon;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.util.concurrent.IClosableLock;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.HybridInterpreter;

public class ResolverService
implements ISpoofaxResolverService {
    private static final ILogger logger = LoggerUtils.logger(ResolverService.class);
    private final IProjectService projectService;
    private final IContextService contextService;
    private final ITermFactory termFactory;
    private final IStrategoRuntimeService strategoRuntimeService;
    private final ISpoofaxTracingService tracingService;
    private final TracingCommon common;

    @Inject
    public ResolverService(IProjectService projectService, IContextService contextService, ITermFactory termFactory, IStrategoRuntimeService strategoRuntimeService, ISpoofaxTracingService tracingService, TracingCommon common) {
        this.projectService = projectService;
        this.contextService = contextService;
        this.termFactory = termFactory;
        this.strategoRuntimeService = strategoRuntimeService;
        this.tracingService = tracingService;
        this.common = common;
    }

    @Override
    public boolean available(ILanguageImpl language) {
        return language.facet(ResolverFacet.class) != null;
    }

    @Override
    public Resolution resolve(int offset, ISpoofaxParseUnit result) throws MetaborgException {
        IContext context;
        if (!result.valid()) {
            return null;
        }
        FileObject source = result.source();
        IProject project = this.projectService.get(source);
        ILanguageImpl langImpl = result.input().langImpl();
        if (project == null) {
            context = null;
        } else {
            try {
                context = this.contextService.get(source, project, langImpl);
            }
            catch (MetaborgRuntimeException | ContextException e) {
                context = null;
            }
        }
        FacetContribution<ResolverFacet> facetContrib = this.facet(langImpl);
        ResolverFacet facet = (ResolverFacet)facetContrib.facet;
        ILanguageComponent contributor = facetContrib.contributor;
        String strategy = facet.strategyName;
        try {
            HybridInterpreter interpreter = context == null ? this.strategoRuntimeService.runtime(contributor, source) : this.strategoRuntimeService.runtime(contributor, context);
            Iterable<IStrategoTerm> inRegion = this.tracingService.fragments(result, (ISourceRegion)new SourceRegion(offset));
            TracingCommon.TermWithRegion tuple2 = this.common.outputs(this.termFactory, interpreter, source, source, result.ast(), inRegion, strategy);
            return this.resolve(tuple2);
        }
        catch (MetaborgException e) {
            throw new MetaborgException("Reference resolution failed", e);
        }
    }

    @Override
    public Resolution resolve(int offset, ISpoofaxAnalyzeUnit result) throws MetaborgException {
        if (!result.valid() || !result.hasAst()) {
            return null;
        }
        FileObject source = result.source();
        IContext context = result.context();
        ILanguageImpl language = context.language();
        FacetContribution<ResolverFacet> facetContrib = this.facet(language);
        ResolverFacet facet = (ResolverFacet)facetContrib.facet;
        String strategy = facet.strategyName;
        try {
            TracingCommon.TermWithRegion tuple2;
            HybridInterpreter interpreter = this.strategoRuntimeService.runtime(facetContrib.contributor, context);
            Iterable<IStrategoTerm> inRegion = this.tracingService.fragments(result, (ISourceRegion)new SourceRegion(offset));
            Throwable throwable = null;
            Object var13_14 = null;
            try (IClosableLock _lock = context.read();){
                tuple2 = this.common.outputs(this.termFactory, interpreter, source, source, result.ast(), inRegion, strategy);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return this.resolve(tuple2);
        }
        catch (MetaborgException e) {
            throw new MetaborgException("Reference resolution failed", e);
        }
    }

    private FacetContribution<ResolverFacet> facet(ILanguageImpl language) throws MetaborgException {
        FacetContribution<ResolverFacet> facet = language.facetContribution(ResolverFacet.class);
        if (facet == null) {
            String message = logger.format("Cannot resolve reference of {}, it does not have a resolver facet", language);
            throw new MetaborgException(message);
        }
        return facet;
    }

    private Resolution resolve(@Nullable TracingCommon.TermWithRegion tuple2) {
        if (tuple2 == null) {
            return null;
        }
        IStrategoTerm output = tuple2.term;
        ISourceRegion offsetRegion = tuple2.region;
        LinkedList targets = Lists.newLinkedList();
        if (TermUtils.isList(output)) {
            for (IStrategoTerm subterm : output) {
                String hyperlinkText = this.getHyperlinkText(subterm);
                ISourceLocation targetLocation = this.common.getTargetLocation(subterm);
                if (targetLocation == null) {
                    logger.debug("Cannot get target location for {}", subterm);
                    continue;
                }
                targets.add(new ResolutionTarget(hyperlinkText, targetLocation));
            }
        } else {
            String hyperlinkText = this.getHyperlinkText(output);
            ISourceLocation targetLocation = this.common.getTargetLocation(output);
            if (targetLocation == null) {
                logger.debug("Reference resolution failed, cannot get target location for {}", output);
                return null;
            }
            targets.add(new ResolutionTarget(hyperlinkText, targetLocation));
        }
        if (targets.isEmpty()) {
            logger.debug("Reference resolution failed, cannot get target locations for {}", output);
            return null;
        }
        return new Resolution(offsetRegion, targets);
    }

    @Nullable
    private String getHyperlinkText(IStrategoTerm subterm) {
        for (IStrategoTerm annoterm : subterm.getAnnotations()) {
            if (!TermUtils.isAppl(annoterm, "HyperlinkText", 1)) continue;
            IStrategoTerm hyperlinkTextTerm = annoterm.getSubterm(0);
            if (TermUtils.isString(hyperlinkTextTerm)) {
                return TermUtils.toJavaString(hyperlinkTextTerm);
            }
            return hyperlinkTextTerm.toString();
        }
        return null;
    }
}

