/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.style;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.metaborg.core.style.IStyle;
import org.metaborg.core.style.Style;
import org.metaborg.spoofax.core.esv.ESVReader;
import org.metaborg.spoofax.core.style.StylerFacet;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.terms.util.TermUtils;

public class StylerFacetFromESV {
    private static final ILogger logger = LoggerUtils.logger(StylerFacetFromESV.class);

    @Nullable
    public static StylerFacet create(IStrategoAppl esv) {
        StylerFacet facet = new StylerFacet();
        ArrayList<IStrategoAppl> styleDefs = ESVReader.collectTerms(esv, "ColorDef");
        HashMap namedStyles = Maps.newHashMap();
        for (IStrategoAppl styleDef : styleDefs) {
            IStyle style;
            IStrategoAppl styleTerm = TermUtils.toApplAt(styleDef, 1);
            IStrategoConstructor styleCons = styleTerm.getConstructor();
            if (styleCons.getName().equals("Attribute")) {
                style = StylerFacetFromESV.style(styleTerm);
            } else if (styleCons.getName().equals("AttributeRef")) {
                String name2 = TermUtils.toJavaStringAt(styleTerm, 0);
                style = (IStyle)namedStyles.get(name2);
                if (style == null) {
                    logger.error("Cannot resolve style definition " + name2 + " in style definition " + styleDef);
                    continue;
                }
            } else {
                logger.error("Unhandled style " + styleCons + " in style definition " + styleDef);
                continue;
            }
            namedStyles.put(TermUtils.toJavaStringAt(styleDef, 0), style);
        }
        ArrayList<IStrategoAppl> styleRules = ESVReader.collectTerms(esv, "ColorRule");
        if (Iterables.isEmpty(styleRules)) {
            return null;
        }
        for (IStrategoAppl styleRule : styleRules) {
            String sort;
            IStyle style;
            IStrategoAppl styleTerm = TermUtils.toApplAt(styleRule, 1);
            IStrategoConstructor styleCons = styleTerm.getConstructor();
            if (styleCons.getName().equals("Attribute")) {
                style = StylerFacetFromESV.style(styleTerm);
            } else if (styleCons.getName().equals("AttributeRef")) {
                String name3 = TermUtils.toJavaStringAt(styleTerm, 0);
                style = (IStyle)namedStyles.get(name3);
                if (style == null) {
                    logger.error("Cannot resolve style definition " + name3 + " in style rule " + styleRule);
                    continue;
                }
            } else {
                logger.error("Unhandled style " + styleCons + " in style rule " + styleRule);
                continue;
            }
            IStrategoAppl node = TermUtils.toApplAt(styleRule, 0);
            IStrategoConstructor nodeCons = node.getConstructor();
            if (nodeCons.getName().equals("SortAndConstructor")) {
                sort = TermUtils.toJavaStringAt(node.getSubterm(0), 0);
                String cons = TermUtils.toJavaStringAt(node.getSubterm(1), 0);
                facet.mapSortConsToStyle(sort, cons, style);
                continue;
            }
            if (nodeCons.getName().equals("ConstructorOnly")) {
                String cons = TermUtils.toJavaStringAt(node.getSubterm(0), 0);
                facet.mapConsToStyle(cons, style);
                continue;
            }
            if (nodeCons.getName().equals("Sort")) {
                sort = TermUtils.toJavaStringAt(node, 0);
                facet.mapSortToStyle(sort, style);
                continue;
            }
            if (nodeCons.getName().equals("Token")) {
                IStrategoAppl tokenAppl = TermUtils.toApplAt(node, 0);
                String token = tokenAppl.getConstructor().getName();
                facet.mapTokenToStyle(token, style);
                continue;
            }
            logger.error("Unhandled node " + nodeCons + " in style rule " + styleRule);
        }
        return facet;
    }

    private static IStyle style(IStrategoAppl attribute) {
        boolean italic;
        boolean bold;
        String fontSettingCons;
        Color color = StylerFacetFromESV.color(TermUtils.toApplAt(attribute, 0));
        Color backgroundColor = StylerFacetFromESV.color(TermUtils.toApplAt(attribute, 1));
        boolean underline = false;
        boolean strikeout = false;
        IStrategoAppl fontSetting = TermUtils.toApplAt(attribute, 2);
        switch (fontSettingCons = fontSetting.getConstructor().getName()) {
            case "BOLD": {
                bold = true;
                italic = false;
                break;
            }
            case "ITALIC": {
                bold = false;
                italic = true;
                break;
            }
            case "BOLD_ITALIC": {
                bold = true;
                italic = true;
                break;
            }
            default: {
                bold = false;
                italic = false;
            }
        }
        return new Style(color, backgroundColor, bold, italic, false, false);
    }

    private static Color color(IStrategoAppl color) {
        String colorCons;
        switch (colorCons = color.getConstructor().getName()) {
            case "ColorRGB": {
                int r = Integer.parseInt(TermUtils.toJavaStringAt(color, 0));
                int g = Integer.parseInt(TermUtils.toJavaStringAt(color, 1));
                int b = Integer.parseInt(TermUtils.toJavaStringAt(color, 2));
                return new Color(r, g, b);
            }
            case "ColorDefault": {
                return new Color(0, 0, 0);
            }
        }
        return null;
    }
}

