/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego.primitive.flowspec;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import mb.flowspec.controlflow.IFlowSpecSolution;
import mb.flowspec.primitives.AnalysisPrimitive;
import mb.flowspec.runtime.interpreter.InterpreterBuilder;
import mb.flowspec.runtime.solver.FixedPoint;
import mb.flowspec.runtime.solver.ParseException;
import mb.flowspec.terms.B;
import mb.nabl2.spoofax.analysis.IResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.language.ILanguageCache;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.io.binary.TermReader;
import org.spoofax.terms.util.M;

public class FS_solve
extends AbstractPrimitive
implements ILanguageCache {
    private static final ILogger logger = LoggerUtils.logger(FS_solve.class);
    protected final IResourceService resourceService;
    protected final ITermFactory termFactory;
    private final AnalysisPrimitive prim;
    private ILanguageImpl currentLanguage;
    private static final String FLOWSPEC_STATIC_INFO_DIR = "target/metaborg/flowspec-static-info";
    private final Map<ILanguageComponent, InterpreterBuilder> flowSpecTransferFunctionCache = new HashMap<ILanguageComponent, InterpreterBuilder>();

    @Inject
    public FS_solve(IResourceService resourceService, ITermFactory termFactory) {
        super(FS_solve.class.getSimpleName(), 0, 2);
        this.resourceService = resourceService;
        this.termFactory = termFactory;
        this.prim = new AnalysisPrimitive(FS_solve.class.getSimpleName(), 1){

            @Override
            protected Optional<? extends IStrategoTerm> call(IResult result, IStrategoTerm term, List<IStrategoTerm> terms) throws InterpreterException {
                Optional<List> propertyNames = M.maybe(() -> {
                    IStrategoList list3 = M.list((IStrategoTerm)terms.get(0));
                    ArrayList<String> propNames = new ArrayList<String>(list3.getSubtermCount());
                    for (IStrategoTerm stringTerm : list3) {
                        propNames.add(M.string(stringTerm));
                    }
                    return propNames;
                });
                Optional<IFlowSpecSolution> sol = AnalysisPrimitive.getFSSolution(result);
                FixedPoint solver = new FixedPoint();
                InterpreterBuilder interpBuilder = FS_solve.this.getFlowSpecInterpreterBuilder(FS_solve.this.currentLanguage);
                if (propertyNames.isPresent() && sol.isPresent()) {
                    IFlowSpecSolution solution = solver.entryPoint(this.getFactory(), sol.get(), interpBuilder, propertyNames.get());
                    return Optional.of(B.blob(result.withCustomAnalysis(solution)));
                }
                return Optional.empty();
            }
        };
    }

    @Override
    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        this.currentLanguage = ((org.metaborg.core.context.IContext)env.contextObject()).language();
        return this.prim.call(env, svars, tvars);
    }

    protected Optional<InterpreterBuilder> getFlowSpecInterpreterBuilder(ILanguageComponent component) {
        Optional<InterpreterBuilder> optInterpB = Optional.ofNullable(this.flowSpecTransferFunctionCache.get(component));
        if (optInterpB.isPresent()) {
            return optInterpB;
        }
        optInterpB = FS_solve.getFlowSpecInterpreterBuilder(component, this.resourceService, this.termFactory);
        if (!optInterpB.isPresent()) {
            return optInterpB;
        }
        logger.debug("Caching FlowSpec static info for language {}", component);
        this.flowSpecTransferFunctionCache.put(component, optInterpB.get());
        return optInterpB;
    }

    public InterpreterBuilder getFlowSpecInterpreterBuilder(ILanguageImpl impl) {
        return FS_solve.getFlowSpecInterpreterBuilder(impl, this::getFlowSpecInterpreterBuilder);
    }

    public static InterpreterBuilder getFlowSpecInterpreterBuilder(ILanguageImpl impl, Function<ILanguageComponent, Optional<InterpreterBuilder>> getStaticInfo) {
        Optional<Object> result = Optional.empty();
        for (ILanguageComponent comp : impl.components()) {
            Optional<InterpreterBuilder> optInterpB = getStaticInfo.apply(comp);
            if (!optInterpB.isPresent()) continue;
            logger.debug("Found FlowSpec static info directory for {}.", comp);
            result = !result.isPresent() ? optInterpB : Optional.of(((InterpreterBuilder)result.get()).add(optInterpB.get()));
        }
        if (!result.isPresent()) {
            logger.error("No FlowSpec static info found for {}", impl);
            return new InterpreterBuilder();
        }
        return (InterpreterBuilder)result.get();
    }

    public static Optional<InterpreterBuilder> getFlowSpecInterpreterBuilder(ILanguageComponent component, IResourceService resourceService, ITermFactory termFactory) {
        FileObject staticInfoDir = resourceService.resolve(component.location(), FLOWSPEC_STATIC_INFO_DIR);
        try {
            InterpreterBuilder result = new InterpreterBuilder();
            FileObject[] fileObjectArray = staticInfoDir.getChildren();
            int n = fileObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileObject staticInfoFile = fileObjectArray[n2];
                try {
                    String moduleName = FilenameUtils.removeExtension((String)staticInfoFile.getName().getBaseName().replace('+', '/'));
                    IStrategoTerm term = new TermReader(termFactory).parseFromStream(staticInfoFile.getContent().getInputStream());
                    result.add(term, moduleName);
                }
                catch (IOException e) {
                    logger.info("Could not read FlowSpec static info file for {}. \n{}", component, e.getMessage());
                }
                catch (ParseException | ParseError e) {
                    logger.warn("Could not parse FlowSpec static info file for {}. \nError: {}", component, e.getMessage());
                }
                ++n2;
            }
            return Optional.of(result);
        }
        catch (FileSystemException e) {
            logger.info("Could not find FlowSpec static info directory for {}.", component);
            return Optional.empty();
        }
    }

    @Override
    public void invalidateCache(ILanguageComponent component) {
        logger.debug("Removing cached flowspec transfer functions for {}", component);
        this.flowSpecTransferFunctionCache.remove(component);
    }

    @Override
    public void invalidateCache(ILanguageImpl impl) {
        logger.debug("Removing cached flowspec transfer functions for {}", impl);
        for (ILanguageComponent component : impl.components()) {
            this.flowSpecTransferFunctionCache.remove(component);
        }
    }
}

