/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego.primitive.constraint;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.metaborg.spoofax.core.context.constraint.IConstraintContext;
import org.metaborg.util.concurrent.IClosableLock;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public abstract class ConstraintContextPrimitive
extends AbstractPrimitive {
    protected final int tvars;

    public ConstraintContextPrimitive(String name2) {
        this(name2, 0);
    }

    public ConstraintContextPrimitive(String name2, int tvars) {
        super(name2, 0, tvars);
        this.tvars = tvars;
    }

    @Override
    public final boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        Optional<? extends IStrategoTerm> result;
        IConstraintContext context = this.constraintContext(env);
        IStrategoTerm term = env.current();
        List<IStrategoTerm> terms = Arrays.asList(tvars);
        Throwable throwable = null;
        Object var9_9 = null;
        try (IClosableLock lock = context.read();){
            result = this.call(context, term, terms, env.getFactory());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result.map(t -> {
            env.setCurrent((IStrategoTerm)t);
            return true;
        }).orElse(false);
    }

    protected abstract Optional<? extends IStrategoTerm> call(IConstraintContext var1, IStrategoTerm var2, List<IStrategoTerm> var3, ITermFactory var4) throws InterpreterException;

    private IConstraintContext constraintContext(IContext env) throws InterpreterException {
        Object contextObj = env.contextObject();
        if (contextObj == null) {
            throw new InterpreterException("No context present.");
        }
        if (!(contextObj instanceof IConstraintContext)) {
            throw new InterpreterException("Context does not implement IConstraintContext");
        }
        IConstraintContext context = (IConstraintContext)env.contextObject();
        return context;
    }
}

