/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego.primitive;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.metaborg.core.context.IContext;
import org.metaborg.spoofax.core.dialogs.ISpoofaxDialogService;
import org.metaborg.spoofax.core.stratego.primitive.generic.ASpoofaxContextPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;

public final class SLShowDialogPrimitive
extends ASpoofaxContextPrimitive {
    private final ISpoofaxDialogService dialogService;

    @Inject
    public SLShowDialogPrimitive(ISpoofaxDialogService dialogService) {
        super("SL_show_dialog", 0, 4);
        this.dialogService = dialogService;
    }

    @Override
    protected IStrategoTerm call(IStrategoTerm current, Strategy[] svars, IStrategoTerm[] tvars, ITermFactory factory, IContext context) {
        int defaultOption;
        List options;
        String kind;
        String caption;
        String message = TermUtils.asJavaString(current).orElse("<empty>");
        String result = this.invoke(message, caption = (String)TermUtils.asJavaString(tvars[0]).orElse(null), kind = (String)TermUtils.asJavaString(tvars[1]).orElse(null), options = (List)TermUtils.asJavaList(tvars[2]).map(l -> l.stream().map(TermUtils::asJavaString).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).orElse(null), defaultOption = TermUtils.asJavaInt(tvars[3]).orElse(0).intValue());
        return result != null ? factory.replaceTerm(factory.makeString(result), current) : null;
    }

    @Nullable
    protected String invoke(String message, @Nullable String caption, @Nullable String kind, @Nullable List<String> options, int defaultOption) {
        ISpoofaxDialogService.DialogKind dialogKind = SLShowDialogPrimitive.safeEnumValueOf(ISpoofaxDialogService.DialogKind.class, kind);
        List<ISpoofaxDialogService.DialogOption> dialogOptions = options != null ? options.stream().map(ISpoofaxDialogService.DialogOption::new).collect(Collectors.toList()) : null;
        ISpoofaxDialogService.DialogOption resultOption = this.dialogService.showDialog(message, caption, dialogKind, dialogOptions, defaultOption);
        return resultOption != null ? resultOption.getName() : null;
    }

    @Nullable
    private static <T extends Enum<T>> T safeEnumValueOf(Class<T> cls, String name2) {
        if (name2 == null) {
            return null;
        }
        Enum[] enumArray = (Enum[])cls.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum member = enumArray[n2];
            if (member.name().compareToIgnoreCase(name2) == 0) {
                return (T)member;
            }
            ++n2;
        }
        return null;
    }
}

