/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.spoofax.core.dynamicclassloading.DynamicClassLoader;
import org.metaborg.spoofax.core.dynamicclassloading.DynamicClassLoadingFacet;
import org.metaborg.spoofax.core.stratego.IStrategoRuntimeService;
import org.metaborg.spoofax.core.stratego.ResourceAgent;
import org.metaborg.spoofax.core.stratego.StrategoRuntimeFacet;
import org.metaborg.spoofax.core.stratego.strategies.ParseStrategoFileStrategy;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.IOperatorRegistry;
import org.spoofax.interpreter.terms.ITermFactory;
import org.strategoxt.HybridInterpreter;
import org.strategoxt.IncompatibleJarException;
import org.strategoxt.strc.parse_stratego_file_0_0;

public class StrategoRuntimeService
implements IStrategoRuntimeService,
AutoCloseable {
    private static final ILogger logger = LoggerUtils.logger(StrategoRuntimeService.class);
    private final IResourceService resourceService;
    private final ITermFactory termFactory;
    private final Set<IOperatorRegistry> strategoLibraries;
    private final ParseStrategoFileStrategy parseStrategoFileStrategy;
    private final Set<ClassLoader> additionalClassLoaders;
    private final Map<ILanguageComponent, HybridInterpreter> prototypes = new HashMap<ILanguageComponent, HybridInterpreter>();

    @Inject
    public StrategoRuntimeService(IResourceService resourceService, ITermFactory termFactory, Set<IOperatorRegistry> strategoLibraries, ParseStrategoFileStrategy parseStrategoFileStrategy, Set<ClassLoader> additionalClassLoaders) {
        this.resourceService = resourceService;
        this.termFactory = termFactory;
        this.strategoLibraries = strategoLibraries;
        this.parseStrategoFileStrategy = parseStrategoFileStrategy;
        this.additionalClassLoaders = additionalClassLoaders;
    }

    @Override
    public void close() {
        for (HybridInterpreter runtime : this.prototypes.values()) {
            runtime.uninit();
        }
        this.prototypes.clear();
        parse_stratego_file_0_0.instance = new parse_stratego_file_0_0();
    }

    @Override
    public HybridInterpreter runtime(ILanguageComponent component, IContext context) throws MetaborgException {
        HybridInterpreter prototype = this.prototypes.get(component);
        if (prototype == null) {
            prototype = this.createPrototype(component);
        }
        HybridInterpreter runtime = this.clone(prototype, context.location(), component);
        runtime.getContext().setContextObject(context);
        runtime.getCompiledContext().setContextObject(context);
        return runtime;
    }

    @Override
    public HybridInterpreter runtime(ILanguageComponent component, FileObject location) throws MetaborgException {
        HybridInterpreter prototype = this.prototypes.get(component);
        if (prototype == null) {
            prototype = this.createPrototype(component);
        }
        HybridInterpreter runtime = this.clone(prototype, location, component);
        return runtime;
    }

    @Override
    public HybridInterpreter genericRuntime() {
        return this.createNew(this.termFactory);
    }

    @Override
    public void invalidateCache(ILanguageComponent component) {
        logger.debug("Removing cached stratego runtime for {}", component);
        HybridInterpreter runtime = this.prototypes.remove(component);
        if (runtime != null) {
            runtime.uninit();
        }
    }

    @Override
    public void invalidateCache(ILanguageImpl impl) {
        logger.debug("Removing cached stratego runtime for {}", impl);
        for (ILanguageComponent component : impl.components()) {
            HybridInterpreter runtime = this.prototypes.remove(component);
            if (runtime == null) continue;
            runtime.uninit();
        }
    }

    private HybridInterpreter clone(HybridInterpreter prototype, FileObject workingLocation, ILanguageComponent component) {
        HybridInterpreter runtime = new HybridInterpreter(prototype, new String[0]);
        ResourceAgent agent = new ResourceAgent(this.resourceService);
        agent.setAbsoluteWorkingDir(workingLocation);
        agent.setAbsoluteDefinitionDir(component.location());
        runtime.setIOAgent(agent);
        runtime.getCompiledContext().getExceptionHandler().setEnabled(false);
        for (IOperatorRegistry library : this.strategoLibraries) {
            runtime.getCompiledContext().addOperatorRegistry(library);
        }
        runtime.getContext().setFactory(this.termFactory);
        runtime.getCompiledContext().setFactory(this.termFactory);
        runtime.init();
        return runtime;
    }

    private HybridInterpreter createNew(ITermFactory termFactory) {
        HybridInterpreter interpreter = new HybridInterpreter(termFactory);
        interpreter.getCompiledContext().registerComponent("stratego_lib");
        interpreter.getCompiledContext().registerComponent("stratego_sglr");
        for (IOperatorRegistry library : this.strategoLibraries) {
            interpreter.getCompiledContext().addOperatorRegistry(library);
        }
        parse_stratego_file_0_0.instance = this.parseStrategoFileStrategy;
        return interpreter;
    }

    private HybridInterpreter createPrototype(ILanguageComponent component) throws MetaborgException {
        logger.debug("Creating prototype runtime for {}", component);
        HybridInterpreter runtime = this.createNew(this.termFactory);
        this.loadFiles(runtime, component);
        this.prototypes.put(component, runtime);
        return runtime;
    }

    private void loadFiles(HybridInterpreter runtime, ILanguageComponent component) throws MetaborgException {
        Collection<FileObject> jars;
        StrategoRuntimeFacet strategoRuntimeFacet = component.facet(StrategoRuntimeFacet.class);
        if (strategoRuntimeFacet == null) {
            String message = String.format("Cannot get Stratego runtime for %s, it does not have a Stratego facet", component);
            logger.error(message);
            throw new MetaborgException(message);
        }
        DynamicClassLoadingFacet dynamicClassLoadingFacet = component.facet(DynamicClassLoadingFacet.class);
        if (dynamicClassLoadingFacet == null) {
            String message = String.format("Cannot get Stratego runtime for %s, it does not have a DynamicClassLoading facet", component);
            logger.error(message);
            throw new MetaborgException(message);
        }
        Collection<FileObject> ctrees = strategoRuntimeFacet.ctreeFiles;
        if (Iterables.size(ctrees) > 0) {
            StrategoRuntimeService.loadCtrees(runtime, ctrees);
        }
        if (Iterables.size(jars = dynamicClassLoadingFacet.jarFiles) > 0) {
            this.loadJars(runtime, jars);
        }
    }

    private void loadJars(HybridInterpreter runtime, Iterable<FileObject> jars) throws MetaborgException {
        try {
            URL[] classpath = new URL[Iterables.size(jars)];
            int i = 0;
            for (FileObject jar : jars) {
                File localJar = this.resourceService.localFile(jar);
                classpath[i] = localJar.toURI().toURL();
                ++i;
            }
            logger.trace("Loading jar files {}", new Object[]{classpath});
            DynamicClassLoader classLoader = new DynamicClassLoader(this.additionalClassLoaders);
            runtime.loadJars(classLoader, classpath);
        }
        catch (IOException | MetaborgRuntimeException | IncompatibleJarException e) {
            throw new MetaborgException("Failed to load JAR", e);
        }
    }

    private static void loadCtrees(HybridInterpreter runtime, Iterable<FileObject> ctrees) throws MetaborgException {
        try {
            for (FileObject file : ctrees) {
                logger.trace("Loading ctree {}", file.getName());
                runtime.load(new BufferedInputStream(file.getContent().getInputStream()));
            }
        }
        catch (IOException | InterpreterException e) {
            throw new MetaborgException("Failed to load ctree", e);
        }
    }
}

