/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.resource;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;

public class SpoofaxIgnoresSelector
implements FileSelector {
    public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
        int depth = fileInfo.getDepth();
        FileObject resource = fileInfo.getFile();
        FileName name2 = resource.getName();
        String base = name2.getBaseName();
        switch (depth) {
            case 1: {
                switch (base) {
                    case "target": 
                    case ".settings": 
                    case "bin": 
                    case "out": 
                    case ".git": 
                    case ".mvn": 
                    case ".idea": 
                    case "build": 
                    case ".gradle": 
                    case ".cache": 
                    case "include": {
                        return false;
                    }
                }
                return true;
            }
            case 3: {
                switch (base) {
                    case "trans": {
                        FileObject parent2;
                        FileObject parent1 = resource.getParent();
                        if (parent1 == null) return true;
                        String parent1base = parent1.getName().getBaseName();
                        if (!parent1base.equals("java")) {
                            if (!parent1base.equals("stratego-java")) return true;
                        }
                        if ((parent2 = parent1.getParent()) == null) return true;
                        String parent2base = parent2.getName().getBaseName();
                        if (parent2base.equals("editor")) return false;
                        if (!parent2base.equals("src-gen")) return true;
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

