/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.language.dialect;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.config.ILanguageComponentConfig;
import org.metaborg.core.language.ComponentCreationConfig;
import org.metaborg.core.language.IFacet;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.core.language.IdentificationFacet;
import org.metaborg.core.language.LanguageContributionIdentifier;
import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.core.language.ResourceExtensionFacet;
import org.metaborg.core.language.dialect.IDialectService;
import org.metaborg.spoofax.core.language.dialect.MetaFileIdentifier;
import org.metaborg.spoofax.core.syntax.SyntaxFacet;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class DialectService
implements IDialectService {
    private static final ILogger logger = LoggerUtils.logger(DialectService.class);
    private final ILanguageService languageService;
    private final Map<String, ILanguageImpl> nameToDialect = Maps.newHashMap();
    private final Map<ILanguageImpl, ILanguageImpl> dialectToBase = Maps.newHashMap();
    private final Multimap<ILanguageImpl, ILanguageImpl> baseLanguageToDialects = HashMultimap.create();

    @Inject
    public DialectService(ILanguageService languageService) {
        this.languageService = languageService;
    }

    @Override
    @Nullable
    public String dialectName(ILanguageImpl dialect) {
        ILanguageImpl base = this.getBase(dialect);
        if (base == null) {
            return null;
        }
        return dialect.id().id.substring((String.valueOf(base.id().id) + "-Dialect-").length());
    }

    @Override
    public boolean hasDialect(String name2) {
        return this.nameToDialect.containsKey(name2);
    }

    @Override
    @Nullable
    public ILanguageImpl getDialect(String name2) {
        return this.nameToDialect.get(name2);
    }

    @Override
    public Iterable<ILanguageImpl> getDialects(ILanguageImpl base) {
        return this.baseLanguageToDialects.get((Object)base);
    }

    @Override
    public ILanguageImpl getBase(ILanguageImpl dialect) {
        return this.dialectToBase.get(dialect);
    }

    @Override
    public ILanguageImpl add(String name2, FileObject location, ILanguageImpl base, IFacet syntaxFacet) {
        if (this.nameToDialect.containsKey(name2)) {
            String message = String.format("Dialect with name %s already exists", name2);
            logger.error(message);
            throw new MetaborgRuntimeException(message);
        }
        logger.debug("Adding dialect {} from {} with {} as base", name2, location, base);
        ILanguageImpl dialect = this.createDialect(name2, location, base, syntaxFacet, true, true);
        this.nameToDialect.put(name2, dialect);
        this.dialectToBase.put(dialect, base);
        this.baseLanguageToDialects.put((Object)base, (Object)dialect);
        return dialect;
    }

    @Override
    public ILanguageImpl update(String name2, IFacet syntaxFacet) {
        ILanguageImpl dialect = this.nameToDialect.get(name2);
        if (dialect == null) {
            String message = String.format("Dialect with name %s does not exist", name2);
            logger.error(message);
            throw new MetaborgRuntimeException(message);
        }
        logger.debug("Updating syntax facet for dialect {}", name2);
        FileObject location = ((ILanguageComponent)Iterables.get(dialect.components(), (int)0)).location();
        ILanguageImpl newDialect = this.createDialect(name2, location, dialect, syntaxFacet, false, false);
        this.nameToDialect.put(name2, newDialect);
        return newDialect;
    }

    @Override
    public Iterable<ILanguageImpl> update(ILanguageImpl base) {
        Collection dialects = this.baseLanguageToDialects.get((Object)base);
        if (dialects.isEmpty()) {
            return dialects;
        }
        logger.debug("Updating base language for {} dialects", dialects.size());
        ArrayList newDialects = Lists.newArrayListWithCapacity((int)dialects.size());
        for (ILanguageImpl dialect : dialects) {
            ILanguageImpl newDialect;
            String name2 = dialect.belongsTo().name();
            FileObject location = ((ILanguageComponent)Iterables.get(dialect.components(), (int)0)).location();
            SyntaxFacet syntaxFacet = dialect.facet(SyntaxFacet.class);
            try {
                newDialect = this.createDialect(name2, location, base, syntaxFacet, true, true);
            }
            catch (IllegalStateException e) {
                String message = String.format("Error updating dialect %s", name2);
                logger.error(message, e);
                continue;
            }
            this.nameToDialect.put(name2, newDialect);
            newDialects.add(newDialect);
        }
        return newDialects;
    }

    @Override
    public ILanguageImpl remove(String name2) {
        ILanguageImpl dialect = this.nameToDialect.remove(name2);
        if (dialect == null) {
            String message = String.format("Dialect with name %s does not exist", name2);
            logger.error(message);
            throw new MetaborgRuntimeException(message);
        }
        logger.debug("Removing dialect {}", name2);
        ILanguageImpl base = this.dialectToBase.remove(dialect);
        this.baseLanguageToDialects.remove((Object)base, (Object)dialect);
        try {
            ILanguageComponent dialectComponent = (ILanguageComponent)Iterables.get(dialect.components(), (int)0);
            this.languageService.remove(dialectComponent);
        }
        catch (IllegalStateException e) {
            String message = String.format("Error removing dialect %s", name2);
            logger.error(message, e);
        }
        return dialect;
    }

    @Override
    public Iterable<ILanguageImpl> remove(ILanguageImpl base) {
        Collection dialects = this.baseLanguageToDialects.get((Object)base);
        if (dialects.isEmpty()) {
            return dialects;
        }
        logger.debug("Removing {} dialects for base language {}", dialects.size(), base);
        ArrayList removedDialects = Lists.newArrayListWithCapacity((int)dialects.size());
        for (ILanguageImpl dialect : dialects) {
            String name2 = dialect.belongsTo().name();
            this.nameToDialect.remove(name2);
            this.dialectToBase.remove(dialect);
            this.baseLanguageToDialects.remove((Object)base, (Object)dialect);
            try {
                ILanguageComponent dialectComponent = (ILanguageComponent)Iterables.get(dialect.components(), (int)0);
                this.languageService.remove(dialectComponent);
            }
            catch (IllegalStateException e) {
                String message = String.format("Error removing dialect %s", name2);
                logger.error(message, e);
                continue;
            }
            removedDialects.add(dialect);
        }
        return removedDialects;
    }

    private ILanguageImpl createDialect(String name2, FileObject location, ILanguageImpl base, IFacet syntaxFacet, boolean replaceIdentification, boolean appendDialectName) {
        LanguageIdentifier baseId = base.id();
        String dialectId = appendDialectName ? String.valueOf(baseId.id) + "-Dialect-" + name2 : baseId.id;
        LanguageIdentifier id = new LanguageIdentifier(baseId.groupId, dialectId, baseId.version);
        ILanguageComponentConfig config = ((ILanguageComponent)Iterables.get(base.components(), (int)0)).config();
        ComponentCreationConfig creationConfig = this.languageService.create(id, location, Iterables2.singleton(new LanguageContributionIdentifier(id, name2)), config);
        for (IFacet facet : base.facets()) {
            if (facet instanceof IdentificationFacet && replaceIdentification) {
                creationConfig.addFacet(new IdentificationFacet(new MetaFileIdentifier((IdentificationFacet)facet)));
                continue;
            }
            if (facet instanceof SyntaxFacet || facet instanceof ResourceExtensionFacet) continue;
            creationConfig.addFacet(facet);
        }
        creationConfig.addFacet(syntaxFacet);
        ILanguageComponent dialectComponent = this.languageService.add(creationConfig);
        ILanguageImpl dialect = (ILanguageImpl)Iterables.get(dialectComponent.contributesTo(), (int)0);
        return dialect;
    }
}

