/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.language.dialect;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.language.IFacet;
import org.metaborg.core.language.ILanguage;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.core.language.LanguageImplChange;
import org.metaborg.core.language.dialect.IDialectProcessor;
import org.metaborg.core.language.dialect.IDialectService;
import org.metaborg.core.resource.ResourceChange;
import org.metaborg.core.resource.ResourceChangeKind;
import org.metaborg.spoofax.core.resource.SpoofaxIgnoresSelector;
import org.metaborg.spoofax.core.syntax.SyntaxFacet;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.resource.ExtensionFileSelector;
import org.metaborg.util.resource.FileSelectorUtils;

public class DialectProcessor
implements IDialectProcessor {
    private static final ILogger logger = LoggerUtils.logger(DialectProcessor.class);
    private final ILanguageService languageService;
    private final IDialectService dialectService;
    private final FileSelector selector;

    @Inject
    public DialectProcessor(ILanguageService languageService, IDialectService dialectService) {
        this.languageService = languageService;
        this.dialectService = dialectService;
        this.selector = FileSelectorUtils.and(new ExtensionFileSelector("tbl"), new SpoofaxIgnoresSelector());
    }

    @Override
    public void update(FileObject location, Iterable<ResourceChange> changes) {
        int numChanges = Iterables.size(changes);
        if (numChanges == 0) {
            return;
        }
        ILanguage strategoLanguage = this.languageService.getLanguage("Stratego-Sugar");
        if (strategoLanguage == null) {
            logger.debug("Could not find Stratego language, Stratego dialects cannot be updated");
            return;
        }
        ILanguageImpl strategoImpl = strategoLanguage.activeImpl();
        if (strategoImpl == null) {
            logger.debug("Could not find active Stratego language implementation, Stratego dialects cannot be updated");
            return;
        }
        logger.debug("Processing dialect updates for {}", location);
        SyntaxFacet baseFacet = strategoImpl.facet(SyntaxFacet.class);
        if (baseFacet == null) {
            logger.debug("Active Stratego language implementation has no syntax facet, Stratego dialects cannot be updated");
            return;
        }
        block11: for (ResourceChange change : changes) {
            FileObject resource = change.resource;
            try {
                if (!FileSelectorUtils.include(this.selector, resource, location)) {
                }
            }
            catch (FileSystemException e) {}
            continue;
            String fileName = FilenameUtils.getBaseName((String)resource.getName().getBaseName());
            SyntaxFacet newFacet = new SyntaxFacet(resource, baseFacet.completionParseTable, baseFacet.startSymbols, baseFacet.singleLineCommentPrefixes, baseFacet.multiLineCommentCharacters, baseFacet.fenceCharacters, baseFacet.imploder);
            ResourceChangeKind changeKind = change.kind;
            try {
                switch (changeKind) {
                    case Create: {
                        this.add(fileName, resource, strategoImpl, newFacet);
                        break;
                    }
                    case Delete: {
                        this.remove(fileName, resource);
                        break;
                    }
                    case Modify: {
                        this.update(fileName, resource, newFacet);
                        break;
                    }
                    case Rename: {
                        if (change.from != null) {
                            this.remove(fileName, resource);
                        }
                        if (change.to == null) continue block11;
                        this.add(fileName, resource, strategoImpl, newFacet);
                        break;
                    }
                    case Copy: {
                        if (change.to == null) continue block11;
                        this.add(fileName, resource, strategoImpl, newFacet);
                        break;
                    }
                    default: {
                        logger.error("Unhandled resource change kind {}", new Object[]{changeKind});
                        break;
                    }
                }
            }
            catch (MetaborgRuntimeException e) {
                logger.error("Failed to update dialect", e);
            }
        }
    }

    @Override
    public void update(LanguageImplChange change) {
        switch (change.kind) {
            case Add: {
                break;
            }
            case Reload: {
                this.dialectService.update(change.impl);
                break;
            }
            case Remove: {
                this.dialectService.remove(change.impl);
                break;
            }
        }
    }

    private void add(String name2, FileObject location, ILanguageImpl base, IFacet syntaxFacet) {
        if (this.dialectService.hasDialect(name2)) {
            logger.debug("Trying to create dialect {} that already exists, from {}", name2, location);
            return;
        }
        this.dialectService.add(name2, location, base, syntaxFacet);
    }

    private void remove(String name2, FileObject location) {
        if (!this.dialectService.hasDialect(name2)) {
            logger.warn("Trying to delete dialect {} that does not exist, from {}", name2, location);
            return;
        }
        this.dialectService.remove(name2);
    }

    private void update(String name2, FileObject location, IFacet syntaxFacet) {
        if (!this.dialectService.hasDialect(name2)) {
            logger.warn("Trying to update dialect {} that does not exist, from {}", name2, location);
            return;
        }
        this.dialectService.update(name2, syntaxFacet);
    }
}

