/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.config.language;

import java.util.List;
import java.util.Set;
import mb.statix.spoofax.IStatixProjectConfig;
import mb.statix.spoofax.StatixProjectConfig;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;

public class StatixProjectConfigReaderWriter {
    private static final String PROP_CONCURRENT = "concurrent";
    private static final String PROP_MESSAGE_TRACE_LENGTH = "message-trace-length";
    private static final String PROP_MESSAGE_TERM_DEPTH = "message-term-depth";

    public static IStatixProjectConfig read(HierarchicalConfiguration<ImmutableNode> config) {
        List parallelLanguages = config.getList(String.class, PROP_CONCURRENT, null);
        Integer messageStacktraceLength = config.getInteger(PROP_MESSAGE_TRACE_LENGTH, null);
        Integer messageTermDepth = config.getInteger(PROP_MESSAGE_TERM_DEPTH, null);
        return new StatixProjectConfig(parallelLanguages, messageStacktraceLength, messageTermDepth);
    }

    public static void write(IStatixProjectConfig statixConfig, HierarchicalConfiguration<ImmutableNode> config) {
        Integer messageTermDepth;
        Integer messageStacktraceLength;
        Set<String> parallelLanguages = statixConfig.parallelLanguages(null);
        if (parallelLanguages != null) {
            config.setProperty(PROP_CONCURRENT, parallelLanguages);
        }
        if ((messageStacktraceLength = statixConfig.messageTraceLength(null)) != null) {
            config.setProperty(PROP_MESSAGE_TRACE_LENGTH, (Object)messageStacktraceLength);
        }
        if ((messageTermDepth = statixConfig.messageTermDepth(null)) != null) {
            config.setProperty(PROP_MESSAGE_TERM_DEPTH, (Object)messageTermDepth);
        }
    }
}

