/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.grammar.layoutconstraints;

import java.io.Serializable;
import java.util.List;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.layoutconstraints.ConstraintElement;
import org.metaborg.sdf2table.grammar.layoutconstraints.ConstraintSelector;
import org.metaborg.sdf2table.grammar.layoutconstraints.ILayoutConstraint;

public class NumericLayoutConstraint
implements Serializable,
ILayoutConstraint {
    private static final long serialVersionUID = 3882560568034774612L;
    private final ConstraintElement elem;
    private final ConstraintSelector token;
    private int tree;

    public NumericLayoutConstraint(ConstraintElement elem, ConstraintSelector token, int tree) {
        this.elem = elem;
        this.token = token;
        this.tree = tree;
    }

    public NumericLayoutConstraint(int num) {
        this.tree = num;
        this.token = null;
        this.elem = null;
    }

    public String toString() {
        return String.valueOf(this.tree) + "." + (Object)((Object)this.token) + "." + (Object)((Object)this.elem);
    }

    public ConstraintElement getElem() {
        return this.elem;
    }

    public ConstraintSelector getToken() {
        return this.token;
    }

    public int getTree() {
        return this.tree;
    }

    @Override
    public void normalizeConstraint(List<ISymbol> rhs) {
        if (this.elem == null && this.token == null) {
            return;
        }
        int normalizedtree = 0;
        int count = this.tree;
        for (ISymbol s : rhs) {
            if (s.toString().equals("LAYOUT?-CF")) {
                ++normalizedtree;
                continue;
            }
            if (--count < 0) {
                this.tree = normalizedtree;
                return;
            }
            ++normalizedtree;
        }
    }
}

