/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.grammar;

import java.io.Serializable;
import org.metaborg.sdf2table.grammar.IAttribute;
import org.metaborg.sdf2table.grammar.layoutconstraints.ArithmeticLayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.BooleanLayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.ComparisonLayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.ConstraintElement;
import org.metaborg.sdf2table.grammar.layoutconstraints.ConstraintSelector;
import org.metaborg.sdf2table.grammar.layoutconstraints.ILayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.IgnoreLayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.LayoutConstraintArithmeticOperator;
import org.metaborg.sdf2table.grammar.layoutconstraints.LayoutConstraintBooleanOperator;
import org.metaborg.sdf2table.grammar.layoutconstraints.LayoutConstraintComparisonOperator;
import org.metaborg.sdf2table.grammar.layoutconstraints.NumericLayoutConstraint;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;

public class LayoutConstraintAttribute
implements IAttribute,
Serializable {
    private static final long serialVersionUID = -6962864785117290116L;
    private final ILayoutConstraint lc;
    private final IStrategoTerm constraint;

    protected LayoutConstraintAttribute(IStrategoTerm constraint) throws Exception {
        this.constraint = constraint;
        this.lc = this.createLayoutConstraint(constraint);
    }

    public String toString() {
        if (TermUtils.isAppl(this.constraint) && ((IStrategoAppl)this.constraint).getName().equals("IgnoreLayout")) {
            return "ignore-layout";
        }
        return this.lc.toString();
    }

    @Override
    public IStrategoTerm toAterm(ITermFactory tf) {
        if (TermUtils.isAppl(this.constraint) && ((IStrategoAppl)this.constraint).getName().equals("IgnoreLayout")) {
            return tf.makeAppl(tf.makeConstructor("term", 1), tf.makeAppl(tf.makeConstructor("ignore-layout", 0), new IStrategoTerm[0]));
        }
        try {
            IStrategoTerm sdf2Constraint = this.toSDF2constraint(this.constraint, tf);
            return tf.makeAppl(tf.makeConstructor("term", 1), tf.makeAppl(tf.makeConstructor("layout", 1), sdf2Constraint != null ? sdf2Constraint : tf.makeAppl(tf.makeConstructor("null", 0), new IStrategoTerm[0])));
        }
        catch (Exception e) {
            System.err.println("Layout constraint could not be transformed to SDF2 constraint.");
            return tf.makeAppl(tf.makeConstructor("layout", 1), tf.makeAppl(tf.makeConstructor("null", 0), new IStrategoTerm[0]));
        }
    }

    @Override
    public IStrategoTerm toSDF3Aterm(ITermFactory tf) {
        if (TermUtils.isAppl(this.constraint) && ((IStrategoAppl)this.constraint).getName().equals("IgnoreLayout")) {
            return tf.makeAppl(tf.makeConstructor("Term", 1), tf.makeAppl(tf.makeConstructor("IgnoreLayout", 0), new IStrategoTerm[0]));
        }
        return tf.makeAppl(tf.makeConstructor("Term", 1), tf.makeAppl(tf.makeConstructor("layout", 1), this.constraint));
    }

    public ILayoutConstraint getLayoutConstraint() {
        return this.lc;
    }

    private ILayoutConstraint createLayoutConstraint(IStrategoTerm constraintTerm) throws Exception {
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("IgnoreLayout")) {
            return new IgnoreLayoutConstraint();
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Num")) {
            return new NumericLayoutConstraint(Integer.parseInt(((IStrategoString)constraintTerm.getSubterm(0)).stringValue()));
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("And")) {
            return new BooleanLayoutConstraint(this.createLayoutConstraint(constraintTerm.getSubterm(0)), LayoutConstraintBooleanOperator.AND, this.createLayoutConstraint(constraintTerm.getSubterm(1)));
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Or")) {
            return new BooleanLayoutConstraint(this.createLayoutConstraint(constraintTerm.getSubterm(0)), LayoutConstraintBooleanOperator.OR, this.createLayoutConstraint(constraintTerm.getSubterm(1)));
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Not")) {
            return new BooleanLayoutConstraint(this.createLayoutConstraint(constraintTerm.getSubterm(0)), LayoutConstraintBooleanOperator.NOT, null);
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Lt")) {
            return new ComparisonLayoutConstraint(this.createLayoutConstraint(constraintTerm.getSubterm(0)), LayoutConstraintComparisonOperator.LT, this.createLayoutConstraint(constraintTerm.getSubterm(1)));
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Gt")) {
            return new ComparisonLayoutConstraint(this.createLayoutConstraint(constraintTerm.getSubterm(0)), LayoutConstraintComparisonOperator.GT, this.createLayoutConstraint(constraintTerm.getSubterm(1)));
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Le")) {
            return new ComparisonLayoutConstraint(this.createLayoutConstraint(constraintTerm.getSubterm(0)), LayoutConstraintComparisonOperator.LE, this.createLayoutConstraint(constraintTerm.getSubterm(1)));
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Ge")) {
            return new ComparisonLayoutConstraint(this.createLayoutConstraint(constraintTerm.getSubterm(0)), LayoutConstraintComparisonOperator.GE, this.createLayoutConstraint(constraintTerm.getSubterm(1)));
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Eq")) {
            return new ComparisonLayoutConstraint(this.createLayoutConstraint(constraintTerm.getSubterm(0)), LayoutConstraintComparisonOperator.EQ, this.createLayoutConstraint(constraintTerm.getSubterm(1)));
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Add")) {
            return new ArithmeticLayoutConstraint(this.createLayoutConstraint(constraintTerm.getSubterm(0)), LayoutConstraintArithmeticOperator.ADD, this.createLayoutConstraint(constraintTerm.getSubterm(1)));
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Sub")) {
            return new ArithmeticLayoutConstraint(this.createLayoutConstraint(constraintTerm.getSubterm(0)), LayoutConstraintArithmeticOperator.SUB, this.createLayoutConstraint(constraintTerm.getSubterm(1)));
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Div")) {
            return new ArithmeticLayoutConstraint(this.createLayoutConstraint(constraintTerm.getSubterm(0)), LayoutConstraintArithmeticOperator.DIV, this.createLayoutConstraint(constraintTerm.getSubterm(1)));
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Mul")) {
            return new ArithmeticLayoutConstraint(this.createLayoutConstraint(constraintTerm.getSubterm(0)), LayoutConstraintArithmeticOperator.MUL, this.createLayoutConstraint(constraintTerm.getSubterm(1)));
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Line")) {
            return new NumericLayoutConstraint(ConstraintElement.LINE, this.createToken(constraintTerm.getSubterm(0)), this.createTree(constraintTerm.getSubterm(0).getSubterm(0)));
        }
        if (TermUtils.isAppl(constraintTerm) && ((IStrategoAppl)constraintTerm).getName().equals("Col")) {
            return new NumericLayoutConstraint(ConstraintElement.COL, this.createToken(constraintTerm.getSubterm(0)), this.createTree(constraintTerm.getSubterm(0).getSubterm(0)));
        }
        throw new Exception("Not a valid Layout Constraint: " + this.constraint);
    }

    private int createTree(IStrategoTerm term) throws Exception {
        if (TermUtils.isAppl(term) && ((IStrategoAppl)term).getName().equals("Tree")) {
            try {
                return Integer.parseInt(((IStrategoString)term.getSubterm(0)).stringValue());
            }
            catch (Exception e) {
                throw new Exception("Expected valid integer corresponding to tree.");
            }
        }
        throw new Exception("Expected valid integer corresponding to tree.");
    }

    private ConstraintSelector createToken(IStrategoTerm t) throws Exception {
        block16: {
            if (!TermUtils.isAppl(t)) break block16;
            switch (((IStrategoAppl)t).getName()) {
                case "First": {
                    return ConstraintSelector.FIRST;
                }
                case "Last": {
                    return ConstraintSelector.LAST;
                }
                case "Left": {
                    return ConstraintSelector.LEFT;
                }
                case "Right": {
                    return ConstraintSelector.RIGHT;
                }
            }
            throw new Exception("Expected first, last, left or right as tree selector.");
        }
        throw new Exception("Expected first, last, left or right as tree selector.");
    }

    private IStrategoTerm toSDF2constraint(IStrategoTerm c, ITermFactory tf) throws Exception {
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("IgnoreLayout")) {
            return tf.makeAppl(tf.makeConstructor("ignore-layout", 0), new IStrategoTerm[0]);
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Num")) {
            String tree = c.getSubterm(0).toString();
            return tf.makeAppl(tf.makeConstructor("num", 1), tf.makeString(tree));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("And")) {
            return tf.makeAppl(tf.makeConstructor("and", 2), this.toSDF2constraint(c.getSubterm(0), tf), this.toSDF2constraint(c.getSubterm(1), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Or")) {
            return tf.makeAppl(tf.makeConstructor("or", 2), this.toSDF2constraint(c.getSubterm(0), tf), this.toSDF2constraint(c.getSubterm(1), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Not")) {
            return tf.makeAppl(tf.makeConstructor("not", 1), this.toSDF2constraint(c.getSubterm(0), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Lt")) {
            return tf.makeAppl(tf.makeConstructor("lt", 2), this.toSDF2constraint(c.getSubterm(0), tf), this.toSDF2constraint(c.getSubterm(1), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Gt")) {
            return tf.makeAppl(tf.makeConstructor("gt", 2), this.toSDF2constraint(c.getSubterm(0), tf), this.toSDF2constraint(c.getSubterm(1), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Le")) {
            return tf.makeAppl(tf.makeConstructor("le", 2), this.toSDF2constraint(c.getSubterm(0), tf), this.toSDF2constraint(c.getSubterm(1), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Ge")) {
            return tf.makeAppl(tf.makeConstructor("ge", 2), this.toSDF2constraint(c.getSubterm(0), tf), this.toSDF2constraint(c.getSubterm(1), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Eq")) {
            return tf.makeAppl(tf.makeConstructor("eq", 2), this.toSDF2constraint(c.getSubterm(0), tf), this.toSDF2constraint(c.getSubterm(1), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Add")) {
            return tf.makeAppl(tf.makeConstructor("add", 2), this.toSDF2constraint(c.getSubterm(0), tf), this.toSDF2constraint(c.getSubterm(1), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Sub")) {
            return tf.makeAppl(tf.makeConstructor("sub", 2), this.toSDF2constraint(c.getSubterm(0), tf), this.toSDF2constraint(c.getSubterm(1), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Div")) {
            return tf.makeAppl(tf.makeConstructor("div", 2), this.toSDF2constraint(c.getSubterm(0), tf), this.toSDF2constraint(c.getSubterm(1), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Mul")) {
            return tf.makeAppl(tf.makeConstructor("mul", 2), this.toSDF2constraint(c.getSubterm(0), tf), this.toSDF2constraint(c.getSubterm(1), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Line")) {
            return tf.makeAppl(tf.makeConstructor("line", 1), this.toSDF2constraint(c.getSubterm(0), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Col")) {
            return tf.makeAppl(tf.makeConstructor("col", 1), this.toSDF2constraint(c.getSubterm(0), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("First")) {
            return tf.makeAppl(tf.makeConstructor("first", 1), this.toSDF2constraint(c.getSubterm(0), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Last")) {
            return tf.makeAppl(tf.makeConstructor("last", 1), this.toSDF2constraint(c.getSubterm(0), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Left")) {
            return tf.makeAppl(tf.makeConstructor("left", 1), this.toSDF2constraint(c.getSubterm(0), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Right")) {
            return tf.makeAppl(tf.makeConstructor("right", 1), this.toSDF2constraint(c.getSubterm(0), tf));
        }
        if (TermUtils.isAppl(c) && ((IStrategoAppl)c).getName().equals("Tree")) {
            String tree = c.getSubterm(0).toString();
            return tf.makeInt(Integer.parseInt(tree.substring(1, tree.length() - 1)));
        }
        throw new Exception("Not a valid Layout Constraint: " + c);
    }
}

