/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.grammar;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.sdf2table.grammar.AltSymbol;
import org.metaborg.sdf2table.grammar.CharacterClassSymbol;
import org.metaborg.sdf2table.grammar.ConstructorAttribute;
import org.metaborg.sdf2table.grammar.ContextFreeSymbol;
import org.metaborg.sdf2table.grammar.DeprecatedAttribute;
import org.metaborg.sdf2table.grammar.EOFSymbol;
import org.metaborg.sdf2table.grammar.FileStartSymbol;
import org.metaborg.sdf2table.grammar.GeneralAttribute;
import org.metaborg.sdf2table.grammar.IterSepSymbol;
import org.metaborg.sdf2table.grammar.IterStarSepSymbol;
import org.metaborg.sdf2table.grammar.IterStarSymbol;
import org.metaborg.sdf2table.grammar.IterSymbol;
import org.metaborg.sdf2table.grammar.Layout;
import org.metaborg.sdf2table.grammar.LayoutConstraintAttribute;
import org.metaborg.sdf2table.grammar.LexicalSymbol;
import org.metaborg.sdf2table.grammar.LiteralType;
import org.metaborg.sdf2table.grammar.OptionalSymbol;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Production;
import org.metaborg.sdf2table.grammar.ProductionReference;
import org.metaborg.sdf2table.grammar.SequenceSymbol;
import org.metaborg.sdf2table.grammar.Sort;
import org.metaborg.sdf2table.grammar.StartSymbol;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.grammar.TermAttribute;
import org.metaborg.sdf2table.grammar.UniqueProduction;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class GrammarFactory
implements Serializable {
    private static final long serialVersionUID = -3963847554036972197L;
    private final Map<List<Object>, AltSymbol> altSymbols = Maps.newHashMap();
    private final Map<ICharacterClass, CharacterClassSymbol> characterClassSymbols = Maps.newHashMap();
    private final Map<String, ConstructorAttribute> constructorAttributes = Maps.newHashMap();
    private final Map<Symbol, ContextFreeSymbol> contextFreeSymbols = Maps.newHashMap();
    private final Map<Symbol, LexicalSymbol> lexicalSymbols = Maps.newHashMap();
    private final Map<Symbol, OptionalSymbol> optionalSymbols = Maps.newHashMap();
    private final Map<String, DeprecatedAttribute> deprecatedAttributes = Maps.newHashMap();
    private final Map<String, GeneralAttribute> generalAttributes = Maps.newHashMap();
    private final Map<List<Object>, IterSepSymbol> iterSepSymbols = Maps.newHashMap();
    private final Map<List<Object>, IterStarSepSymbol> iterStarSepSymbols = Maps.newHashMap();
    private final Map<Symbol, IterStarSymbol> iterStarSymbols = Maps.newHashMap();
    private final Map<Symbol, IterSymbol> iterSymbols = Maps.newHashMap();
    private final Map<List<Object>, SequenceSymbol> sequenceSymbols;
    private final Map<List<Object>, Sort> sorts;
    private final Map<List<Object>, Priority> priorities = Maps.newHashMap();
    private final Map<List<Object>, Production> productions;
    private final Map<List<Object>, UniqueProduction> uniqueProductions;
    private final Map<List<Object>, ProductionReference> productionReferences;
    private final Map<List<Object>, TermAttribute> termAttributes;
    private Layout layoutSymbol;
    private FileStartSymbol fileStartSymbol;
    private StartSymbol startSymbol;
    private EOFSymbol eofSymbol;

    public GrammarFactory() {
        this.sequenceSymbols = Maps.newHashMap();
        this.productions = Maps.newHashMap();
        this.uniqueProductions = Maps.newHashMap();
        this.productionReferences = Maps.newHashMap();
        this.sorts = Maps.newHashMap();
        this.termAttributes = Maps.newHashMap();
    }

    public AltSymbol createAltSymbol(Symbol s1, Symbol s2) {
        ArrayList altSymbolFields = Lists.newArrayList();
        altSymbolFields.add(s1);
        altSymbolFields.add(s2);
        if (this.altSymbols.containsKey(altSymbolFields)) {
            return this.altSymbols.get(altSymbolFields);
        }
        AltSymbol altSymbol = new AltSymbol(s1, s2);
        this.altSymbols.put(altSymbolFields, altSymbol);
        return altSymbol;
    }

    public CharacterClassSymbol createCharClassSymbol(ICharacterClass cc) {
        if (this.characterClassSymbols.containsKey(cc)) {
            return this.characterClassSymbols.get(cc);
        }
        CharacterClassSymbol ccSymbol = new CharacterClassSymbol(cc);
        this.characterClassSymbols.put(cc, ccSymbol);
        return ccSymbol;
    }

    public ConstructorAttribute createConstructorAttribute(String cons) {
        if (this.constructorAttributes.containsKey(cons)) {
            return this.constructorAttributes.get(cons);
        }
        ConstructorAttribute ca = new ConstructorAttribute(cons);
        this.constructorAttributes.put(cons, ca);
        return ca;
    }

    public ContextFreeSymbol createContextFreeSymbol(Symbol symbol) {
        if (this.contextFreeSymbols.containsKey(symbol)) {
            return this.contextFreeSymbols.get(symbol);
        }
        ContextFreeSymbol cfs = new ContextFreeSymbol(symbol);
        this.contextFreeSymbols.put(symbol, cfs);
        return cfs;
    }

    public LexicalSymbol createLexicalSymbol(Symbol s) {
        if (this.lexicalSymbols.containsKey(s)) {
            return this.lexicalSymbols.get(s);
        }
        LexicalSymbol cfs = new LexicalSymbol(s);
        this.lexicalSymbols.put(s, cfs);
        return cfs;
    }

    public IterSymbol createIterSymbol(Symbol s) {
        if (this.iterSymbols.containsKey(s)) {
            return this.iterSymbols.get(s);
        }
        IterSymbol is = new IterSymbol(s);
        this.iterSymbols.put(s, is);
        return is;
    }

    public IterStarSymbol createIterStarSymbol(Symbol s) {
        if (this.iterStarSymbols.containsKey(s)) {
            return this.iterStarSymbols.get(s);
        }
        IterStarSymbol iss = new IterStarSymbol(s);
        this.iterStarSymbols.put(s, iss);
        return iss;
    }

    public IterSepSymbol createIterSepSymbol(Symbol symbol, Sort separator) {
        ArrayList iterSepFields = Lists.newArrayList();
        iterSepFields.add(symbol);
        iterSepFields.add(separator);
        if (this.iterSepSymbols.containsKey(iterSepFields)) {
            return this.iterSepSymbols.get(iterSepFields);
        }
        IterSepSymbol iterSepSymbol = new IterSepSymbol(symbol, separator);
        this.iterSepSymbols.put(iterSepFields, iterSepSymbol);
        return iterSepSymbol;
    }

    public IterStarSepSymbol createIterStarSepSymbol(Symbol s, Sort sep) {
        ArrayList iterStarSepFields = Lists.newArrayList();
        iterStarSepFields.add(s);
        iterStarSepFields.add(sep);
        if (this.iterStarSepSymbols.containsKey(iterStarSepFields)) {
            return this.iterStarSepSymbols.get(iterStarSepFields);
        }
        IterStarSepSymbol iterStarSepSymbol = new IterStarSepSymbol(s, sep);
        this.iterStarSepSymbols.put(iterStarSepFields, iterStarSepSymbol);
        return iterStarSepSymbol;
    }

    public OptionalSymbol createOptionalSymbol(Symbol s) {
        if (this.optionalSymbols.containsKey(s)) {
            return this.optionalSymbols.get(s);
        }
        OptionalSymbol os = new OptionalSymbol(s);
        this.optionalSymbols.put(s, os);
        return os;
    }

    public DeprecatedAttribute createDeprecatedAttribute(String message) {
        if (this.deprecatedAttributes.containsKey(message)) {
            return this.deprecatedAttributes.get(message);
        }
        DeprecatedAttribute da = new DeprecatedAttribute(message);
        this.deprecatedAttributes.put(message, da);
        return da;
    }

    public GeneralAttribute createGeneralAttribute(String name2) {
        if (this.generalAttributes.containsKey(name2)) {
            return this.generalAttributes.get(name2);
        }
        GeneralAttribute ga = new GeneralAttribute(name2);
        this.generalAttributes.put(name2, ga);
        return ga;
    }

    public LayoutConstraintAttribute createLayoutConstraintAttribute(IStrategoTerm t) throws Exception {
        LayoutConstraintAttribute lca = new LayoutConstraintAttribute(t);
        return lca;
    }

    public Priority createPriority(Production higher, Production lower, boolean transitive) {
        ArrayList priorityFields = Lists.newArrayList();
        priorityFields.add(higher);
        priorityFields.add(lower);
        priorityFields.add(transitive);
        if (this.priorities.containsKey(priorityFields)) {
            return this.priorities.get(priorityFields);
        }
        Priority p = new Priority(higher, lower, transitive);
        this.priorities.put(priorityFields, p);
        return p;
    }

    public Production createProduction(Symbol lhs, List<Symbol> rhs) {
        ArrayList productionFields = Lists.newArrayList();
        productionFields.add(lhs);
        productionFields.addAll(rhs);
        if (this.productions.containsKey(productionFields)) {
            return this.productions.get(productionFields);
        }
        Production p = new Production(lhs, rhs);
        this.productions.put(productionFields, p);
        return p;
    }

    public Production createProduction(Symbol lhs, List<Symbol> rhs, int leftRecursivePos, int rightRecursivePos) {
        ArrayList productionFields = Lists.newArrayList();
        productionFields.add(lhs);
        productionFields.addAll(rhs);
        if (this.productions.containsKey(productionFields)) {
            Production p = this.productions.get(productionFields);
            p.setLeftRecursivePosition(leftRecursivePos);
            p.setRightRecursivePosition(rightRecursivePos);
            return p;
        }
        Production p = new Production(lhs, rhs, leftRecursivePos, rightRecursivePos);
        this.productions.put(productionFields, p);
        return p;
    }

    public ProductionReference createProductionReference(Symbol s, ConstructorAttribute cons) {
        ArrayList productionReferenceFields = Lists.newArrayList((Object[])new Object[]{s, cons});
        if (this.productionReferences.containsKey(productionReferenceFields)) {
            return this.productionReferences.get(productionReferenceFields);
        }
        ProductionReference pr = new ProductionReference(s, cons);
        this.productionReferences.put(productionReferenceFields, pr);
        return pr;
    }

    public SequenceSymbol createSequenceSymbol(Symbol first, List<Symbol> tail) {
        ArrayList sequenceSymbolFields = Lists.newArrayList((Object[])new Object[]{first});
        sequenceSymbolFields.addAll(tail);
        if (this.sequenceSymbols.containsKey(sequenceSymbolFields)) {
            return this.sequenceSymbols.get(sequenceSymbolFields);
        }
        SequenceSymbol ss = new SequenceSymbol(first, tail);
        this.sequenceSymbols.put(sequenceSymbolFields, ss);
        return ss;
    }

    public Sort createSort(String s) {
        ArrayList sortFields = Lists.newArrayList((Object[])new Object[]{s, null});
        if (this.sorts.containsKey(sortFields)) {
            return this.sorts.get(sortFields);
        }
        Sort sort = new Sort(s);
        this.sorts.put(sortFields, sort);
        return sort;
    }

    public Symbol createSort(String s, LiteralType lit2) {
        ArrayList sortFields = Lists.newArrayList((Object[])new Object[]{s, lit2});
        if (this.sorts.containsKey(sortFields)) {
            return this.sorts.get(sortFields);
        }
        Sort sort = new Sort(s, lit2);
        this.sorts.put(sortFields, sort);
        return sort;
    }

    public Layout createLayoutSymbol() {
        if (this.layoutSymbol == null) {
            this.layoutSymbol = new Layout();
        }
        return this.layoutSymbol;
    }

    public FileStartSymbol createFileStartSymbol() {
        if (this.fileStartSymbol == null) {
            this.fileStartSymbol = new FileStartSymbol();
        }
        return this.fileStartSymbol;
    }

    public Symbol createStartSymbol() {
        if (this.startSymbol == null) {
            this.startSymbol = new StartSymbol();
        }
        return this.startSymbol;
    }

    public Symbol createEOFSymbol() {
        if (this.eofSymbol == null) {
            this.eofSymbol = new EOFSymbol();
        }
        return this.eofSymbol;
    }

    public TermAttribute createTermAttribute(IStrategoTerm t, String s) {
        ArrayList termAttributeFields = Lists.newArrayList((Object[])new Object[]{t, s});
        if (this.termAttributes.containsKey(termAttributeFields)) {
            return this.termAttributes.get(termAttributeFields);
        }
        TermAttribute ta = new TermAttribute(t, s);
        this.termAttributes.put(termAttributeFields, ta);
        return ta;
    }

    public UniqueProduction createUniqueProduction(Symbol lhs, List<Symbol> rhs) {
        ArrayList uniqueProductionFields = Lists.newArrayList();
        uniqueProductionFields.add(lhs);
        uniqueProductionFields.addAll(rhs);
        if (this.uniqueProductions.containsKey(uniqueProductionFields)) {
            return this.uniqueProductions.get(uniqueProductionFields);
        }
        UniqueProduction up = new UniqueProduction(lhs, rhs);
        this.uniqueProductions.put(uniqueProductionFields, up);
        return up;
    }
}

