/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.metaborg.runtime.task.ITask;
import org.metaborg.runtime.task.engine.ITaskEngine;
import org.metaborg.runtime.task.util.InvokeStrategy;
import org.metaborg.runtime.task.util.TermTools;
import org.metaborg.util.iterators.Iterables2;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.ssl.StrategoHashMap;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public final class TaskInsertion {
    public static PermsOrDeps taskCombinations(ITermFactory factory, ITaskEngine taskEngine, IContext context, Strategy collect, Strategy insert2, IStrategoTerm taskID, ITask task, boolean singleLevel) {
        IStrategoAppl instruction = task.instruction();
        Iterable<IStrategoTerm> actualDependencies = TaskInsertion.getResultIDs(context, collect, instruction);
        switch (task.type()) {
            case Regular: {
                Iterable<IStrategoTerm> allDependencies = taskEngine.getDependencies(taskID, false);
                if (TaskInsertion.dependencyFailure(taskEngine, allDependencies)) {
                    return null;
                }
                if (Iterables.isEmpty(actualDependencies)) {
                    return new PermsOrDeps(Iterables2.singleton(instruction), false);
                }
                return TaskInsertion.insertResultCombinations(taskEngine, context, collect, insert2, instruction, actualDependencies, Iterables2.singleton(taskID), singleLevel);
            }
            case Combinator: {
                return new PermsOrDeps(Iterables2.singleton(TaskInsertion.insertResultLists(factory, taskEngine, context, insert2, instruction, actualDependencies)), false);
            }
            case Raw: {
                return new PermsOrDeps(Iterables2.singleton(instruction), false);
            }
        }
        throw new RuntimeException("Task of type " + (Object)((Object)task.type()) + " not handled.");
    }

    public static PermsOrDeps insertResultCombinations(ITaskEngine taskEngine, IContext context, Strategy collect, Strategy insert2, IStrategoTerm term, Iterable<IStrategoTerm> dependencies, Iterable<IStrategoTerm> initialSeen, boolean singleLevel) {
        HashSet seen = Sets.newHashSet(initialSeen);
        ResultMapOrDeps result = TaskInsertion.createResultMapping(taskEngine, context, collect, insert2, dependencies, seen, singleLevel);
        if (result == null) {
            return null;
        }
        if (result.hasDeps()) {
            return new PermsOrDeps(result.deps, true);
        }
        return new PermsOrDeps(TaskInsertion.insertCarthesianProduct(context, insert2, term, result.resultMap), false);
    }

    private static ResultMapOrDeps createResultMapping(ITaskEngine taskEngine, IContext context, Strategy collect, Strategy insert2, Iterable<IStrategoTerm> resultIDs, Set<IStrategoTerm> seen, boolean singleLevel) {
        ArrayListMultimap resultsMap = ArrayListMultimap.create();
        LinkedList dynamicDependencies = Lists.newLinkedList();
        for (IStrategoTerm resultID : resultIDs) {
            if (seen.contains(resultID)) {
                resultsMap.put((Object)resultID, (Object)TaskInsertion.createCycleTerm(context.getFactory(), resultID));
                continue;
            }
            ResultsOrDeps results = TaskInsertion.getResultsOf(taskEngine, context, collect, insert2, resultID, Sets.newHashSet(seen), singleLevel);
            if (results == null) {
                return null;
            }
            if (results.hasDeps()) {
                Iterables.addAll((Collection)dynamicDependencies, results.deps);
                continue;
            }
            resultsMap.putAll((Object)resultID, results.results);
        }
        if (dynamicDependencies.isEmpty()) {
            return ResultMapOrDeps.resultMap((Multimap<IStrategoTerm, IStrategoTerm>)resultsMap);
        }
        return ResultMapOrDeps.deps(dynamicDependencies);
    }

    private static ResultsOrDeps getResultsOf(ITaskEngine taskEngine, IContext context, Strategy collect, Strategy insert2, IStrategoTerm taskID, Set<IStrategoTerm> seen, boolean singleLevel) {
        seen.add(taskID);
        ITask task = taskEngine.getTask(taskID);
        if (!task.solved()) {
            return ResultsOrDeps.deps(Iterables2.singleton(taskID));
        }
        if (task.failed() || task.results().empty()) {
            return null;
        }
        LinkedList results = Lists.newLinkedList();
        LinkedList dynamicDependencies = Lists.newLinkedList();
        for (IStrategoTerm result : task.results()) {
            Iterable<IStrategoTerm> nestedResultIDs = TaskInsertion.getResultIDs(context, collect, result);
            if (singleLevel || Iterables.isEmpty(nestedResultIDs)) {
                results.add(result);
                continue;
            }
            ResultMapOrDeps resultMapping = TaskInsertion.createResultMapping(taskEngine, context, collect, insert2, nestedResultIDs, seen, singleLevel);
            if (resultMapping == null) {
                return null;
            }
            if (resultMapping.hasDeps()) {
                Iterables.addAll((Collection)dynamicDependencies, resultMapping.deps);
                continue;
            }
            Collection<IStrategoTerm> insertedResults = TaskInsertion.insertCarthesianProduct(context, insert2, result, resultMapping.resultMap);
            results.addAll(insertedResults);
        }
        if (dynamicDependencies.isEmpty()) {
            return ResultsOrDeps.results(results);
        }
        return ResultsOrDeps.deps(dynamicDependencies);
    }

    private static Collection<IStrategoTerm> insertCarthesianProduct(IContext context, Strategy insert2, IStrategoTerm term, Multimap<IStrategoTerm, IStrategoTerm> resultMapping) {
        Collection<StrategoHashMap> resultCombinations = TaskInsertion.cartesianProduct(resultMapping);
        LinkedList instructions = Lists.newLinkedList();
        for (StrategoHashMap mapping : resultCombinations) {
            instructions.add(TaskInsertion.insertResults(context, insert2, term, mapping));
        }
        return instructions;
    }

    private static IStrategoTerm insertResultLists(ITermFactory factory, ITaskEngine taskEngine, IContext context, Strategy insert2, IStrategoTerm term, Iterable<IStrategoTerm> resultIDs) {
        StrategoHashMap mapping = new StrategoHashMap();
        for (IStrategoTerm resultID : resultIDs) {
            ITask task = taskEngine.getTask(resultID);
            mapping.put(resultID, TermTools.makeList(factory, task.results()));
        }
        return TaskInsertion.insertResults(context, insert2, term, mapping);
    }

    public static Collection<StrategoHashMap> cartesianProduct(Multimap<IStrategoTerm, IStrategoTerm> results) {
        ArrayList<StrategoHashMap> result = new ArrayList<StrategoHashMap>();
        if (results.size() > 0) {
            result.add(new StrategoHashMap());
        }
        for (Map.Entry entry : results.asMap().entrySet()) {
            ArrayList<StrategoHashMap> newResults = new ArrayList<StrategoHashMap>();
            for (StrategoHashMap map : result) {
                for (IStrategoTerm val : (Collection)entry.getValue()) {
                    StrategoHashMap mapping = new StrategoHashMap();
                    mapping.putAll(map);
                    mapping.put((IStrategoTerm)entry.getKey(), val);
                    newResults.add(mapping);
                }
            }
            result = newResults;
        }
        return result;
    }

    private static boolean dependencyFailure(ITaskEngine taskEngine, Iterable<IStrategoTerm> taskIDs) {
        for (IStrategoTerm taskID : taskIDs) {
            ITask task = taskEngine.getTask(taskID);
            if (!task.failed() && !task.results().empty()) continue;
            return true;
        }
        return false;
    }

    private static Iterable<IStrategoTerm> getResultIDs(IContext context, Strategy collect, IStrategoTerm term) {
        return InvokeStrategy.invoke(context, collect, term);
    }

    private static IStrategoTerm insertResults(IContext context, Strategy insertResults, IStrategoTerm instruction, StrategoHashMap resultCombinations) {
        return InvokeStrategy.invoke(context, insertResults, instruction, TaskInsertion.createHashtableTerm(context.getFactory(), resultCombinations));
    }

    private static IStrategoAppl createHashtableTerm(ITermFactory factory, StrategoHashMap hashMap) {
        return factory.makeAppl(factory.makeConstructor("Hashtable", 1), hashMap);
    }

    private static IStrategoAppl createCycleTerm(ITermFactory factory, IStrategoTerm taskID) {
        return factory.makeAppl(factory.makeConstructor("Result", 1), taskID);
    }

    public static class PermsOrDeps {
        public final Iterable<IStrategoTerm> permsOrDeps;
        public final boolean hasDeps;

        public PermsOrDeps(Iterable<IStrategoTerm> permsOrDeps, boolean hasDeps) {
            this.permsOrDeps = permsOrDeps;
            this.hasDeps = hasDeps;
        }
    }

    private static class ResultMapOrDeps {
        public final Multimap<IStrategoTerm, IStrategoTerm> resultMap;
        public final Iterable<IStrategoTerm> deps;

        public ResultMapOrDeps(Multimap<IStrategoTerm, IStrategoTerm> resultMap) {
            this.resultMap = resultMap;
            this.deps = null;
        }

        public ResultMapOrDeps(Iterable<IStrategoTerm> deps) {
            this.resultMap = null;
            this.deps = deps;
        }

        public static ResultMapOrDeps resultMap(Multimap<IStrategoTerm, IStrategoTerm> resultMap) {
            return new ResultMapOrDeps(resultMap);
        }

        public static ResultMapOrDeps deps(Iterable<IStrategoTerm> deps) {
            return new ResultMapOrDeps(deps);
        }

        public boolean hasDeps() {
            return this.deps != null;
        }
    }

    private static class ResultsOrDeps {
        public final Collection<IStrategoTerm> results;
        public final Iterable<IStrategoTerm> deps;

        public ResultsOrDeps(Collection<IStrategoTerm> results) {
            this.results = results;
            this.deps = null;
        }

        public ResultsOrDeps(Iterable<IStrategoTerm> deps) {
            this.results = null;
            this.deps = deps;
        }

        public static ResultsOrDeps results(Collection<IStrategoTerm> results) {
            return new ResultsOrDeps(results);
        }

        public static ResultsOrDeps deps(Iterable<IStrategoTerm> deps) {
            return new ResultsOrDeps(deps);
        }

        public boolean hasDeps() {
            return this.deps != null;
        }
    }
}

