/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.productions;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import org.metaborg.parsetable.ParseTableReadException;
import org.metaborg.parsetable.characterclasses.CharacterClassReader;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.parsetable.productions.IProduction;
import org.metaborg.parsetable.productions.Production;
import org.metaborg.parsetable.productions.ProductionAttributes;
import org.metaborg.parsetable.productions.ProductionType;
import org.metaborg.parsetable.symbols.ISymbol;
import org.metaborg.parsetable.symbols.SymbolReader;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoNamed;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class ProductionReader {
    private final CharacterClassReader characterClassReader;
    private final ICharacterClass digitsCharacterClass;

    public ProductionReader(CharacterClassReader characterClassReader) {
        this.characterClassReader = characterClassReader;
        this.digitsCharacterClass = characterClassReader.characterClassFactory.finalize(characterClassReader.characterClassFactory.fromRange(48, 57));
    }

    public IProduction read(IStrategoTerm productionWithIdTerm) throws ParseTableReadException {
        int productionId = TermUtils.toJavaIntAt(productionWithIdTerm, 1);
        IStrategoAppl productionTerm = TermUtils.toApplAt(productionWithIdTerm, 0);
        IStrategoAppl lhsTerm = TermUtils.toApplAt(productionTerm, 1);
        IStrategoList rhsTerm = TermUtils.toListAt(productionTerm, 0);
        IStrategoAppl attributesTerm = TermUtils.toApplAt(productionTerm, 2);
        SymbolReader symbolReader = new SymbolReader(this.characterClassReader);
        ISymbol lhs = symbolReader.read(lhsTerm);
        ISymbol[] rhs = new ISymbol[rhsTerm.size()];
        int i = 0;
        while (i < rhsTerm.size()) {
            rhs[i] = symbolReader.read((IStrategoAppl)rhsTerm.getSubterm(i));
            ++i;
        }
        boolean isStringLiteral = this.getIsStringLiteral(rhsTerm);
        boolean isNumberLiteral = this.getIsNumberLiteral(rhsTerm);
        boolean isLexicalRhs = this.getIsLexicalRhs(rhsTerm);
        ProductionAttributes attributes = this.readProductionAttributes(attributesTerm);
        return new Production(productionId, lhs, rhs, isStringLiteral, isNumberLiteral, isLexicalRhs, attributes);
    }

    private boolean getIsLexicalRhs(IStrategoList rhs) {
        if (rhs.getSubtermCount() > 0) {
            IStrategoTerm[] iStrategoTermArray = rhs.getAllSubterms();
            int n = iStrategoTermArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStrategoTerm rhsPart = iStrategoTermArray[n2];
                if (!"char-class".equals(((IStrategoAppl)rhsPart).getConstructor().getName())) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private boolean getIsStringLiteral(IStrategoList rhs) {
        for (IStrategoTerm term : rhs) {
            ICharacterClass cc;
            if (!TermUtils.isAppl(term) || (cc = this.getCharacterClass(TermUtils.toAppl(term))) == null || !cc.contains(32)) continue;
            return true;
        }
        return false;
    }

    private boolean getIsNumberLiteral(IStrategoList rhs) {
        if (TermUtils.isApplAt(rhs, 0)) {
            ICharacterClass cc = this.getCharacterClass(TermUtils.toApplAt(rhs, 0));
            return cc != null && cc.equals(this.digitsCharacterClass);
        }
        return false;
    }

    private ICharacterClass getCharacterClass(IStrategoAppl term) {
        if ("char-class".equals(term.getName())) {
            return this.characterClassReader.read(TermUtils.toListAt(term, 0));
        }
        if ("lex".equals(term.getName()) || "iter".equals(term.getName()) || "iter-star".equals(term.getName())) {
            return this.getCharacterClass(TermUtils.toApplAt(term, 0));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private ProductionAttributes readProductionAttributes(IStrategoAppl attributesTerm) throws ParseTableReadException {
        if (!attributesTerm.getName().equals("attrs")) {
            if (!attributesTerm.getName().equals("no-attrs")) throw new ParseTableReadException("Unknown production attribute type: " + attributesTerm);
            return new ProductionAttributes(ProductionType.NO_TYPE, null, false, false, false, false, false, false, false, false, false, false, false, null, null);
        }
        ProductionType type = ProductionType.NO_TYPE;
        IStrategoTerm constructor = null;
        boolean isRecover = false;
        boolean isBracket = false;
        boolean isCompletion = false;
        boolean isPlaceholderInsertion = false;
        boolean isLiteralCompletion = false;
        boolean isIgnoreLayout = false;
        boolean isNewlineEnforced = false;
        boolean isLongestMatch = false;
        boolean isCaseInsensitive = false;
        boolean isIndentPaddingLexical = false;
        boolean isFlatten = false;
        Set nonAssocWith = null;
        Set nonNestedWith = null;
        IStrategoList attributesTermsList = (IStrategoList)attributesTerm.getSubterm(0);
        block54: for (IStrategoTerm attributeTerm : attributesTermsList) {
            String attributeName;
            IStrategoNamed attributeTermNamed = (IStrategoNamed)attributeTerm;
            block11 : switch (attributeName = attributeTermNamed.getName()) {
                case "reject": {
                    type = ProductionType.REJECT;
                    break;
                }
                case "prefer": {
                    type = ProductionType.PREFER;
                    break;
                }
                case "avoid": {
                    type = ProductionType.AVOID;
                    break;
                }
                case "assoc-with": {
                    Object object = attributeTermNamed.getAllSubterms();
                    int n = ((IStrategoTerm[])object).length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStrategoTerm assocInfo = object[n2];
                        IStrategoAppl assocInfoAppl = TermUtils.toAppl(assocInfo);
                        String assocName = assocInfoAppl.getConstructor().getName();
                        Set assocWithSet = (Set)Arrays.stream(TermUtils.toList(assocInfoAppl.getSubterm(0)).getAllSubterms()).map(t -> TermUtils.toInt(t).intValue()).collect(ImmutableSet.toImmutableSet());
                        switch (assocName) {
                            case "non-assoc": {
                                nonAssocWith = assocWithSet;
                                break;
                            }
                            case "non-nested": {
                                nonNestedWith = assocWithSet;
                                break;
                            }
                            default: {
                                throw new ParseTableReadException("Unknown associativity info within assoc-with attribute: " + assocName);
                            }
                        }
                        ++n2;
                    }
                    continue block54;
                }
                case "term": {
                    if (!(attributeTermNamed.getSubterm(0) instanceof IStrategoNamed)) continue block54;
                    IStrategoNamed attributeValueTermNamed = (IStrategoNamed)attributeTermNamed.getSubterm(0);
                    int subtermCount = attributeValueTermNamed.getSubtermCount();
                    String name2 = attributeValueTermNamed.getName();
                    if (subtermCount == 0) {
                        switch (name2) {
                            case "recover": {
                                isRecover = true;
                                break block11;
                            }
                            case "completion": {
                                isCompletion = true;
                                break block11;
                            }
                            case "placeholder-insertion": {
                                isPlaceholderInsertion = true;
                                break block11;
                            }
                            case "literal-completion": {
                                isLiteralCompletion = true;
                                break block11;
                            }
                            case "ignore-indent": 
                            case "ignore-layout": 
                            case "no-lc": {
                                isIgnoreLayout = true;
                                break block11;
                            }
                            case "enforce-newline": {
                                isNewlineEnforced = true;
                                break block11;
                            }
                            case "longest-match": {
                                isLongestMatch = true;
                                break block11;
                            }
                            case "case-insensitive": {
                                isCaseInsensitive = true;
                                break block11;
                            }
                            case "indentpadding": {
                                isIndentPaddingLexical = true;
                                break block11;
                            }
                            case "flatten": {
                                isFlatten = true;
                                break block11;
                            }
                        }
                        break;
                    }
                    if (subtermCount != 1 || !name2.equals("cons") || constructor != null) continue block54;
                    constructor = attributeValueTermNamed.getSubterm(0);
                    break;
                }
                case "id": {
                    constructor = attributeTermNamed.getSubterm(0);
                    break;
                }
                default: {
                    throw new ParseTableReadException("Unknown production attribute: " + attributeName);
                }
                case "deprecated": 
                case "assoc": 
                case "bracket": 
            }
        }
        return new ProductionAttributes(type, constructor, isRecover, isBracket, isCompletion, isPlaceholderInsertion, isLiteralCompletion, isIgnoreLayout, isNewlineEnforced, isLongestMatch, isCaseInsensitive, isIndentPaddingLexical, isFlatten, nonAssocWith, nonNestedWith);
    }
}

