/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.characterclasses;

import java.util.Arrays;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.parsetable.characterclasses.ICharacterClassFactory;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class CharacterClassReader {
    public final ICharacterClassFactory characterClassFactory;

    public CharacterClassReader(ICharacterClassFactory characterClassFactory) {
        this.characterClassFactory = characterClassFactory;
    }

    public ICharacterClass read(IStrategoList characterClassTermList) {
        ICharacterClass characterClass = null;
        for (IStrategoTerm characterClassTerm : characterClassTermList) {
            ICharacterClass characterClassForTerm;
            if (TermUtils.isInt(characterClassTerm)) {
                int character = TermUtils.toJavaInt(characterClassTerm);
                characterClassForTerm = character == 256 ? this.characterClassFactory.fromEmpty().setEOF(true) : this.characterClassFactory.fromSingle(character);
            } else {
                int from = TermUtils.toJavaIntAt(characterClassTerm, 0);
                int to2 = TermUtils.toJavaIntAt(characterClassTerm, 1);
                characterClassForTerm = to2 == 256 ? this.characterClassFactory.fromRange(from, 255).setEOF(true) : this.characterClassFactory.fromRange(from, to2);
            }
            if (characterClass == null) {
                characterClass = characterClassForTerm;
                continue;
            }
            if (characterClassForTerm == null) continue;
            characterClass = characterClass.union(characterClassForTerm);
        }
        return this.characterClassFactory.finalize(characterClass);
    }

    public static class V7
    extends CharacterClassReader {
        public V7(ICharacterClassFactory characterClassFactory) {
            super(characterClassFactory);
        }

        @Override
        public ICharacterClass read(IStrategoList characterClassTermList) {
            int[] ranges = new int[characterClassTermList.getSubtermCount() * 2];
            int i = 0;
            for (IStrategoTerm characterClassTerm : characterClassTermList) {
                if (TermUtils.isInt(characterClassTerm)) {
                    int character = TermUtils.toJavaInt(characterClassTerm);
                    ranges[i++] = character;
                    ranges[i++] = character;
                    continue;
                }
                if ("eof".equals(((IStrategoAppl)characterClassTerm).getName())) {
                    return this.characterClassFactory.finalize(this.characterClassFactory.fromRanges(Arrays.copyOf(ranges, ranges.length - 2), true));
                }
                int from = TermUtils.toJavaIntAt(characterClassTerm, 0);
                int to2 = TermUtils.toJavaIntAt(characterClassTerm, 1);
                ranges[i++] = from;
                ranges[i++] = to2;
            }
            return this.characterClassFactory.finalize(this.characterClassFactory.fromRanges(ranges, false));
        }
    }
}

