/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.characterclasses;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.metaborg.parsetable.characterclasses.CharacterClassFactory;
import org.metaborg.parsetable.characterclasses.CharacterClassOptimized;
import org.metaborg.parsetable.characterclasses.CharacterClassSingle;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public final class CharacterClassRangeList
implements ICharacterClass,
Serializable {
    private static final long serialVersionUID = 8553734625129300348L;
    static final CharacterClassRangeList EMPTY_CONSTANT = new CharacterClassRangeList();
    private final int[] rangeList;
    private final int min;
    private final int max;
    private final boolean containsEOF;

    private CharacterClassRangeList() {
        this(new int[0], false);
    }

    CharacterClassRangeList(int[] rangeList, boolean containsEOF) {
        assert (rangeList.length == 0 || CharacterClassRangeList.isDisjointSorted(rangeList) && rangeList[0] >= 0 && rangeList[rangeList.length - 1] < 0x110000);
        this.rangeList = rangeList;
        this.containsEOF = containsEOF;
        if (this.hasRanges()) {
            int min2 = rangeList[0];
            int max2 = rangeList[rangeList.length - 1];
            if (containsEOF) {
                this.min = Math.min(min2, -1);
                this.max = Math.max(max2, -1);
            } else {
                this.min = min2;
                this.max = max2;
            }
        } else {
            this.max = containsEOF ? -1 : Integer.MIN_VALUE;
            this.min = this.max;
        }
    }

    private static boolean isDisjointSorted(int[] a) {
        int length = a.length;
        if ((length & 1) != 0) {
            return false;
        }
        int i = 0;
        while (i < length - 1) {
            if (a[i] > a[i + 1] || i < length - 2 && a[i + 1] >= a[i + 2] + 1) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    @Override
    public final boolean contains(int character) {
        if (character == -1) {
            return this.containsEOF;
        }
        return this.isCharacterInRange(character, this.rangeIndex(character));
    }

    private int rangeIndex(int character) {
        if (character == -1 || !this.hasRanges() || character < this.rangeList[0]) {
            return -2;
        }
        if (character > this.rangeList[this.rangeList.length - 1]) {
            return this.rangeList.length - 2;
        }
        int low = 0;
        int high = this.rangeList.length - 1;
        while (low < high) {
            int mid = (low + high) / 2;
            if (character < this.rangeList[mid]) {
                high = mid;
                continue;
            }
            if (character >= this.rangeList[mid + 1]) {
                low = mid + 1;
                continue;
            }
            return mid & 0xFFFFFFFE;
        }
        return low & 0xFFFFFFFE;
    }

    private boolean isCharacterInRange(int character, int rangeIndex) {
        return rangeIndex >= 0 && rangeIndex < this.rangeList.length && this.rangeList[rangeIndex] <= character && character <= this.rangeList[rangeIndex + 1];
    }

    @Override
    public int min() {
        return this.min;
    }

    @Override
    public int max() {
        return this.max;
    }

    @Override
    public boolean isEmpty() {
        return !this.hasRanges() && !this.containsEOF;
    }

    @Override
    public int[] getRanges() {
        return this.rangeList;
    }

    public boolean hasRanges() {
        return this.rangeList.length > 0;
    }

    @Override
    public ICharacterClass setEOF(boolean eof) {
        return new CharacterClassRangeList(this.rangeList, eof);
    }

    @Override
    public ICharacterClass union(ICharacterClass other) {
        if (other.isEmpty()) {
            return this;
        }
        if (other.min() == other.max()) {
            return this.addSingle(other.min());
        }
        if (other instanceof CharacterClassRangeList) {
            CharacterClassRangeList that = (CharacterClassRangeList)other;
            int[] newList = new int[this.rangeList.length + that.rangeList.length];
            int i = 0;
            int j = 0;
            int k = 0;
            int low = -1;
            int high = -1;
            while (i < this.rangeList.length || j < that.rangeList.length) {
                int h;
                int l;
                if (i < this.rangeList.length && this.rangeList[i] < (j >= that.rangeList.length ? Integer.MAX_VALUE : that.rangeList[j])) {
                    l = this.rangeList[i++];
                    h = this.rangeList[i++];
                } else if (j < that.rangeList.length && (i >= this.rangeList.length ? Integer.MAX_VALUE : this.rangeList[i]) > that.rangeList[j]) {
                    l = that.rangeList[j++];
                    h = that.rangeList[j++];
                } else {
                    l = this.rangeList[i++];
                    int n = i++;
                    int n2 = ++j;
                    ++j;
                    h = Integer.max(this.rangeList[n], that.rangeList[n2]);
                }
                if (low == -1) {
                    low = l;
                    high = h;
                    continue;
                }
                if (high + 1 >= l) {
                    high = Integer.max(h, high);
                    continue;
                }
                newList[k++] = low;
                newList[k++] = high;
                low = l;
                high = h;
            }
            if (low != -1) {
                newList[k++] = low;
                newList[k++] = high;
            }
            boolean containsEOF = this.containsEOF || that.containsEOF;
            return new CharacterClassRangeList(Arrays.copyOf(newList, k), containsEOF);
        }
        throw new IllegalStateException("Union can only be done with Single and RangeList character classes");
    }

    @Override
    public ICharacterClass intersection(ICharacterClass other) {
        if (other.isEmpty()) {
            return other;
        }
        if (other.min() == other.max()) {
            if (this.contains(other.min())) {
                return other;
            }
            return EMPTY_CONSTANT;
        }
        if (other instanceof CharacterClassRangeList) {
            CharacterClassRangeList that = (CharacterClassRangeList)other;
            int[] newList = new int[this.rangeList.length + that.rangeList.length];
            int i = 0;
            int j = 0;
            int k = 0;
            int low = -1;
            int high = -1;
            while (i < this.rangeList.length || j < that.rangeList.length) {
                int h;
                int l;
                if (i < this.rangeList.length && this.rangeList[i] < (j >= that.rangeList.length ? Integer.MAX_VALUE : that.rangeList[j])) {
                    l = this.rangeList[i++];
                    h = this.rangeList[i++];
                } else if (j < that.rangeList.length && (i >= this.rangeList.length ? Integer.MAX_VALUE : this.rangeList[i]) > that.rangeList[j]) {
                    l = that.rangeList[j++];
                    h = that.rangeList[j++];
                } else {
                    newList[k++] = this.rangeList[i++];
                    l = this.rangeList[i++];
                    int n = ++j;
                    ++j;
                    h = that.rangeList[n];
                    low = Integer.min(l, h);
                    high = Integer.max(l, h);
                    newList[k++] = low++;
                    continue;
                }
                if (low == -1) {
                    low = l;
                    high = h;
                    continue;
                }
                if (l <= high) {
                    newList[k++] = l;
                    if (h < high) {
                        newList[k++] = h;
                        low = h + 1;
                        continue;
                    }
                    if (h == high) {
                        newList[k++] = h;
                        low = -1;
                        high = -1;
                        continue;
                    }
                    newList[k++] = high;
                    low = high + 1;
                    high = h;
                    continue;
                }
                low = l;
                high = h;
            }
            boolean containsEOF = this.containsEOF && that.containsEOF;
            return new CharacterClassRangeList(Arrays.copyOf(newList, k), containsEOF);
        }
        throw new IllegalStateException("Intersection can only be done with Single and RangeList character classes");
    }

    @Override
    public ICharacterClass difference(ICharacterClass other) {
        if (other instanceof CharacterClassSingle) {
            return this.removeSingle(other.min());
        }
        if (other instanceof CharacterClassRangeList) {
            return this.intersection(((CharacterClassRangeList)other).complement());
        }
        throw new IllegalStateException("Difference can only be done with Single and RangeList character classes");
    }

    public ICharacterClass complement() {
        if (!this.hasRanges()) {
            int[] nArray = new int[2];
            nArray[1] = 0x10FFFF;
            return new CharacterClassRangeList(nArray, !this.containsEOF);
        }
        int min2 = this.rangeList[0];
        int max2 = this.rangeList[this.rangeList.length - 1];
        int[] newList = new int[this.rangeList.length + 2 - (min2 == 0 ? 2 : 0) - (max2 == 0x10FFFF ? 2 : 0)];
        int k = 0;
        if (min2 != 0) {
            newList[k++] = 0;
            newList[k++] = this.rangeList[0] - 1;
        }
        int i = 1;
        while (i < this.rangeList.length - 1) {
            newList[k++] = this.rangeList[i] + 1;
            newList[k++] = this.rangeList[i + 1] - 1;
            i += 2;
        }
        if (max2 != 0x10FFFF) {
            newList[k++] = this.rangeList[this.rangeList.length - 1] + 1;
            newList[k] = 0x10FFFF;
        }
        return new CharacterClassRangeList(newList, !this.containsEOF);
    }

    protected final CharacterClassRangeList addSingle(int character) {
        boolean charFitsInNextRange;
        if (character == -1) {
            return new CharacterClassRangeList(this.rangeList, true);
        }
        if (!this.hasRanges()) {
            return new CharacterClassRangeList(new int[]{character, character}, this.containsEOF);
        }
        int rangeIndex = this.rangeIndex(character);
        if (this.isCharacterInRange(character, rangeIndex)) {
            return this;
        }
        boolean charFitsInPrevRange = rangeIndex >= 0 && character - 1 == this.rangeList[rangeIndex + 1];
        boolean bl = charFitsInNextRange = rangeIndex < this.rangeList.length - 2 && character + 1 == this.rangeList[rangeIndex + 2];
        if (charFitsInPrevRange && charFitsInNextRange) {
            return new CharacterClassRangeList(this.collapseRange(rangeIndex + 1), this.containsEOF);
        }
        if (charFitsInNextRange) {
            int[] newList = (int[])this.rangeList.clone();
            int n = rangeIndex + 2;
            newList[n] = newList[n] - 1;
            return new CharacterClassRangeList(newList, this.containsEOF);
        }
        if (charFitsInPrevRange) {
            int[] newList = (int[])this.rangeList.clone();
            int n = rangeIndex + 1;
            newList[n] = newList[n] + 1;
            return new CharacterClassRangeList(newList, this.containsEOF);
        }
        int[] newList = this.insertRange(rangeIndex + 2);
        newList[rangeIndex + 2] = character;
        newList[rangeIndex + 3] = character;
        return new CharacterClassRangeList(newList, this.containsEOF);
    }

    protected final CharacterClassRangeList removeSingle(int character) {
        if (character == -1) {
            return new CharacterClassRangeList(this.rangeList, false);
        }
        int rangeIndex = this.rangeIndex(character);
        if (!this.isCharacterInRange(character, rangeIndex)) {
            return this;
        }
        int low = this.rangeList[rangeIndex];
        int high = this.rangeList[rangeIndex + 1];
        if (low == character && high == character) {
            return new CharacterClassRangeList(this.collapseRange(rangeIndex), this.containsEOF);
        }
        if (low == character) {
            int[] newList = (int[])this.rangeList.clone();
            int n = rangeIndex;
            newList[n] = newList[n] + 1;
            return new CharacterClassRangeList(newList, this.containsEOF);
        }
        if (high == character) {
            int[] newList = (int[])this.rangeList.clone();
            int n = rangeIndex + 1;
            newList[n] = newList[n] - 1;
            return new CharacterClassRangeList(newList, this.containsEOF);
        }
        int[] newList = this.insertRange(rangeIndex + 1);
        newList[rangeIndex + 1] = character - 1;
        newList[rangeIndex + 2] = character + 1;
        return new CharacterClassRangeList(newList, this.containsEOF);
    }

    private int[] insertRange(int rangeIndex) {
        assert (rangeIndex >= 0 && rangeIndex <= this.rangeList.length);
        int[] newList = new int[this.rangeList.length + 2];
        if (rangeIndex > 0) {
            System.arraycopy(this.rangeList, 0, newList, 0, rangeIndex);
        }
        if (rangeIndex < this.rangeList.length) {
            System.arraycopy(this.rangeList, rangeIndex, newList, rangeIndex + 2, this.rangeList.length - rangeIndex);
        }
        return newList;
    }

    private int[] collapseRange(int rangeIndex) {
        assert (rangeIndex >= 0 && rangeIndex <= this.rangeList.length - 2);
        int[] newList = new int[this.rangeList.length - 2];
        if (rangeIndex > 0) {
            System.arraycopy(this.rangeList, 0, newList, 0, rangeIndex);
        }
        if (rangeIndex < this.rangeList.length - 2) {
            System.arraycopy(this.rangeList, rangeIndex + 2, newList, rangeIndex, this.rangeList.length - rangeIndex - 2);
        }
        return newList;
    }

    public final ICharacterClass optimized() {
        if (this.rangeList.length == 0) {
            if (this.containsEOF) {
                return CharacterClassFactory.EOF_SINGLETON;
            }
            throw new IllegalStateException("Empty character classes are not allowed");
        }
        if (!this.containsEOF && this.min == this.max) {
            return new CharacterClassSingle(this.min);
        }
        return new CharacterClassOptimized(this);
    }

    @Override
    public IStrategoTerm toAtermList(ITermFactory tf) {
        IStrategoList.Builder terms = tf.arrayListBuilder(this.rangeList.length / 2 + (this.containsEOF ? 1 : 0));
        int i = 0;
        while (i < this.rangeList.length) {
            int from = this.rangeList[i];
            int to2 = this.rangeList[i + 1];
            if (from == to2) {
                terms.add(tf.makeInt(from));
            } else {
                terms.add(tf.makeAppl(tf.makeConstructor("range", 2), tf.makeInt(from), tf.makeInt(to2)));
            }
            i += 2;
        }
        if (this.containsEOF) {
            terms.add(tf.makeAppl(tf.makeConstructor("eof", 0), new IStrategoTerm[0]));
        }
        return tf.makeList(terms);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.rangeList) ^ Boolean.hashCode(this.containsEOF);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CharacterClassSingle) {
            return this.min == this.max && this.min == ((CharacterClassSingle)o).min();
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacterClassRangeList that = (CharacterClassRangeList)o;
        return Arrays.equals(this.rangeList, that.rangeList) && this.containsEOF == that.containsEOF;
    }

    public String toString() {
        ArrayList<String> ranges = new ArrayList<String>(this.rangeList.length / 2 + (this.containsEOF ? 1 : 0));
        int i = 0;
        while (i < this.rangeList.length) {
            int from = this.rangeList[i];
            int to2 = this.rangeList[i + 1];
            if (from != to2) {
                ranges.add(from + "-" + to2);
            } else {
                ranges.add("" + from);
            }
            i += 2;
        }
        if (this.containsEOF) {
            ranges.add("EOF");
        }
        return "[" + String.join((CharSequence)",", ranges) + "]";
    }
}

