/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.characterclasses;

import java.io.Serializable;
import org.metaborg.parsetable.Cache;
import org.metaborg.parsetable.characterclasses.CharacterClassRangeList;
import org.metaborg.parsetable.characterclasses.CharacterClassSingle;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.parsetable.characterclasses.ICharacterClassFactory;

public class CharacterClassFactory
implements ICharacterClassFactory,
Serializable {
    private static final long serialVersionUID = 2540422015817167132L;
    private final boolean optimize;
    private final boolean cache;
    private Cache<ICharacterClass> characterClassCache;
    public static final ICharacterClass EOF_SINGLETON = new CharacterClassSingle(-1);
    public static final ICharacterClass FULL_RANGE = CharacterClassRangeList.EMPTY_CONSTANT.complement();
    public static final ICharacterClass EMPTY_CHARACTER_CLASS = CharacterClassRangeList.EMPTY_CONSTANT;

    public static String intToString(int character) {
        if (character == -1) {
            return "EOF";
        }
        if (CharacterClassFactory.isNewLine(character)) {
            return "\\n";
        }
        if (CharacterClassFactory.isCarriageReturn(character)) {
            return "\\r";
        }
        if (CharacterClassFactory.isTab(character)) {
            return "\\t";
        }
        if (Character.isSupplementaryCodePoint(character)) {
            return new String(Character.toChars(character));
        }
        return "" + (char)character;
    }

    public static boolean isNewLine(int character) {
        return character == 10;
    }

    public static boolean isCarriageReturn(int character) {
        return character == 13;
    }

    public static boolean isTab(int character) {
        return character == 9;
    }

    public CharacterClassFactory() {
        this(true, true);
    }

    public CharacterClassFactory(boolean optimize, boolean cache) {
        this.optimize = optimize;
        this.cache = cache;
        if (cache) {
            this.characterClassCache = new Cache();
        }
    }

    @Override
    public CharacterClassRangeList fromEmpty() {
        return CharacterClassRangeList.EMPTY_CONSTANT;
    }

    @Override
    public final ICharacterClass fromSingle(int character) {
        return new CharacterClassSingle(character);
    }

    @Override
    public final ICharacterClass fromRange(int from, int to2) {
        return new CharacterClassRangeList(new int[]{from, to2}, false);
    }

    @Override
    public final ICharacterClass fromRanges(int[] ranges, boolean hasEOF) {
        assert (ranges.length % 2 == 0);
        return new CharacterClassRangeList(ranges, hasEOF);
    }

    @Override
    public ICharacterClass finalize(ICharacterClass characterClass) {
        ICharacterClass optimized = characterClass instanceof CharacterClassRangeList && this.optimize ? ((CharacterClassRangeList)characterClass).optimized() : characterClass;
        if (this.cache) {
            return this.characterClassCache.cached(optimized);
        }
        return optimized;
    }
}

