/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.testing;

import java.util.Objects;
import java.util.Stack;
import javax.annotation.Nullable;
import org.metaborg.core.testing.ITestReporterService;

public abstract class TestReporterServiceBase
implements ITestReporterService {
    private boolean started = false;
    private final Stack<String> testSuites = new Stack();
    @Nullable
    private String testCase = null;

    protected abstract void onSessionStarted();

    protected abstract void onSessionFinished();

    protected abstract void onTestSuiteStarted(String var1);

    protected abstract void onTestSuiteFinished(String var1);

    protected abstract void onTestStarted(String var1);

    protected abstract void onTestFailed(String var1, @Nullable String var2, @Nullable String var3);

    protected abstract void onTestPassed(String var1);

    protected abstract void onTestIgnored(String var1, @Nullable String var2);

    @Override
    public final void sessionStarted() {
        this.assertState(!this.started);
        this.onSessionStarted();
        this.started = true;
    }

    @Override
    public final void sessionFinished() {
        this.assertState(this.started);
        this.onSessionFinished();
        this.started = false;
    }

    @Override
    public final void testSuiteStarted(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Argument name may not be null.");
        }
        this.assertState(this.started);
        this.testSuites.push(name2);
        this.onTestSuiteStarted(name2);
    }

    @Override
    public final void testSuiteFinished(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Argument name may not be null.");
        }
        this.assertState(this.started);
        this.assertState(this.testSuites.peek().equals(name2));
        this.onTestSuiteFinished(name2);
        this.testSuites.pop();
    }

    @Override
    public final void testStarted(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Argument name may not be null.");
        }
        this.assertState(this.started);
        this.assertState(this.testCase == null);
        this.testCase = name2;
        this.onTestStarted(name2);
    }

    @Override
    public final void testFailed(String name2, @Nullable String reason, @Nullable String details) {
        if (name2 == null) {
            throw new IllegalArgumentException("Argument name may not be null.");
        }
        this.assertState(this.started);
        this.assertState(Objects.equals(this.testCase, name2));
        this.onTestFailed(name2, reason, details);
        this.testCase = null;
    }

    @Override
    public final void testPassed(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Argument name may not be null.");
        }
        this.assertState(this.started);
        this.assertState(Objects.equals(this.testCase, name2));
        this.onTestPassed(name2);
        this.testCase = null;
    }

    @Override
    public final void testIgnored(String name2, @Nullable String reason) {
        if (name2 == null) {
            throw new IllegalArgumentException("Argument name may not be null.");
        }
        this.assertState(this.started);
        this.assertState(Objects.equals(this.testCase, name2));
        this.onTestIgnored(name2, reason);
        this.testCase = null;
    }

    private void assertState(boolean condition) {
        if (!condition) {
            throw new IllegalStateException("Call not allowed in this state.");
        }
    }
}

