/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.testing;

import java.io.PrintStream;
import javax.annotation.Nullable;
import org.metaborg.core.testing.TestReporterServiceBase;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public final class LoggingTestReporterService
extends TestReporterServiceBase {
    private static final ILogger logger = LoggerUtils.logger(LoggingTestReporterService.class);
    private int testPassedCounter = 0;
    private int testFailedCounter = 0;
    private int testIgnoredCounter = 0;
    private int totalTestPassedCounter = 0;
    private int totalTestFailedCounter = 0;
    private int totalTestIgnoredCounter = 0;

    @Override
    protected void onSessionStarted() {
        logger.info("running tests");
        this.totalTestPassedCounter = 0;
        this.totalTestFailedCounter = 0;
        this.totalTestIgnoredCounter = 0;
    }

    @Override
    protected void onSessionFinished() {
        TestResult result = this.totalTestFailedCounter > 0 ? TestResult.FAILED : TestResult.OK;
        logger.info("test result: {}. {} passed; {} failed; {} ignored", new Object[]{result, this.totalTestPassedCounter, this.totalTestFailedCounter, this.totalTestIgnoredCounter});
    }

    @Override
    protected void onTestSuiteStarted(String name2) {
        logger.info("running test suite {}", name2.trim());
        this.testPassedCounter = 0;
        this.testFailedCounter = 0;
        this.testIgnoredCounter = 0;
    }

    @Override
    protected void onTestSuiteFinished(String name2) {
        TestResult result = this.testFailedCounter > 0 ? TestResult.FAILED : TestResult.OK;
        logger.info("test suite result: {}. {} passed; {} failed; {} ignored", new Object[]{result, this.testPassedCounter, this.testFailedCounter, this.testIgnoredCounter});
    }

    @Override
    protected void onTestStarted(String name2) {
        logger.debug("test {} ...", name2.trim());
    }

    @Override
    protected void onTestFailed(String name2, @Nullable String reason, @Nullable String details) {
        ++this.testFailedCounter;
        ++this.totalTestFailedCounter;
        logger.info("test {} ... {}", name2.trim(), TestResult.FAILED.toString());
    }

    @Override
    protected void onTestPassed(String name2) {
        ++this.testPassedCounter;
        ++this.totalTestPassedCounter;
        logger.info("test {} ... {}", name2.trim(), TestResult.OK.toString());
    }

    @Override
    protected void onTestIgnored(String name2, @Nullable String reason) {
        ++this.testIgnoredCounter;
        ++this.totalTestIgnoredCounter;
        logger.info("test {} ... {}", name2.trim(), TestResult.IGNORED.toString());
    }

    @Override
    public ILogger getLogger() {
        return logger;
    }

    @Override
    public PrintStream getOut() {
        return System.out;
    }

    @Override
    public PrintStream getErr() {
        return System.err;
    }

    private static enum TestResult {
        OK,
        FAILED,
        IGNORED;


        public String toString() {
            switch (this) {
                case OK: {
                    return "ok";
                }
                case FAILED: {
                    return "FAILED";
                }
                case IGNORED: {
                    return "ignored";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

