/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.menu;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.action.IAction;
import org.metaborg.core.action.ITransformAction;
import org.metaborg.core.menu.IMenu;
import org.metaborg.core.menu.IMenuAction;
import org.metaborg.core.menu.IMenuItem;
import org.metaborg.core.menu.IMenuItemVisitor;

public class Menu
implements IMenu {
    private final String name;
    private final Collection<IMenuItem> items;

    public Menu(String name2) {
        this(name2, Lists.newLinkedList());
    }

    public Menu(String name2, Collection<IMenuItem> items) {
        this.name = name2;
        this.items = items;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Iterable<IMenuItem> items() {
        return this.items;
    }

    @Override
    @Nullable
    public IAction action(String name2) throws MetaborgException {
        LinkedList actions = Lists.newLinkedList();
        for (IMenuItem item : this.items) {
            if (!(item instanceof IMenuAction) || !name2.equals(item.name())) continue;
            IMenuAction menuAction = (IMenuAction)item;
            ITransformAction action = menuAction.action();
            actions.add(action);
        }
        int size = actions.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            String message = String.format("Found multiple actions with name %s: %s", name2, Joiner.on((String)", ").join((Iterable)actions));
            throw new MetaborgException(message);
        }
        return (IAction)actions.get(0);
    }

    public void add(IMenuItem item) {
        this.items.add(item);
    }

    public void add(Iterable<? extends IMenuItem> items) {
        Iterables.addAll(this.items, items);
    }

    @Override
    public void accept(IMenuItemVisitor visitor) {
        visitor.visitMenu(this);
    }
}

