/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.language;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.language.ComponentCreationConfig;
import org.metaborg.core.language.ILanguage;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageComponentInternal;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageImplInternal;
import org.metaborg.core.language.ILanguageInternal;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.core.language.Language;
import org.metaborg.core.language.LanguageComponent;
import org.metaborg.core.language.LanguageComponentChange;
import org.metaborg.core.language.LanguageContributionIdentifier;
import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.core.language.LanguageImplChange;
import org.metaborg.core.language.LanguageImplementation;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class LanguageService
implements ILanguageService,
AutoCloseable {
    private static final ILogger logger = LoggerUtils.logger(LanguageService.class);
    private final AtomicInteger sequenceIdGenerator = new AtomicInteger(0);
    private final Map<FileName, ILanguageComponentInternal> locationToComponent = Maps.newHashMap();
    private final Map<LanguageIdentifier, ILanguageComponentInternal> identifierToComponent = Maps.newHashMap();
    private final Subject<LanguageComponentChange> componentChanges = PublishSubject.create();
    private final Map<LanguageIdentifier, ILanguageImplInternal> identifierToImpl = Maps.newHashMap();
    private final SetMultimap<String, ILanguageImplInternal> idToImpl = HashMultimap.create();
    private final Subject<LanguageImplChange> implChanges = PublishSubject.create();
    private final Map<String, ILanguageInternal> nameToLanguage = Maps.newHashMap();
    private final LoadingCache<String, ILanguageInternal> languageCache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<String, ILanguageInternal>(){

        public ILanguageInternal load(String languageName) throws Exception {
            return new Language(languageName);
        }
    });
    private final Cache<LanguageIdentifier, ILanguageImplInternal> languageImplCache = CacheBuilder.newBuilder().weakValues().build();

    @Override
    public void close() {
        this.languageImplCache.invalidateAll();
        this.languageImplCache.cleanUp();
        this.languageCache.invalidateAll();
        this.languageCache.cleanUp();
        this.nameToLanguage.clear();
        this.implChanges.onComplete();
        this.idToImpl.clear();
        this.identifierToImpl.clear();
        this.componentChanges.onComplete();
        this.identifierToComponent.clear();
        this.locationToComponent.clear();
    }

    @Override
    @Nullable
    public ILanguageComponent getComponent(LanguageIdentifier identifier) {
        return this.identifierToComponent.get(identifier);
    }

    @Override
    public ILanguageComponent getComponent(FileName location) {
        return this.locationToComponent.get(location);
    }

    @Override
    @Nullable
    public ILanguageImpl getImpl(LanguageIdentifier identifier) {
        return this.identifierToImpl.get(identifier);
    }

    @Override
    @Nullable
    public ILanguage getLanguage(String name2) {
        return this.nameToLanguage.get(name2);
    }

    @Override
    public Iterable<? extends ILanguageComponent> getAllComponents() {
        return this.identifierToComponent.values();
    }

    @Override
    public Iterable<? extends ILanguageImpl> getAllImpls() {
        return this.identifierToImpl.values();
    }

    @Override
    public Iterable<? extends ILanguageImpl> getAllImpls(String groupId, String id) {
        return this.idToImpl.get((Object)this.groupIdId(groupId, id));
    }

    @Override
    public Iterable<? extends ILanguage> getAllLanguages() {
        return this.nameToLanguage.values();
    }

    @Override
    public Observable<LanguageComponentChange> componentChanges() {
        return this.componentChanges;
    }

    @Override
    public Observable<LanguageImplChange> implChanges() {
        return this.implChanges;
    }

    @Override
    public ILanguageComponent add(ComponentCreationConfig config) {
        this.validateLocation(config.location);
        LinkedList impls = Lists.newLinkedList();
        for (LanguageContributionIdentifier identifier : config.implIds) {
            ILanguageInternal language = this.getOrCreateLanguage(identifier.name);
            ILanguageImplInternal iLanguageImplInternal = this.getOrCreateLanguageImpl(identifier.id, language);
            impls.add(iLanguageImplInternal);
        }
        ILanguageComponentInternal existingComponent = this.identifierToComponent.get(config.identifier);
        LanguageComponent newComponent = new LanguageComponent(config.identifier, config.location, this.sequenceIdGenerator.getAndIncrement(), impls, config.config, config.facets);
        if (existingComponent == null) {
            this.addComponent(newComponent);
            LinkedList changedImpls = Lists.newLinkedList();
            for (ILanguageImplInternal iLanguageImplInternal : impls) {
                if (!iLanguageImplInternal.addComponent(newComponent)) continue;
                changedImpls.add(iLanguageImplInternal);
            }
            this.componentChange(LanguageComponentChange.Kind.Add, null, newComponent);
            for (ILanguageImplInternal iLanguageImplInternal : changedImpls) {
                if (Iterables.size(iLanguageImplInternal.components()) == 1) {
                    this.implChange(LanguageImplChange.Kind.Add, iLanguageImplInternal);
                    continue;
                }
                this.implChange(LanguageImplChange.Kind.Reload, iLanguageImplInternal);
            }
        } else {
            this.removeComponent(existingComponent);
            HashSet removedFromImpls = Sets.newHashSet();
            for (ILanguageImplInternal iLanguageImplInternal : existingComponent.contributesToInternal()) {
                if (!iLanguageImplInternal.removeComponent(existingComponent)) continue;
                removedFromImpls.add(iLanguageImplInternal);
            }
            existingComponent.clearContributions();
            this.addComponent(newComponent);
            HashSet hashSet = Sets.newHashSet();
            for (ILanguageImplInternal impl : impls) {
                if (!impl.addComponent(newComponent)) continue;
                hashSet.add(impl);
            }
            this.componentChange(LanguageComponentChange.Kind.Reload, existingComponent, newComponent);
            Sets.SetView removed = Sets.difference((Set)removedFromImpls, (Set)hashSet);
            for (ILanguageImplInternal impl : removed) {
                if (Iterables.isEmpty(impl.components())) {
                    this.removeImplementation(impl);
                    ILanguageInternal language = impl.belongsToInternal();
                    language.remove(impl);
                    this.implChange(LanguageImplChange.Kind.Remove, impl);
                    if (!Iterables.isEmpty(language.impls())) continue;
                    this.removeLanguage(language);
                    continue;
                }
                this.implChange(LanguageImplChange.Kind.Reload, impl);
            }
            Sets.SetView keep = Sets.intersection((Set)removedFromImpls, (Set)hashSet);
            for (ILanguageImplInternal impl : keep) {
                this.implChange(LanguageImplChange.Kind.Reload, impl);
            }
            Sets.SetView added = Sets.difference((Set)hashSet, (Set)removedFromImpls);
            for (ILanguageImplInternal impl : added) {
                if (Iterables.size(impl.components()) == 1) {
                    this.implChange(LanguageImplChange.Kind.Add, impl);
                    continue;
                }
                this.implChange(LanguageImplChange.Kind.Reload, impl);
            }
        }
        return newComponent;
    }

    private ILanguageInternal getOrCreateLanguage(String languageName) {
        ILanguageInternal language = this.nameToLanguage.get(languageName);
        if (language == null) {
            language = (ILanguageInternal)this.languageCache.getUnchecked((Object)languageName);
            this.addLanguage(language);
        }
        assert (language != null);
        return language;
    }

    private ILanguageImplInternal getOrCreateLanguageImpl(final LanguageIdentifier identifier, final ILanguageInternal language) {
        ILanguageImplInternal impl = this.identifierToImpl.get(identifier);
        if (impl == null) {
            try {
                impl = (ILanguageImplInternal)this.languageImplCache.get((Object)identifier, (Callable)new Callable<ILanguageImplInternal>(){

                    @Override
                    public ILanguageImplInternal call() throws Exception {
                        return new LanguageImplementation(identifier, language);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            this.addImplementation(impl);
            language.add(impl);
        } else {
            ILanguageInternal prevLanguage = impl.belongsToInternal();
            if (!prevLanguage.equals(language)) {
                throw new IllegalStateException("Contributions of " + identifier + " use conflicting " + prevLanguage + " and " + language);
            }
        }
        assert (impl != null);
        return impl;
    }

    @Override
    public void remove(ILanguageComponent component) {
        ILanguageComponentInternal existingComponent = this.identifierToComponent.get(component.id());
        if (existingComponent == null) {
            throw new IllegalStateException("Cannot remove component " + component + ", it was not added before");
        }
        this.removeComponent(existingComponent);
        HashSet removedFromImpls = Sets.newHashSet();
        for (ILanguageImplInternal iLanguageImplInternal : existingComponent.contributesToInternal()) {
            if (!iLanguageImplInternal.removeComponent(existingComponent)) continue;
            removedFromImpls.add(iLanguageImplInternal);
        }
        existingComponent.clearContributions();
        this.componentChange(LanguageComponentChange.Kind.Remove, existingComponent, null);
        for (ILanguageImplInternal iLanguageImplInternal : removedFromImpls) {
            if (Iterables.isEmpty(iLanguageImplInternal.components())) {
                this.removeImplementation(iLanguageImplInternal);
                ILanguageInternal language = iLanguageImplInternal.belongsToInternal();
                language.remove(iLanguageImplInternal);
                this.implChange(LanguageImplChange.Kind.Remove, iLanguageImplInternal);
                if (!Iterables.isEmpty(language.impls())) continue;
                this.removeLanguage(language);
                continue;
            }
            this.implChange(LanguageImplChange.Kind.Reload, iLanguageImplInternal);
        }
    }

    private void validateLocation(FileObject location) {
        try {
            if (!location.exists()) {
                throw new IllegalStateException("Cannot add language component at location " + location + ", location does not exist");
            }
        }
        catch (FileSystemException e) {
            throw new IllegalStateException("Cannot add language component at location " + location, e);
        }
    }

    private void addComponent(ILanguageComponentInternal component) {
        this.identifierToComponent.put(component.id(), component);
        this.locationToComponent.put(component.location().getName(), component);
        logger.debug("Adding {}", component);
    }

    private void addImplementation(ILanguageImplInternal impl) {
        LanguageIdentifier id = impl.id();
        this.identifierToImpl.put(id, impl);
        this.idToImpl.put((Object)this.groupIdId(id), (Object)impl);
        logger.debug("Adding {}", impl);
    }

    private void addLanguage(ILanguageInternal language) {
        String name2 = language.name();
        this.nameToLanguage.put(name2, language);
        logger.debug("Adding {}", language);
    }

    private void removeComponent(ILanguageComponentInternal component) {
        this.identifierToComponent.remove(component.id());
        this.locationToComponent.remove(component.location().getName());
        logger.debug("Removing {}", component);
    }

    private void removeImplementation(ILanguageImplInternal impl) {
        LanguageIdentifier id = impl.id();
        this.identifierToImpl.remove(id);
        this.idToImpl.remove((Object)this.groupIdId(id), (Object)impl);
        logger.debug("Removing {}", impl);
    }

    private void removeLanguage(ILanguageInternal language) {
        String name2 = language.name();
        this.nameToLanguage.remove(name2);
        logger.debug("Removing {}", language);
    }

    private String groupIdId(String groupId, String id) {
        return String.valueOf(groupId) + ":" + id;
    }

    private String groupIdId(LanguageIdentifier identifier) {
        return this.groupIdId(identifier.groupId, identifier.id);
    }

    private void componentChange(LanguageComponentChange.Kind kind, ILanguageComponent oldComponent, ILanguageComponent newComponent) {
        this.componentChanges.onNext(new LanguageComponentChange(kind, oldComponent, newComponent));
    }

    private void implChange(LanguageImplChange.Kind kind, ILanguageImpl impl) {
        this.implChanges.onNext(new LanguageImplChange(kind, impl));
    }
}

