/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.language;

import javax.annotation.Nullable;
import org.metaborg.core.language.ILanguageComponent;

public class LanguageComponentChange {
    public final Kind kind;
    @Nullable
    public final ILanguageComponent oldComponent;
    @Nullable
    public final ILanguageComponent newComponent;

    public LanguageComponentChange(Kind kind, @Nullable ILanguageComponent oldComponent, @Nullable ILanguageComponent newComponent) {
        this.kind = kind;
        this.oldComponent = oldComponent;
        this.newComponent = newComponent;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.kind.hashCode();
        result = 31 * result + (this.oldComponent == null ? 0 : this.oldComponent.hashCode());
        result = 31 * result + (this.newComponent == null ? 0 : this.newComponent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LanguageComponentChange other = (LanguageComponentChange)obj;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.oldComponent == null ? other.oldComponent != null : !this.oldComponent.equals(other.oldComponent)) {
            return false;
        }
        return !(this.newComponent == null ? other.newComponent != null : !this.newComponent.equals(other.newComponent));
    }

    public String toString() {
        return String.format("component change [kind=%s, old=%s, new=%s]", new Object[]{this.kind, this.oldComponent, this.newComponent});
    }

    public static enum Kind {
        Add("addition"),
        Reload("reload"),
        Remove("removal");

        private final String name;

        private Kind(String name2) {
            this.name = name2;
        }

        public String toString() {
            return this.name;
        }
    }
}

