/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.metaborg.core.config.AConfig;
import org.metaborg.core.config.IConfig;
import org.metaborg.core.config.IExportConfig;
import org.metaborg.core.config.IProjectConfig;
import org.metaborg.core.config.ISourceConfig;
import org.metaborg.core.config.LangSource;
import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageBuilder;

public class ProjectConfig
extends AConfig
implements IProjectConfig,
IConfig {
    private static final String PROP_METABORG_VERSION = "metaborgVersion";
    private static final String PROP_SOURCES = "sources";
    private static final String PROP_DEPENDENCIES = "dependencies";
    private static final String PROP_COMPILE_DEPENDENCIES = "dependencies.compile";
    private static final String PROP_SOURCE_DEPENDENCIES = "dependencies.source";
    private static final String PROP_JAVA_DEPENDENCIES = "dependencies.java";

    public ProjectConfig(HierarchicalConfiguration<ImmutableNode> config) {
        super(config);
        if (!config.containsKey(PROP_METABORG_VERSION)) {
            config.setProperty(PROP_METABORG_VERSION, (Object)"2.5.16");
        }
    }

    protected ProjectConfig(HierarchicalConfiguration<ImmutableNode> config, @Nullable String metaborgVersion, @Nullable Collection<IExportConfig> sources, @Nullable Collection<LanguageIdentifier> compileDeps, @Nullable Collection<LanguageIdentifier> sourceDeps, @Nullable Collection<LanguageIdentifier> javaDeps) {
        this(config);
        if (metaborgVersion != null) {
            config.setProperty(PROP_METABORG_VERSION, (Object)metaborgVersion);
        }
        if (sources != null) {
            config.setProperty(PROP_SOURCES, sources);
        }
        if (compileDeps != null) {
            config.setProperty(PROP_COMPILE_DEPENDENCIES, compileDeps);
        }
        if (sourceDeps != null) {
            config.setProperty(PROP_SOURCE_DEPENDENCIES, sourceDeps);
        }
        if (javaDeps != null) {
            config.setProperty(PROP_JAVA_DEPENDENCIES, javaDeps);
        }
    }

    @Override
    public String metaborgVersion() {
        return this.config.getString(PROP_METABORG_VERSION, "2.5.16");
    }

    @Override
    public Collection<ISourceConfig> sources() {
        List sourceConfigs = this.config.configurationsAt(PROP_SOURCES, false);
        ArrayList sources = Lists.newArrayListWithCapacity((int)sourceConfigs.size());
        for (HierarchicalConfiguration sourceConfig : sourceConfigs) {
            List languages = sourceConfig.getList(String.class, "language", Collections.emptyList());
            String directory = sourceConfig.getString("directory");
            if (directory == null) continue;
            for (String language : languages) {
                sources.add(new LangSource(language, directory));
            }
        }
        return sources;
    }

    @Override
    public Collection<LanguageIdentifier> compileDeps() {
        return this.config.getList(LanguageIdentifier.class, PROP_COMPILE_DEPENDENCIES, Collections.emptyList());
    }

    @Override
    public Collection<LanguageIdentifier> sourceDeps() {
        return this.config.getList(LanguageIdentifier.class, PROP_SOURCE_DEPENDENCIES, Collections.emptyList());
    }

    @Override
    public Collection<LanguageIdentifier> javaDeps() {
        return this.config.getList(LanguageIdentifier.class, PROP_JAVA_DEPENDENCIES, Collections.emptyList());
    }

    public Collection<IMessage> validate(MessageBuilder mb) {
        ArrayList messages = Lists.newArrayList();
        ProjectConfig.validateDeps((ImmutableConfiguration)this.config, PROP_COMPILE_DEPENDENCIES, "compile", mb, messages);
        ProjectConfig.validateDeps((ImmutableConfiguration)this.config, PROP_SOURCE_DEPENDENCIES, "source", mb, messages);
        ProjectConfig.validateDeps((ImmutableConfiguration)this.config, PROP_JAVA_DEPENDENCIES, "java", mb, messages);
        return messages;
    }

    private static void validateDeps(ImmutableConfiguration config, String key, String name2, MessageBuilder mb, Collection<IMessage> messages) {
        List depStrs = config.getList(String.class, key, (List)Lists.newArrayList());
        for (String depStr : depStrs) {
            try {
                LanguageIdentifier.parse(depStr);
            }
            catch (IllegalArgumentException e) {
                messages.add(mb.withMessage("Invalid " + name2 + " dependency. " + e.getMessage()).build());
            }
        }
    }
}

