/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.stratego.StrategoTerms;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.stratego.TermOrigin;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.Constraints;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.log.LoggerDebugContext;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spec.Rule;
import mb.statix.spec.Spec;
import mb.statix.spoofax.IStatixProjectConfig;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.Level;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.task.NullCancel;
import org.metaborg.util.task.NullProgress;
import org.metaborg.util.tuple.Tuple2;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public abstract class StatixPrimitive
extends AbstractPrimitive {
    protected static final ILogger logger = LoggerUtils.logger(StatixPrimitive.class);
    protected final int tvars;

    public StatixPrimitive(String name2) {
        this(name2, 0);
    }

    public StatixPrimitive(String name2, int tvars) {
        super(name2, 0, tvars);
        this.tvars = tvars;
    }

    @Override
    public final boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        List<IStrategoTerm> termArgs = Arrays.asList(tvars);
        return this.call(env, env.current(), termArgs, env.getFactory()).map(t -> {
            env.setCurrent((IStrategoTerm)t);
            return true;
        }).orElse(false);
    }

    private final Optional<? extends IStrategoTerm> call(IContext env, IStrategoTerm sterm, List<IStrategoTerm> sterms, ITermFactory factory) throws InterpreterException {
        if (sterms.size() != this.tvars) {
            throw new InterpreterException("Expected " + this.tvars + " term arguments, but got " + sterms.size());
        }
        StrategoTerms strategoTerms = new StrategoTerms(factory);
        ITerm term = strategoTerms.fromStratego(sterm);
        List terms = (List)sterms.stream().map(strategoTerms::fromStratego).collect(ImmutableList.toImmutableList());
        Optional<? extends ITerm> result = this.call(env, term, terms);
        return result.map(strategoTerms::toStratego);
    }

    protected abstract Optional<? extends ITerm> call(IContext var1, ITerm var2, List<ITerm> var3) throws InterpreterException;

    protected void reportOverlappingRules(Spec spec) {
        ListMultimap<String, Rule> rulesWithEquivalentPatterns = spec.rules().getAllEquivalentRules();
        if (!rulesWithEquivalentPatterns.isEmpty()) {
            logger.error("+--------------------------------------+");
            logger.error("| FOUND RULES WITH EQUIVALENT PATTERNS |");
            logger.error("+--------------------------------------+");
            for (Map.Entry entry : rulesWithEquivalentPatterns.asMap().entrySet()) {
                logger.error("| Overlapping rules for: {}", entry.getKey());
                for (Rule rule : (Collection)entry.getValue()) {
                    logger.error("| * {}", rule);
                }
            }
            logger.error("+--------------------------------------+");
        }
    }

    protected void reportInvalidDataLabel(SolverResult analysis, ITerm label) {
        if (!analysis.spec().dataLabels().contains((Object)label)) {
            logger.warn("{} is not a valid relation in this specification. Available relations are {}.", label, analysis.spec().dataLabels());
        }
    }

    protected void reportInvalidEdgeLabel(SolverResult analysis, ITerm label) {
        if (!analysis.spec().edgeLabels().contains((Object)label)) {
            logger.warn("{} is not a valid data label in this specification. Available labels are {}.", label, analysis.spec().edgeLabels());
        }
    }

    protected IDebugContext getDebugContext(ITerm levelTerm) throws InterpreterException {
        String levelString = TermMatch.M.stringValue().match(levelTerm).orElseThrow(() -> new InterpreterException("Expected log level."));
        Level level = levelString.equalsIgnoreCase("None") ? Level.Debug : Level.parse(levelString);
        LoggerDebugContext debug = new LoggerDebugContext(logger, level);
        return debug;
    }

    protected IProgress getProgress(ITerm progressTerm) throws InterpreterException {
        return (IProgress)TermMatch.M.cases(TermMatch.M.tuple0(t -> new NullProgress()), TermMatch.M.blobValue(IProgress.class)).match(progressTerm).orElseThrow(() -> new InterpreterException("Expected progress."));
    }

    protected ICancel getCancel(ITerm cancelTerm) throws InterpreterException {
        return (ICancel)TermMatch.M.cases(TermMatch.M.tuple0(t -> new NullCancel()), TermMatch.M.blobValue(ICancel.class)).match(cancelTerm).orElseThrow(() -> new InterpreterException("Expected cancel."));
    }

    protected void addMessage(IMessage message, IConstraint constraint, IUniDisunifier unifier, IStatixProjectConfig config, Collection<ITerm> errors, Collection<ITerm> warnings, Collection<ITerm> notes) {
        Tuple2<Iterable<String>, ITerm> message_origin = StatixPrimitive.formatMessage(message, constraint, unifier, config);
        String messageText = Streams.stream(message_origin._1()).filter(s -> !s.isEmpty()).map(s -> StatixPrimitive.cleanupString(s)).collect(Collectors.joining("<br>\n&gt;&nbsp;"));
        ITerm messageTerm = TermBuild.B.newTuple(message_origin._2(), TermBuild.B.newString(messageText));
        switch (message.kind()) {
            case ERROR: {
                errors.add(messageTerm);
                break;
            }
            case WARNING: {
                warnings.add(messageTerm);
                break;
            }
            case NOTE: {
                notes.add(messageTerm);
                break;
            }
        }
    }

    public static Tuple2<Iterable<String>, ITerm> formatMessage(IMessage message, IConstraint constraint, IUniDisunifier unifier, IStatixProjectConfig config) {
        TermFormatter formatter = Solver.shallowTermFormatter(unifier, config.messageTermDepth(config.messageTermDepth(3)));
        int maxTraceLength = config.messageTraceLength(config.messageTraceLength(0));
        ITerm originTerm = message.origin().flatMap(t -> StatixPrimitive.getOriginTerm(t, unifier)).orElse(null);
        LinkedList trace = Lists.newLinkedList();
        IConstraint current = constraint;
        int traceCount = 0;
        while (current != null) {
            if (originTerm == null) {
                originTerm = StatixPrimitive.findOriginArgument(current, unifier).orElse(null);
            }
            if (maxTraceLength < 0 || ++traceCount <= maxTraceLength) {
                trace.addLast(current.toString(formatter));
            }
            current = current.cause().orElse(null);
        }
        if (maxTraceLength > 0 && traceCount > maxTraceLength) {
            trace.addLast("... trace truncated ...");
        }
        trace.addFirst(message.toString(formatter, () -> constraint.toString(formatter)));
        if (originTerm == null) {
            originTerm = TermBuild.B.newTuple(new ITerm[0]);
        }
        return Tuple2.of(trace, originTerm);
    }

    private static Optional<ITerm> findOriginArgument(IConstraint constraint, IUniDisunifier unifier) {
        IConstraint.Cases<Stream> terms = Constraints.cases(onArith -> Stream.empty(), onConj -> Stream.empty(), onEqual -> Stream.empty(), onExists -> Stream.empty(), onFalse -> Stream.empty(), onInequal -> Stream.empty(), onNew -> Stream.empty(), onResolveQuery -> Stream.empty(), onTellEdge -> Stream.empty(), onTermId -> Stream.empty(), onTermProperty -> Stream.empty(), onTrue -> Stream.empty(), onTry -> Stream.empty(), onUser -> onUser.args().stream());
        return ((Stream)terms.apply(constraint)).flatMap(t -> Streams.stream(StatixPrimitive.getOriginTerm(t, unifier))).findFirst();
    }

    private static Optional<ITerm> getOriginTerm(ITerm term, IUniDisunifier unifier) {
        return Optional.of(unifier.findTerm(term)).filter(t -> TermIndex.get(t).isPresent()).filter(t -> TermOrigin.get(t).isPresent()).map(t -> TermBuild.B.newTuple((Iterable<? extends ITerm>)ImmutableList.of(), t.getAttachments()));
    }

    private static String cleanupString(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

