/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import mb.nabl2.terms.IBlobTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.statix.constraints.Constraints;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spec.Spec;
import mb.statix.spoofax.StatixPrimitive;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_solve_multi_project
extends StatixPrimitive {
    private static final ILogger logger = LoggerUtils.logger(STX_solve_multi_project.class);

    @Inject
    public STX_solve_multi_project() {
        super(STX_solve_multi_project.class.getSimpleName(), 5);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        SolverResult resultConfig;
        Spec spec = StatixTerms.spec().match(terms.get(0)).orElseThrow(() -> new InterpreterException("Expected spec."));
        this.reportOverlappingRules(spec);
        SolverResult initial = TermMatch.M.blobValue(SolverResult.class).match(terms.get(1)).orElseThrow(() -> new InterpreterException("Expected solver result."));
        IDebugContext debug = this.getDebugContext(terms.get(2));
        IProgress progress = this.getProgress(terms.get(3));
        ICancel cancel = this.getCancel(terms.get(4));
        List<SolverResult> results = TermMatch.M.listElems(TermMatch.M.blobValue(SolverResult.class)).match(term).orElseThrow(() -> new InterpreterException("Expected list of solver results."));
        ArrayList<IConstraint> constraints = new ArrayList<IConstraint>((Collection<IConstraint>)initial.delays().keySet());
        HashMap messages = Maps.newHashMap(initial.messages());
        IState.Immutable state = initial.state();
        for (SolverResult result : results) {
            try {
                state = state.add(result.state());
            }
            catch (IllegalArgumentException e) {
                logger.error("Unexpectedely failed to merge file results.", e);
                return Optional.empty();
            }
            constraints.add(result.delayed());
            messages.putAll(result.messages());
        }
        try {
            double t0 = System.currentTimeMillis();
            resultConfig = Solver.solve(spec, state, Constraints.conjoin(constraints), (s, l, st2) -> true, debug, cancel, progress, 0);
            double dt = (double)System.currentTimeMillis() - t0;
            logger.info("Project analyzed in {} s", dt / 1000.0);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        messages.putAll(resultConfig.messages());
        IBlobTerm resultTerm = TermBuild.B.newBlob(resultConfig.withMessages(messages));
        return Optional.of(resultTerm);
    }
}

