/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.impl.Broker;
import mb.statix.concurrent.GroupResult;
import mb.statix.concurrent.IStatixProject;
import mb.statix.concurrent.IStatixResult;
import mb.statix.concurrent.ProjectResult;
import mb.statix.concurrent.ProjectTypeChecker;
import mb.statix.concurrent.UnitResult;
import mb.statix.concurrent.nameresolution.ScopeImpl;
import mb.statix.constraints.CFalse;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.IMessagePart;
import mb.statix.constraints.messages.Message;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.constraints.messages.TextPart;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.IConstraint;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spec.Spec;
import mb.statix.spoofax.StatixPrimitive;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.unit.Unit;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_solve_multi
extends StatixPrimitive {
    private static final ILogger logger = LoggerUtils.logger(STX_solve_multi.class);

    @Inject
    public STX_solve_multi() {
        super(STX_solve_multi.class.getSimpleName(), 4);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        Spec spec = StatixTerms.spec().match(terms.get(0)).orElseThrow(() -> new InterpreterException("Expected spec."));
        this.reportOverlappingRules(spec);
        IDebugContext debug = this.getDebugContext(terms.get(1));
        IProgress progress = this.getProgress(terms.get(2));
        ICancel cancel = this.getCancel(terms.get(3));
        IStatixProject project = IStatixProject.matcher().match(term).orElseThrow(() -> new InterpreterException("Expected project."));
        ScopeImpl scopeImpl = new ScopeImpl();
        ArrayList results = Lists.newArrayList();
        try {
            logger.info("Analyzing files");
            double t0 = System.currentTimeMillis();
            IFuture<IUnitResult<Scope, ITerm, ITerm, ProjectResult>> futureResult = Broker.run(project.resource(), new ProjectTypeChecker(project, spec, debug), scopeImpl, spec.allLabels(), cancel);
            IUnitResult<Scope, ITerm, ITerm, ProjectResult> result = futureResult.asJavaCompletion().get();
            double dt = (double)System.currentTimeMillis() - t0;
            Map<String, SolverResult> resultMap = this.flattenResult(spec, result);
            logger.info("Files analyzed in {} s", dt / 1000.0);
            for (Map.Entry<String, SolverResult> entry : resultMap.entrySet()) {
                results.add(TermBuild.B.newTuple(TermBuild.B.newString(entry.getKey()), TermBuild.B.newBlob(entry.getValue())));
            }
        }
        catch (InterruptedException ie) {
            logger.info("Async solving interrupted");
        }
        catch (ExecutionException ee) {
            Throwable c = ee.getCause();
            if (c instanceof InterruptedException) {
                logger.info("Async solving interrupted");
            }
            logger.error("Async solving failed.", c);
            throw new InterpreterException("Async solving failed.");
        }
        catch (Throwable e) {
            logger.error("Async solving failed.", e);
            throw new InterpreterException("Async solving failed.");
        }
        return Optional.of(TermBuild.B.newList(results));
    }

    private Map<String, SolverResult> flattenResult(Spec spec, IUnitResult<Scope, ITerm, ITerm, ProjectResult> result) {
        HashMap<String, SolverResult> resourceResults = new HashMap<String, SolverResult>();
        ProjectResult projectResult = result.analysis();
        if (projectResult != null) {
            ArrayList groupResults = new ArrayList();
            projectResult.libraryResults().forEach((k, ur) -> this.flattenLibraryResult(spec, (IUnitResult<Scope, ITerm, ITerm, Unit>)ur));
            projectResult.groupResults().forEach((k, gr) -> this.flattenGroupResult(spec, (IUnitResult<Scope, ITerm, ITerm, GroupResult>)gr, groupResults, (Map<String, SolverResult>)resourceResults));
            projectResult.unitResults().forEach((k, ur) -> this.flattenUnitResult(spec, (IUnitResult<Scope, ITerm, ITerm, UnitResult>)ur, (Map<String, SolverResult>)resourceResults));
            SolverResult solveResult = this.flatSolverResult(spec, result);
            for (SolverResult groupResult : groupResults) {
                solveResult = solveResult.combine(groupResult);
            }
            resourceResults.put(projectResult.resource(), solveResult);
        } else {
            logger.error("Missing result for project {}", result.id());
        }
        return resourceResults;
    }

    private void flattenLibraryResult(Spec spec, IUnitResult<Scope, ITerm, ITerm, Unit> result) {
    }

    private void flattenGroupResult(Spec spec, IUnitResult<Scope, ITerm, ITerm, GroupResult> result, List<SolverResult> groupResults, Map<String, SolverResult> resourceResults) {
        GroupResult groupResult = result.analysis();
        if (groupResult != null) {
            groupResult.groupResults().forEach((k, gr) -> this.flattenGroupResult(spec, (IUnitResult<Scope, ITerm, ITerm, GroupResult>)gr, groupResults, resourceResults));
            groupResult.unitResults().forEach((k, ur) -> this.flattenUnitResult(spec, (IUnitResult<Scope, ITerm, ITerm, UnitResult>)ur, resourceResults));
            SolverResult solveResult = this.flatSolverResult(spec, result);
            groupResults.add(solveResult);
        } else {
            logger.error("Missing result for group {}", result.id());
        }
    }

    private void flattenUnitResult(Spec spec, IUnitResult<Scope, ITerm, ITerm, UnitResult> result, Map<String, SolverResult> resourceResults) {
        UnitResult unitResult = result.analysis();
        if (unitResult != null) {
            SolverResult solveResult = this.flatSolverResult(spec, result);
            resourceResults.put(unitResult.resource(), solveResult);
        } else {
            logger.error("Missing result for unit {}", result.id());
        }
    }

    private SolverResult flatSolverResult(Spec spec, IUnitResult<Scope, ITerm, ITerm, ? extends IStatixResult> result) {
        IStatixResult unitResult = result.analysis();
        SolverResult solveResult = Optional.ofNullable(unitResult.solveResult()).orElseGet(() -> SolverResult.of(spec));
        solveResult = solveResult.withState(solveResult.state().withScopeGraph(result.scopeGraph()));
        ImmutableMap.Builder messages = ImmutableMap.builder().putAll(solveResult.messages());
        if (result.analysis().exception() != null) {
            Message message = new Message(MessageKind.ERROR, (Iterable<IMessagePart>)ImmutableList.of((Object)new TextPart("Exception: " + result.analysis().exception().getMessage())), TermBuild.B.newTuple(new ITerm[0]));
            messages.put((Object)new CFalse(message), (Object)message);
        }
        for (Throwable failure : result.failures()) {
            Message message = new Message(MessageKind.ERROR, (Iterable<IMessagePart>)ImmutableList.of((Object)new TextPart("Exception: " + failure.getMessage())), TermBuild.B.newTuple(new ITerm[0]));
            messages.put((Object)new CFalse(message), (Object)message);
        }
        solveResult = solveResult.withMessages((Map<? extends IConstraint, ? extends IMessage>)messages.build());
        return solveResult;
    }
}

