/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.constraints.messages.MessageUtil;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spoofax.StatixPrimitive;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.functions.Function0;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_delays_as_errors
extends StatixPrimitive {
    @Inject
    public STX_delays_as_errors() {
        super(STX_delays_as_errors.class.getSimpleName(), 0);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        SolverResult result = TermMatch.M.blobValue(SolverResult.class).match(term).orElseThrow(() -> new InterpreterException("Expected solver result."));
        ImmutableMap.Builder messages = ImmutableMap.builder();
        messages.putAll(result.messages());
        result.delays().keySet().forEach(c -> messages.put(c, (Object)new Unsolved(MessageUtil.findClosestMessage(c))));
        SolverResult newResult = result.withMessages((Map<? extends IConstraint, ? extends IMessage>)messages.build()).withDelays((Map<? extends IConstraint, ? extends Delay>)ImmutableMap.of());
        return Optional.of(TermBuild.B.newBlob(newResult));
    }

    private class Unsolved
    implements IMessage,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final IMessage message;

        private Unsolved(IMessage message) {
            this.message = message;
        }

        @Override
        public MessageKind kind() {
            return this.message.kind();
        }

        @Override
        public String toString(TermFormatter formatter, Function0<String> getDefaultMessage) {
            String msg = this.message.toString(formatter, getDefaultMessage);
            return "(unsolved)" + (msg.isEmpty() ? "" : " ") + msg;
        }

        @Override
        public Optional<ITerm> origin() {
            return this.message.origin();
        }

        @Override
        public void visitVars(Action1<ITermVar> onVar) {
            this.message.visitVars(onVar);
        }

        @Override
        public IMessage apply(ISubstitution.Immutable subst) {
            return new Unsolved(this.message.apply(subst));
        }

        @Override
        public IMessage apply(IRenaming subst) {
            return new Unsolved(this.message.apply(subst));
        }
    }
}

