/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import io.usethesource.capsule.Set;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.matching.TermPattern;
import mb.nabl2.terms.substitution.FreshVars;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.substitution.PersistentSubstitution;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.terms.unification.ud.PersistentUniDisunifier;
import mb.statix.constraints.CConj;
import mb.statix.constraints.CEqual;
import mb.statix.constraints.CExists;
import mb.statix.constraints.CUser;
import mb.statix.constraints.Constraints;
import mb.statix.solver.IConstraint;
import mb.statix.solver.StateUtil;
import mb.statix.spec.ApplyMode;
import mb.statix.spec.ApplyResult;
import mb.statix.spec.PreSolvedConstraint;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleSet;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.functions.PartialFunction1;
import org.metaborg.util.functions.Predicate1;
import org.metaborg.util.functions.Predicate2;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.tuple.Tuple3;

public class RuleUtil {
    public static <E extends Throwable> Optional<Tuple3<Rule, ApplyResult, Boolean>> applyOrderedOne(IUniDisunifier.Immutable state, List<Rule> rules, List<? extends ITerm> args, @Nullable IConstraint cause, ApplyMode<E> mode, ApplyMode.Safety safety) throws E {
        List<Tuple2<Rule, ApplyResult>> results = RuleUtil.applyOrdered(state, rules, args, cause, mode, safety, true);
        if (results.size() == 0) {
            return Optional.empty();
        }
        Tuple2<Rule, ApplyResult> result = results.get(0);
        return Optional.of(Tuple3.of(result._1(), result._2(), results.size() == 1));
    }

    public static <E extends Throwable> List<Tuple2<Rule, ApplyResult>> applyOrderedAll(IUniDisunifier.Immutable state, List<Rule> rules, List<? extends ITerm> args, @Nullable IConstraint cause, ApplyMode<E> mode, ApplyMode.Safety safety) throws E {
        return RuleUtil.applyOrdered(state, rules, args, cause, mode, safety, false);
    }

    private static <E extends Throwable> List<Tuple2<Rule, ApplyResult>> applyOrdered(IUniDisunifier.Immutable unifier, List<Rule> rules, List<? extends ITerm> args, @Nullable IConstraint cause, ApplyMode<E> mode, ApplyMode.Safety safety, boolean onlyOne) throws E {
        ImmutableList.Builder results = ImmutableList.builder();
        AtomicBoolean foundOne = new AtomicBoolean(false);
        for (Rule rule : rules) {
            Tuple3 guard;
            ApplyResult applyResult = RuleUtil.apply(unifier, rule, args, cause, mode, safety).orElse(null);
            if (applyResult == null) continue;
            results.add(Tuple2.of(rule, applyResult));
            if (onlyOne && foundOne.getAndSet(true) || (guard = (Tuple3)applyResult.guard().map(Diseq::toTuple).orElse(null)) == null) break;
            Optional<IUniDisunifier.Immutable> newUnifier = unifier.disunify((Iterable<ITermVar>)((Iterable)guard._1()), (ITerm)guard._2(), (ITerm)guard._3()).map(IUniDisunifier.Result::unifier);
            if (!newUnifier.isPresent()) {
                throw new IllegalStateException("Unexpected incompatible guard.");
            }
            unifier = newUnifier.get();
        }
        return results.build();
    }

    public static <E extends Throwable> Optional<ApplyResult> apply(IUniDisunifier.Immutable unifier, Rule rule, List<? extends ITerm> args, @Nullable IConstraint cause, ApplyMode<E> mode, ApplyMode.Safety safety) throws E {
        return mode.apply(unifier, rule, args, cause, safety);
    }

    public static <E extends Throwable> List<Tuple2<Rule, ApplyResult>> applyAll(IUniDisunifier.Immutable state, Collection<Rule> rules, List<? extends ITerm> args, @Nullable IConstraint cause, ApplyMode<E> mode, ApplyMode.Safety safety) throws E {
        ImmutableList.Builder results = ImmutableList.builder();
        for (Rule rule : rules) {
            ApplyResult result = RuleUtil.apply(state, rule, args, cause, mode, safety).orElse(null);
            if (result == null) continue;
            results.add(Tuple2.of(rule, result));
        }
        return results.build();
    }

    public static ImmutableSet<Rule> computeOrderIndependentRules(List<Rule> rules) {
        ImmutableSet.Builder newRules = ImmutableSet.builder();
        ArrayList<Tuple3<Set.Immutable, ITerm, IUniDisunifier.Immutable>> guards = new ArrayList<Tuple3<Set.Immutable, ITerm, IUniDisunifier.Immutable>>();
        block4: for (Rule rule : rules) {
            Set.Immutable<ITermVar> ruleParamVars = rule.paramVars();
            FreshVars fresh = new FreshVars(new Set[]{rule.freeVars(), ruleParamVars});
            ArrayList<ITerm> paramTerms = new ArrayList<ITerm>();
            IUniDisunifier.Transient _paramsUnifier = PersistentUniDisunifier.Immutable.of().melt();
            for (Pattern param : rule.params()) {
                Tuple2<ITerm, List<Tuple2<ITermVar, ITerm>>> paramTerm = param.asTerm(v -> v.orElseGet(() -> fresh.fresh("_")));
                paramTerms.add(paramTerm._1());
                try {
                    if (_paramsUnifier.unify((Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>>)paramTerm._2()).isPresent()) continue;
                }
                catch (OccursException ex) {}
                continue block4;
            }
            Set.Immutable paramVars = fresh.fix().__insertAll(ruleParamVars);
            ITerm paramsTerm = TermBuild.B.newTuple(paramTerms);
            IUniDisunifier.Immutable paramsUnifier = _paramsUnifier.freeze();
            IUniDisunifier.Transient _unifier = paramsUnifier.melt();
            for (Tuple3 guard : guards) {
                IRenaming guardRen = fresh.fresh((Set)guard._1());
                Set.Immutable<ITermVar> guardVars = fresh.reset();
                ITerm guardTerm = guardRen.apply((ITerm)guard._2());
                IUnifier.Immutable guardUnifier = ((IUnifier.Immutable)guard._3()).rename(guardRen);
                try {
                    guardUnifier = guardUnifier.unify(paramsTerm, guardTerm).map(r -> r.unifier()).orElse(null);
                    if (guardUnifier == null) {
                    }
                }
                catch (OccursException ex) {}
                continue;
                if (!_unifier.disunify((Iterable<ITermVar>)guardVars, guardUnifier).isPresent()) continue block4;
            }
            IUniDisunifier.Immutable unifier = _unifier.freeze();
            Tuple3<Set.Immutable, ITerm, IUniDisunifier.Immutable> guard = Tuple3.of(paramVars, paramsTerm, paramsUnifier);
            guards.add(guard);
            List params = (List)paramTerms.stream().map(TermPattern.P::fromTerm).collect(ImmutableList.toImmutableList());
            Set.Immutable newBodyVars = paramVars.__removeAll(paramsTerm.getVars());
            IConstraint body = Constraints.exists((Iterable<ITermVar>)newBodyVars, Constraints.conjoin(StateUtil.asConstraint(unifier), rule.body()));
            Rule newRule = Rule.builder().from(rule).params(params).body(body).build();
            newRules.add((Object)newRule);
        }
        return newRules.build();
    }

    public static Optional<Rule> inline(Rule rule, int ith, Rule into) {
        FreshVars fresh = new FreshVars((Iterable<ITermVar>)RuleUtil.vars(into));
        AtomicInteger i = new AtomicInteger(0);
        IConstraint newBody = Constraints.map(c -> {
            if (!(c instanceof CUser)) {
                return c;
            }
            CUser constraint = (CUser)c;
            if (!constraint.name().equals(rule.name())) {
                return c;
            }
            if (i.getAndIncrement() != ith) {
                return c;
            }
            return RuleUtil.applyToConstraint(fresh, rule, constraint.args());
        }, false).apply(into.body());
        if (i.get() <= ith) {
            return Optional.empty();
        }
        return Optional.of(into.withLabel("").withBody(newBody));
    }

    private static IConstraint applyToConstraint(FreshVars fresh, Rule rule, List<? extends ITerm> args) {
        IRenaming swap = fresh.fresh((Set<ITermVar>)rule.paramVars());
        Pattern rulePatterns = TermPattern.P.newTuple((Iterable<? extends Pattern>)rule.params()).eliminateWld(() -> fresh.fresh("_"));
        Tuple2<ITerm, List<Tuple2<ITermVar, ITerm>>> p_eqs = rulePatterns.asTerm(v -> (ITermVar)v.get());
        ITerm p = swap.apply(p_eqs._1());
        ITerm t = TermBuild.B.newTuple(args);
        CEqual eq = new CEqual(t, p);
        Set.Immutable<ITermVar> newVars = fresh.reset();
        IConstraint newConstraint = Constraints.exists(newVars, new CConj(eq, rule.body().apply(swap)));
        return newConstraint;
    }

    public static Rule hoist(Rule rule) {
        PreSolvedConstraint preSolvedBody = PreSolvedConstraint.of(rule.body()).cleanup();
        return rule.withBody(preSolvedBody.toConstraint());
    }

    public static Rule instantiateHeadPatterns(Rule rule) {
        Set.Immutable<ITermVar> paramVars = rule.paramVars();
        FreshVars fresh = new FreshVars(new Set[]{rule.freeVars(), paramVars});
        ArrayList<ITerm> paramTerms = new ArrayList<ITerm>();
        IUniDisunifier.Transient _paramsUnifier = PersistentUniDisunifier.Immutable.of().melt();
        for (Pattern param : rule.params()) {
            Tuple2<ITerm, List<Tuple2<ITermVar, ITerm>>> paramTerm = param.asTerm(v -> v.orElseGet(() -> fresh.fresh("_")));
            paramTerms.add(paramTerm._1());
            try {
                if (_paramsUnifier.unify((Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>>)paramTerm._2()).isPresent()) continue;
                return rule;
            }
            catch (OccursException ex) {
                return rule;
            }
        }
        fresh.fix();
        IUniDisunifier.Immutable paramsUnifier = _paramsUnifier.freeze();
        PreSolvedConstraint body = PreSolvedConstraint.of(rule.body());
        PreSolvedConstraint internedBody = body.intern(CapsuleUtil.immutableSet(), paramsUnifier);
        Tuple2<ISubstitution.Immutable, PreSolvedConstraint> externResult = internedBody.extern((Iterable<ITermVar>)paramVars);
        PreSolvedConstraint externedBody = externResult._2();
        PreSolvedConstraint finalBody = externedBody.cleanup();
        ArrayList<ITerm> newParamTerms = new ArrayList<ITerm>();
        MultiSet.Transient newParamVars = MultiSet.Transient.of();
        for (ITerm paramTerm : paramTerms) {
            ITerm newParamTerm = externResult._1().apply(paramTerm);
            newParamTerms.add(newParamTerm);
            newParamTerm.visitVars(newParamVars::add);
        }
        List params = (List)newParamTerms.stream().map(t -> TermPattern.P.fromTerm((ITerm)t, v -> !finalBody.freeVars().contains(v) && newParamVars.count(v) <= 1)).collect(ImmutableList.toImmutableList());
        return Rule.builder().from(rule).params(params).body(finalBody.toConstraint()).build();
    }

    public static Rule closeInUnifier(Rule rule, IUnifier.Immutable unifier, ApplyMode.Safety safety) {
        ISubstitution.Immutable subst = PersistentSubstitution.Immutable.of();
        for (ITermVar var : rule.freeVars()) {
            subst = subst.put(var, unifier.findRecursive(var));
        }
        Rule newRule = safety.equals((Object)ApplyMode.Safety.UNSAFE) ? rule.unsafeApply(subst) : rule.apply(subst);
        return RuleUtil.hoist(newRule);
    }

    public static SetMultimap<String, Rule> makeFragments(RuleSet rules, Predicate1<String> includePredicate, Predicate2<String, String> includeRule, int generations) {
        HashMultimap fragments = HashMultimap.create();
        HashMultimap newRules = HashMultimap.create();
        for (String ruleName : rules.getRuleNames()) {
            if (!includePredicate.test(ruleName)) continue;
            for (Object r : rules.getOrderIndependentRules(ruleName)) {
                if (!includeRule.test(((Rule)r).name(), ((Rule)r).label())) continue;
                newRules.put((Object)ruleName, r);
            }
        }
        PartialFunction1 expandable = arg_0 -> RuleUtil.lambda$14((SetMultimap)newRules, arg_0);
        for (Map.Entry e : newRules.entries()) {
            if (!Constraints.collectBase(expandable, false).apply(((Rule)e.getValue()).body()).isEmpty()) continue;
            fragments.put((Object)((String)e.getKey()), (Object)((Rule)e.getValue()));
        }
        fragments.forEach((arg_0, arg_1) -> ((SetMultimap)newRules).remove(arg_0, arg_1));
        int g = 0;
        while (g < generations) {
            HashMultimap generation = HashMultimap.create();
            for (Map.Entry e : newRules.entries()) {
                String name2 = (String)e.getKey();
                Rule r = (Rule)e.getValue();
                FreshVars fresh = new FreshVars((Iterable<ITermVar>)RuleUtil.vars(r));
                List cs = Constraints.flatMap(arg_0 -> RuleUtil.lambda$16(fresh, expandable, (SetMultimap)fragments, arg_0), false).apply(r.body()).collect(Collectors.toList());
                for (IConstraint c : cs) {
                    Rule f = r.withLabel("").withBody(new CExists((Iterable<ITermVar>)CapsuleUtil.immutableSet(), c));
                    generation.put((Object)name2, (Object)RuleUtil.hoist(f));
                }
            }
            fragments.putAll((Multimap)generation);
            ++g;
        }
        return ImmutableSetMultimap.copyOf((Multimap)fragments);
    }

    public static Set.Immutable<ITermVar> vars(Rule rule) {
        Set.Transient vars = CapsuleUtil.transientSet();
        RuleUtil.vars(rule, arg_0 -> vars.__insert(arg_0));
        return vars.freeze();
    }

    public static void vars(Rule rule, Action1<ITermVar> onVar) {
        rule.paramVars().forEach(onVar::apply);
        Constraints.vars(rule.body(), onVar);
    }

    private static /* synthetic */ Optional lambda$14(SetMultimap setMultimap, IConstraint c) {
        return c instanceof CUser && setMultimap.containsKey((Object)((CUser)c).name()) ? Optional.of((CUser)c) : Optional.empty();
    }

    private static /* synthetic */ Stream lambda$16(FreshVars freshVars, PartialFunction1 partialFunction1, SetMultimap setMultimap, IConstraint c) {
        Optional u = (Optional)partialFunction1.apply(c);
        if (u.isPresent()) {
            return setMultimap.get((Object)((CUser)u.get()).name()).stream().map(f -> RuleUtil.applyToConstraint(freshVars, f, ((CUser)u.get()).args()));
        }
        return Stream.of(c);
    }
}

