/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import com.google.common.base.MoreObjects;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.IState;
import mb.statix.solver.ITermProperty;
import mb.statix.solver.persistent.AState;
import org.metaborg.util.tuple.Tuple2;

public final class State
extends AState
implements Serializable {
    private final String resource;
    private final int __varCounter;
    private final Set.Immutable<ITermVar> __vars;
    private final int __scopeCounter;
    private final Set.Immutable<Scope> __scopes;
    private final IUniDisunifier.Immutable unifier;
    private final IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph;
    private final Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty> termProperties;
    private int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 42L;

    private State(IUniDisunifier.Immutable unifier, IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph, Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty> termProperties) {
        this.unifier = Objects.requireNonNull(unifier, "unifier");
        this.scopeGraph = Objects.requireNonNull(scopeGraph, "scopeGraph");
        this.termProperties = Objects.requireNonNull(termProperties, "termProperties");
        this.resource = this.initShim.resource();
        this.__varCounter = this.initShim.__varCounter();
        this.__vars = this.initShim.__vars();
        this.__scopeCounter = this.initShim.__scopeCounter();
        this.__scopes = this.initShim.__scopes();
        this.initShim = null;
    }

    private State(Builder builder) {
        this.unifier = builder.unifier;
        this.scopeGraph = builder.scopeGraph;
        this.termProperties = builder.termProperties;
        if (builder.resource != null) {
            this.initShim.resource(builder.resource);
        }
        if (builder.__varCounterIsSet()) {
            this.initShim.__varCounter(builder.__varCounter);
        }
        if (builder.__vars != null) {
            this.initShim.__vars((Set.Immutable<ITermVar>)builder.__vars);
        }
        if (builder.__scopeCounterIsSet()) {
            this.initShim.__scopeCounter(builder.__scopeCounter);
        }
        if (builder.__scopes != null) {
            this.initShim.__scopes((Set.Immutable<Scope>)builder.__scopes);
        }
        this.resource = this.initShim.resource();
        this.__varCounter = this.initShim.__varCounter();
        this.__vars = this.initShim.__vars();
        this.__scopeCounter = this.initShim.__scopeCounter();
        this.__scopes = this.initShim.__scopes();
        this.initShim = null;
    }

    private State(String resource, int __varCounter, Set.Immutable<ITermVar> __vars, int __scopeCounter, Set.Immutable<Scope> __scopes, IUniDisunifier.Immutable unifier, IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph, Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty> termProperties) {
        this.resource = resource;
        this.__varCounter = __varCounter;
        this.__vars = __vars;
        this.__scopeCounter = __scopeCounter;
        this.__scopes = __scopes;
        this.unifier = unifier;
        this.scopeGraph = scopeGraph;
        this.termProperties = termProperties;
        this.initShim = null;
    }

    @Override
    public String resource() {
        InitShim shim = this.initShim;
        return shim != null ? shim.resource() : this.resource;
    }

    @Override
    int __varCounter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.__varCounter() : this.__varCounter;
    }

    @Override
    Set.Immutable<ITermVar> __vars() {
        InitShim shim = this.initShim;
        return shim != null ? shim.__vars() : this.__vars;
    }

    @Override
    int __scopeCounter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.__scopeCounter() : this.__scopeCounter;
    }

    @Override
    Set.Immutable<Scope> __scopes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.__scopes() : this.__scopes;
    }

    @Override
    public IUniDisunifier.Immutable unifier() {
        return this.unifier;
    }

    @Override
    public IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph() {
        return this.scopeGraph;
    }

    @Override
    public Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty> termProperties() {
        return this.termProperties;
    }

    @Override
    public final State withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new State(newValue, this.__varCounter, this.__vars, this.__scopeCounter, this.__scopes, this.unifier, this.scopeGraph, this.termProperties);
    }

    public final State with__varCounter(int value) {
        if (this.__varCounter == value) {
            return this;
        }
        return new State(this.resource, value, this.__vars, this.__scopeCounter, this.__scopes, this.unifier, this.scopeGraph, this.termProperties);
    }

    public final State with__vars(Set.Immutable<ITermVar> value) {
        if (this.__vars == value) {
            return this;
        }
        Set.Immutable<ITermVar> newValue = Objects.requireNonNull(value, "__vars");
        return new State(this.resource, this.__varCounter, newValue, this.__scopeCounter, this.__scopes, this.unifier, this.scopeGraph, this.termProperties);
    }

    public final State with__scopeCounter(int value) {
        if (this.__scopeCounter == value) {
            return this;
        }
        return new State(this.resource, this.__varCounter, this.__vars, value, this.__scopes, this.unifier, this.scopeGraph, this.termProperties);
    }

    public final State with__scopes(Set.Immutable<Scope> value) {
        if (this.__scopes == value) {
            return this;
        }
        Set.Immutable<Scope> newValue = Objects.requireNonNull(value, "__scopes");
        return new State(this.resource, this.__varCounter, this.__vars, this.__scopeCounter, newValue, this.unifier, this.scopeGraph, this.termProperties);
    }

    @Override
    public final State withUnifier(IUniDisunifier.Immutable value) {
        if (this.unifier == value) {
            return this;
        }
        IUniDisunifier.Immutable newValue = Objects.requireNonNull(value, "unifier");
        return new State(this.resource, this.__varCounter, this.__vars, this.__scopeCounter, this.__scopes, newValue, this.scopeGraph, this.termProperties);
    }

    @Override
    public final State withScopeGraph(IScopeGraph.Immutable<Scope, ITerm, ITerm> value) {
        if (this.scopeGraph == value) {
            return this;
        }
        IScopeGraph.Immutable<Scope, ITerm, ITerm> newValue = Objects.requireNonNull(value, "scopeGraph");
        return new State(this.resource, this.__varCounter, this.__vars, this.__scopeCounter, this.__scopes, this.unifier, newValue, this.termProperties);
    }

    @Override
    public final State withTermProperties(Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty> value) {
        if (this.termProperties == value) {
            return this;
        }
        Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty> newValue = Objects.requireNonNull(value, "termProperties");
        return new State(this.resource, this.__varCounter, this.__vars, this.__scopeCounter, this.__scopes, this.unifier, this.scopeGraph, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof State && this.equalTo((State)another);
    }

    private boolean equalTo(State another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.resource.equals(another.resource) && this.__varCounter == another.__varCounter && this.__vars.equals(another.__vars) && this.__scopeCounter == another.__scopeCounter && this.__scopes.equals(another.__scopes) && this.unifier.equals(another.unifier) && this.scopeGraph.equals(another.scopeGraph) && this.termProperties.equals(another.termProperties);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + this.__varCounter;
        h += (h << 5) + this.__vars.hashCode();
        h += (h << 5) + this.__scopeCounter;
        h += (h << 5) + this.__scopes.hashCode();
        h += (h << 5) + this.unifier.hashCode();
        h += (h << 5) + this.scopeGraph.hashCode();
        h += (h << 5) + this.termProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"State").omitNullValues().add("resource", (Object)this.resource).add("__varCounter", this.__varCounter).add("__vars", this.__vars).add("__scopeCounter", this.__scopeCounter).add("__scopes", this.__scopes).add("unifier", (Object)this.unifier).add("scopeGraph", this.scopeGraph).add("termProperties", this.termProperties).toString();
    }

    public static State of(IUniDisunifier.Immutable unifier, IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph, Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty> termProperties) {
        return new State(unifier, scopeGraph, termProperties);
    }

    public static State copyOf(AState instance) {
        if (instance instanceof State) {
            return (State)instance;
        }
        return State.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ State(Builder builder, State state) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_UNIFIER = 1L;
        private static final long INIT_BIT_SCOPE_GRAPH = 2L;
        private static final long INIT_BIT_TERM_PROPERTIES = 4L;
        private static final long OPT_BIT___VAR_COUNTER = 1L;
        private static final long OPT_BIT___SCOPE_COUNTER = 2L;
        private long initBits = 7L;
        private long optBits;
        private String resource;
        private int __varCounter;
        private Set.Immutable<ITermVar> __vars;
        private int __scopeCounter;
        private Set.Immutable<Scope> __scopes;
        private IUniDisunifier.Immutable unifier;
        private IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph;
        private Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty> termProperties;

        private Builder() {
        }

        public final Builder from(IState instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AState instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IState.Immutable instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IState instance;
            long bits = 0L;
            if (object instanceof IState) {
                instance = (IState)object;
                if ((bits & 4L) == 0L) {
                    this.resource(instance.resource());
                    bits |= 4L;
                }
            }
            if (object instanceof AState) {
                instance = (AState)object;
                this.__vars(((AState)instance).__vars());
                this.__scopeCounter(((AState)instance).__scopeCounter());
                if ((bits & 1L) == 0L) {
                    this.scopeGraph((IScopeGraph.Immutable<Scope, ITerm, ITerm>)((AState)instance).scopeGraph());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.termProperties(((AState)instance).termProperties());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.resource(((AState)instance).resource());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.unifier(((AState)instance).unifier());
                    bits |= 8L;
                }
                this.__scopes(((AState)instance).__scopes());
                this.__varCounter(((AState)instance).__varCounter());
            }
            if (object instanceof IState.Immutable) {
                instance = (IState.Immutable)object;
                if ((bits & 8L) == 0L) {
                    this.unifier(instance.unifier());
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    this.scopeGraph((IScopeGraph.Immutable<Scope, ITerm, ITerm>)instance.scopeGraph());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.termProperties(instance.termProperties());
                    bits |= 2L;
                }
            }
        }

        public final Builder resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            return this;
        }

        public final Builder __varCounter(int __varCounter) {
            this.__varCounter = __varCounter;
            this.optBits |= 1L;
            return this;
        }

        public final Builder __vars(Set.Immutable<ITermVar> __vars) {
            this.__vars = Objects.requireNonNull(__vars, "__vars");
            return this;
        }

        public final Builder __scopeCounter(int __scopeCounter) {
            this.__scopeCounter = __scopeCounter;
            this.optBits |= 2L;
            return this;
        }

        public final Builder __scopes(Set.Immutable<Scope> __scopes) {
            this.__scopes = Objects.requireNonNull(__scopes, "__scopes");
            return this;
        }

        public final Builder unifier(IUniDisunifier.Immutable unifier) {
            this.unifier = Objects.requireNonNull(unifier, "unifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder scopeGraph(IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph) {
            this.scopeGraph = Objects.requireNonNull(scopeGraph, "scopeGraph");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder termProperties(Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty> termProperties) {
            this.termProperties = Objects.requireNonNull(termProperties, "termProperties");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public State build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new State(this, null);
        }

        private boolean __varCounterIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean __scopeCounterIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("unifier");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scopeGraph");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("termProperties");
            }
            return "Cannot build State, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte resourceBuildStage = 0;
        private String resource;
        private byte __varCounterBuildStage = 0;
        private int __varCounter;
        private byte __varsBuildStage = 0;
        private Set.Immutable<ITermVar> __vars;
        private byte __scopeCounterBuildStage = 0;
        private int __scopeCounter;
        private byte __scopesBuildStage = 0;
        private Set.Immutable<Scope> __scopes;

        private InitShim() {
        }

        String resource() {
            if (this.resourceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.resourceBuildStage == 0) {
                this.resourceBuildStage = (byte)-1;
                this.resource = Objects.requireNonNull(State.super.resource(), "resource");
                this.resourceBuildStage = 1;
            }
            return this.resource;
        }

        void resource(String resource) {
            this.resource = resource;
            this.resourceBuildStage = 1;
        }

        int __varCounter() {
            if (this.__varCounterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.__varCounterBuildStage == 0) {
                this.__varCounterBuildStage = (byte)-1;
                this.__varCounter = State.super.__varCounter();
                this.__varCounterBuildStage = 1;
            }
            return this.__varCounter;
        }

        void __varCounter(int __varCounter) {
            this.__varCounter = __varCounter;
            this.__varCounterBuildStage = 1;
        }

        Set.Immutable<ITermVar> __vars() {
            if (this.__varsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.__varsBuildStage == 0) {
                this.__varsBuildStage = (byte)-1;
                this.__vars = Objects.requireNonNull(State.super.__vars(), "__vars");
                this.__varsBuildStage = 1;
            }
            return this.__vars;
        }

        void __vars(Set.Immutable<ITermVar> __vars) {
            this.__vars = __vars;
            this.__varsBuildStage = 1;
        }

        int __scopeCounter() {
            if (this.__scopeCounterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.__scopeCounterBuildStage == 0) {
                this.__scopeCounterBuildStage = (byte)-1;
                this.__scopeCounter = State.super.__scopeCounter();
                this.__scopeCounterBuildStage = 1;
            }
            return this.__scopeCounter;
        }

        void __scopeCounter(int __scopeCounter) {
            this.__scopeCounter = __scopeCounter;
            this.__scopeCounterBuildStage = 1;
        }

        Set.Immutable<Scope> __scopes() {
            if (this.__scopesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.__scopesBuildStage == 0) {
                this.__scopesBuildStage = (byte)-1;
                this.__scopes = Objects.requireNonNull(State.super.__scopes(), "__scopes");
                this.__scopesBuildStage = 1;
            }
            return this.__scopes;
        }

        void __scopes(Set.Immutable<Scope> __scopes) {
            this.__scopes = __scopes;
            this.__scopesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.resourceBuildStage == -1) {
                attributes.add("resource");
            }
            if (this.__varCounterBuildStage == -1) {
                attributes.add("__varCounter");
            }
            if (this.__varsBuildStage == -1) {
                attributes.add("__vars");
            }
            if (this.__scopeCounterBuildStage == -1) {
                attributes.add("__scopeCounter");
            }
            if (this.__scopesBuildStage == -1) {
                attributes.add("__scopes");
            }
            return "Cannot build State, attribute initializers form cycle " + attributes;
        }
    }
}

