/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import io.usethesource.capsule.Set;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.unification.UnifierFormatter;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.TermFormatter;
import mb.p_raffrayi.ITypeCheckerContext;
import mb.scopegraph.oopsla20.INameResolution;
import mb.scopegraph.oopsla20.reference.FastNameResolution;
import mb.statix.concurrent.StatixSolver;
import mb.statix.constraints.Constraints;
import mb.statix.constraints.messages.IMessage;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.Completeness;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.completeness.IsComplete;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.GreedySolver;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spec.PreSolvedConstraint;
import mb.statix.spec.Spec;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.Level;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;

public class Solver {
    public static final int RETURN_ON_FIRST_ERROR = 1;
    public static final int TERM_FORMAT_DEPTH = 4;
    public static final boolean INCREMENTAL_CRITICAL_EDGES = true;

    private Solver() {
    }

    public static SolverResult solve(Spec spec, IState.Immutable state, IConstraint constraint, IDebugContext debug, ICancel cancel, IProgress progress, int flags) throws InterruptedException {
        return Solver.solve(spec, state, constraint, (s, l, st2) -> true, debug, cancel, progress, flags);
    }

    public static SolverResult solve(Spec spec, IState.Immutable state, IConstraint constraint, IsComplete isComplete, IDebugContext debug, ICancel cancel, IProgress progress, int flags) throws InterruptedException {
        return new GreedySolver(spec, state, constraint, isComplete, debug, progress, cancel, flags).solve();
    }

    public static SolverResult solve(Spec spec, IState.Immutable state, IConstraint constraint, ICompleteness.Immutable completeness, IDebugContext debug, ICancel cancel, IProgress progress, int flags) throws InterruptedException {
        return Solver.solve(spec, state, Collections.singletonList(constraint), Collections.emptyMap(), completeness, (s, l, st2) -> true, debug, progress, cancel, flags);
    }

    public static SolverResult solve(Spec spec, IState.Immutable state, Iterable<IConstraint> constraints, Map<IConstraint, Delay> delays, ICompleteness.Immutable completeness, IsComplete isComplete, IDebugContext debug, IProgress progress, ICancel cancel, int flags) throws InterruptedException {
        return new GreedySolver(spec, state, constraints, delays, completeness, isComplete, debug, progress, cancel, flags).solve();
    }

    public static IFuture<SolverResult> solveConcurrent(IConstraint constraint, Spec spec, IState.Immutable state, ICompleteness.Immutable completeness, IDebugContext debug, IProgress progress, ICancel cancel, ITypeCheckerContext<Scope, ITerm, ITerm> scopeGraph, int flags, Iterable<Scope> rootScopes) {
        return new StatixSolver(constraint, spec, state, completeness, debug, progress, cancel, scopeGraph, flags).solve(rootScopes);
    }

    public static boolean entails(Spec spec, IState.Immutable state, Iterable<IConstraint> constraints, Map<IConstraint, Delay> delays, ICompleteness.Immutable completeness, IsComplete isComplete, IDebugContext debug, IProgress progress, ICancel cancel) throws Delay, InterruptedException {
        IState.Immutable subState;
        PreSolveResult preSolveResult;
        if (debug.isEnabled(Level.Debug)) {
            debug.debug("Checking entailment of {}", Solver.toString(constraints, state.unifier()));
        }
        if ((preSolveResult = (PreSolveResult)Solver.preEntail(subState = state.subState(), completeness, Constraints.conjoin(constraints)).orElse(null)) == null) {
            return false;
        }
        if (preSolveResult.constraints.isEmpty()) {
            return Solver.entailed(subState, preSolveResult, debug);
        }
        SolverResult result = Solver.solve(spec, preSolveResult.state, preSolveResult.constraints, delays, preSolveResult.criticalEdges, isComplete, debug.subContext(), progress, cancel, 1);
        return Solver.entailed(subState, result, debug);
    }

    public static boolean entails(Spec spec, IState.Immutable state, IConstraint constraint, IsComplete isComplete, IDebugContext debug, IProgress progress, ICancel cancel) throws Delay, InterruptedException {
        IState.Immutable subState;
        PreSolveResult preSolveResult;
        if (debug.isEnabled(Level.Debug)) {
            debug.debug("Checking entailment of {}", Solver.toString(constraint, state.unifier()));
        }
        if ((preSolveResult = (PreSolveResult)Solver.preEntail(subState = state.subState(), Completeness.Immutable.of(), constraint).orElse(null)) == null) {
            return false;
        }
        if (preSolveResult.constraints.isEmpty()) {
            return Solver.entailed(subState, preSolveResult, debug);
        }
        SolverResult result = Solver.solve(spec, preSolveResult.state, preSolveResult.constraints, Collections.emptyMap(), preSolveResult.criticalEdges, isComplete, debug.subContext(), progress, cancel, 1);
        return Solver.entailed(subState, result, debug);
    }

    public static boolean entailed(IState.Immutable initialState, SolverResult result, IDebugContext debug) throws Delay {
        if (!initialState.vars().isEmpty() || !initialState.scopes().isEmpty()) {
            throw new IllegalArgumentException("Incurrent initial state: create with IState::subState.");
        }
        if (result.hasErrors()) {
            debug.debug("Constraints not entailed: errors", new Object[0]);
            return false;
        }
        IState.Immutable newState = result.state();
        Delay delay = result.delays().isEmpty() ? null : result.delay();
        return Solver.entailed(initialState, newState, delay, debug);
    }

    public static boolean entailed(IState.Immutable initialState, PreSolveResult preSolveResult, IDebugContext debug) {
        try {
            return Solver.entailed(initialState, preSolveResult.state, null, debug);
        }
        catch (Delay d) {
            throw new IllegalStateException(d);
        }
    }

    private static boolean entailed(IState.Immutable initialState, IState.Immutable newState, @Nullable Delay delay, IDebugContext debug) throws Delay {
        if (!initialState.vars().isEmpty() || !initialState.scopes().isEmpty()) {
            throw new IllegalArgumentException("Incurrent initial state: create with IState::subState.");
        }
        debug.debug("Checking entailment", new Object[0]);
        Set.Immutable<ITermVar> newVars = newState.vars();
        Set.Immutable<Scope> newScopes = newState.scopes();
        IUniDisunifier.Immutable newUnifier = newState.unifier();
        if (delay != null) {
            Delay _delay = delay.removeAll((Iterable<? extends ITermVar>)newVars, (Iterable<? extends ITerm>)newScopes);
            if (_delay.criticalEdges().isEmpty() && _delay.vars().isEmpty()) {
                debug.debug("Constraints not entailed: internal stuckness", new Object[0]);
                return false;
            }
            debug.debug("Cannot decide constraint entailment: unsolved constraints", new Object[0]);
            throw _delay;
        }
        if (newUnifier.disequalities().stream().flatMap(diseq -> diseq.domainSet().stream()).filter(arg_0 -> newVars.contains(arg_0)).count() > 0L) {
            debug.debug("Constraints not entailed: internal stuckness", new Object[0]);
            return false;
        }
        debug.debug("Constraints entailed", new Object[0]);
        return true;
    }

    static void printTrace(IConstraint failed, IUniDisunifier.Immutable unifier, IDebugContext debug) {
        IConstraint constraint = failed;
        while (constraint != null) {
            debug.error(" * {}", constraint.toString(Solver.shallowTermFormatter(unifier, 4)));
            constraint = constraint.cause().orElse(null);
        }
    }

    public static String toString(IConstraint constraint, IUniDisunifier.Immutable unifier) {
        return constraint.toString(Solver.shallowTermFormatter(unifier, 4));
    }

    public static String toString(Iterable<IConstraint> constraints, IUniDisunifier.Immutable unifier) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IConstraint constraint : constraints) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(constraint.toString(Solver.shallowTermFormatter(unifier, 4)));
        }
        return sb.toString();
    }

    public static INameResolution.Builder<Scope, ITerm, ITerm> nameResolutionBuilder() {
        return FastNameResolution.builder();
    }

    public static TermFormatter shallowTermFormatter(IUniDisunifier unifier, int depth) {
        return new UnifierFormatter(unifier, depth, (t, u, f) -> TermMatch.M.cases(Scope.matcher(), TermIndex.matcher()).map(Object::toString).match(t, unifier));
    }

    public static Optional<PreSolveResult> preEntail(IState.Immutable state, @Nullable ICompleteness.Immutable criticalEdges, IConstraint constraint) throws Delay {
        IState.Transient _state = state.melt();
        IUniDisunifier.Transient _unifier = state.unifier().melt();
        HashSet<ITermVar> _updatedVars = new HashSet<ITermVar>();
        ArrayList<IConstraint> constraints = new ArrayList<IConstraint>();
        ICompleteness.Transient _completeness = criticalEdges != null ? criticalEdges.melt() : Completeness.Transient.of();
        HashMap<ITermVar, ITermVar> _existentials = new HashMap<ITermVar, ITermVar>();
        ArrayList<IConstraint> failures = new ArrayList<IConstraint>();
        HashMap<IConstraint, Delay> delays = new HashMap<IConstraint, Delay>();
        PreSolvedConstraint.preSolve(constraint, _state::freshVars, _unifier, v -> !_state.vars().contains(v), _updatedVars, constraints, _completeness, _existentials, failures, delays, constraint.cause().orElse(null), true);
        if (!failures.isEmpty()) {
            return Optional.empty();
        }
        if (!delays.isEmpty()) {
            throw Delay.of(delays.values());
        }
        IState.Immutable newState = _state.freeze().withUnifier(_unifier.freeze());
        PreSolveResult preSolveResult = new PreSolveResult(newState, _updatedVars, constraints, _completeness.freeze(), _existentials, Collections.emptyMap());
        return Optional.of(preSolveResult);
    }

    public static class PreSolveResult {
        public final IState.Immutable state;
        public final Set<ITermVar> updatedVars;
        public final List<IConstraint> constraints;
        public final ICompleteness.Immutable criticalEdges;
        public final Map<ITermVar, ITermVar> existentials;
        public final Map<IConstraint, IMessage> errors;

        public PreSolveResult(IState.Immutable state, Set<ITermVar> updatedVars, List<IConstraint> constraints, ICompleteness.Immutable criticalEdges, Map<ITermVar, ITermVar> existentials, Map<IConstraint, IMessage> errors) {
            this.state = state;
            this.updatedVars = updatedVars;
            this.constraints = constraints;
            this.criticalEdges = criticalEdges;
            this.existentials = existentials;
            this.errors = errors;
        }
    }
}

