/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import javax.annotation.Nullable;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.Unifiers;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.reference.ScopeGraph;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.IState;
import mb.statix.solver.ITermProperty;
import mb.statix.solver.persistent.State;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.tuple.Tuple2;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class AState
implements IState.Immutable {
    @Override
    @Value.Default
    public String resource() {
        return "";
    }

    @Override
    public IState.Immutable add(IState.Immutable other) {
        IUniDisunifier.Immutable unifier;
        Set.Immutable vars = this.vars().union(other.vars());
        Set.Immutable scopes = this.scopes().union(other.scopes());
        try {
            unifier = this.unifier().uniDisunify(other.unifier()).map(IUniDisunifier.Result::unifier).orElseThrow(() -> new IllegalArgumentException("Cannot merge unifiers."));
        }
        catch (OccursException e) {
            throw new IllegalArgumentException("Cannot merge unifiers.");
        }
        IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph = this.scopeGraph().addAll(other.scopeGraph());
        Map.Immutable termProperties = this.termProperties().__putAll(other.termProperties());
        return State.builder().from(this).__vars((Set.Immutable<ITermVar>)vars).__scopes((Set.Immutable<Scope>)scopes).unifier(unifier).scopeGraph(scopeGraph).termProperties((Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty>)termProperties).build();
    }

    @Override
    public IState.Immutable subState() {
        State self = (State)this;
        return self.with__scopes(CapsuleUtil.immutableSet()).with__vars(CapsuleUtil.immutableSet());
    }

    @Value.Default
    int __varCounter() {
        return 0;
    }

    @Value.Default
    Set.Immutable<ITermVar> __vars() {
        return CapsuleUtil.immutableSet();
    }

    @Override
    public Tuple2<ITermVar, IState.Immutable> freshVar(ITermVar var) {
        return this.freshVar(var.getName(), var.getAttachments());
    }

    @Override
    public Tuple2<ITermVar, IState.Immutable> freshWld() {
        return this.freshVar("_", null);
    }

    private Tuple2<ITermVar, IState.Immutable> freshVar(String name2, @Nullable IAttachments attachments) {
        int i = this.__varCounter() + 1;
        String newName = String.valueOf(name2.replace('-', '_')) + "-" + i;
        ITermVar newVar = TermBuild.B.newVar(this.resource(), newName, attachments);
        Set.Immutable vars = this.__vars().__insert((Object)newVar);
        return Tuple2.of(newVar, State.builder().from(this).__varCounter(i).__vars((Set.Immutable<ITermVar>)vars).build());
    }

    @Override
    public Set.Immutable<ITermVar> vars() {
        return this.__vars();
    }

    @Value.Default
    int __scopeCounter() {
        return 0;
    }

    @Value.Default
    Set.Immutable<Scope> __scopes() {
        return CapsuleUtil.immutableSet();
    }

    @Override
    public Tuple2<Scope, IState.Immutable> freshScope(String base) {
        int i = this.__scopeCounter() + 1;
        String name2 = String.valueOf(base.replace('-', '_')) + "-" + i;
        Scope scope = Scope.of(this.resource(), name2);
        Set.Immutable scopes = this.__scopes().__insert((Object)scope);
        return Tuple2.of(scope, State.builder().from(this).__scopeCounter(i).__scopes((Set.Immutable<Scope>)scopes).build());
    }

    @Override
    public Set.Immutable<Scope> scopes() {
        return this.__scopes();
    }

    @Override
    @Value.Parameter
    public abstract IUniDisunifier.Immutable unifier();

    @Override
    @Value.Parameter
    public abstract IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph();

    @Override
    @Value.Parameter
    public abstract Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty> termProperties();

    public static State of() {
        return State.of(Unifiers.Immutable.of(), ScopeGraph.Immutable.of(), (Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty>)Map.Immutable.of());
    }
}

