/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints.messages;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import mb.statix.constraints.CAstId;
import mb.statix.constraints.CAstProperty;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.Message;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.solver.IConstraint;

public class MessageUtil {
    private static Map<Class<? extends IConstraint>, MessageKind> KINDS = ImmutableMap.builder().put(CAstId.class, (Object)MessageKind.IGNORE).put(CAstProperty.class, (Object)MessageKind.IGNORE).build();

    public static MessageKind defaultMessageKind(IConstraint c) {
        return KINDS.getOrDefault(c.getClass(), MessageKind.ERROR);
    }

    public static IMessage findClosestMessage(IConstraint c) {
        return MessageUtil.findClosestMessage(c, KINDS.getOrDefault(c.getClass(), MessageKind.ERROR));
    }

    public static IMessage findClosestMessage(IConstraint c, MessageKind kind) {
        IMessage message = null;
        while (c != null) {
            IMessage m = c.message().orElse(null);
            if (m != null && (message == null || message.kind().isWorseThan(m.kind()))) {
                message = m;
            }
            c = c.cause().orElse(null);
        }
        if (message == null) {
            message = new Message(kind);
        }
        return message;
    }
}

