/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import com.google.common.collect.ImmutableList;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.ICompleteness;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public class CUser
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<ITerm> args;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final IMessage message;
    @Nullable
    private final ICompleteness.Immutable ownCriticalEdges;
    private volatile int hashCode;

    public CUser(String name2, Iterable<? extends ITerm> args) {
        this(name2, args, null, null, null);
    }

    public CUser(String name2, Iterable<? extends ITerm> args, @Nullable IMessage message) {
        this(name2, args, null, message, null);
    }

    public CUser(String name2, Iterable<? extends ITerm> args, @Nullable IConstraint cause, @Nullable IMessage message, @Nullable ICompleteness.Immutable ownCriticalEdges) {
        this.name = name2;
        this.args = ImmutableList.copyOf(args);
        this.cause = cause;
        this.message = message;
        this.ownCriticalEdges = ownCriticalEdges;
    }

    public String name() {
        return this.name;
    }

    public List<ITerm> args() {
        return this.args;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CUser withCause(@Nullable IConstraint cause) {
        return new CUser(this.name, this.args, cause, this.message, this.ownCriticalEdges);
    }

    @Override
    public Optional<IMessage> message() {
        return Optional.ofNullable(this.message);
    }

    @Override
    public CUser withMessage(@Nullable IMessage message) {
        return new CUser(this.name, this.args, this.cause, message, this.ownCriticalEdges);
    }

    @Override
    public Optional<ICompleteness.Immutable> ownCriticalEdges() {
        return Optional.ofNullable(this.ownCriticalEdges);
    }

    @Override
    public CUser withOwnCriticalEdges(ICompleteness.Immutable criticalEdges) {
        return new CUser(this.name, this.args, this.cause, this.message, criticalEdges);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseUser(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseUser(this);
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Transient freeVars = CapsuleUtil.transientSet();
        this.doVisitFreeVars(arg_0 -> freeVars.__insert(arg_0));
        return freeVars.freeze();
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.doVisitFreeVars(onFreeVar);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.args.forEach(t -> t.getVars().forEach(onFreeVar::apply));
        if (this.message != null) {
            this.message.visitVars(onFreeVar);
        }
    }

    @Override
    public CUser apply(ISubstitution.Immutable subst) {
        return new CUser(this.name, subst.apply(this.args), this.cause, this.message == null ? null : this.message.apply(subst), this.ownCriticalEdges == null ? null : this.ownCriticalEdges.apply(subst));
    }

    @Override
    public CUser unsafeApply(ISubstitution.Immutable subst) {
        return new CUser(this.name, subst.apply(this.args), this.cause, this.message == null ? null : this.message.apply(subst), this.ownCriticalEdges == null ? null : this.ownCriticalEdges.apply(subst));
    }

    @Override
    public CUser apply(IRenaming subst) {
        return new CUser(this.name, subst.apply(this.args), this.cause, this.message == null ? null : this.message.apply(subst), this.ownCriticalEdges == null ? null : this.ownCriticalEdges.apply(subst));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("(");
        sb.append(termToString.format(this.args));
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CUser cUser = (CUser)o;
        return Objects.equals(this.name, cUser.name) && Objects.equals(this.args, cUser.args) && Objects.equals(this.cause, cUser.cause) && Objects.equals(this.message, cUser.message);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.name, this.args, this.cause, this.message);
        }
        return result;
    }
}

