/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;
import mb.statix.solver.query.QueryFilter;
import mb.statix.solver.query.QueryMin;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public class CResolveQuery
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final QueryFilter filter;
    private final QueryMin min;
    private final ITerm scopeTerm;
    private final ITerm resultTerm;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final IMessage message;
    private volatile int hashCode;

    public CResolveQuery(QueryFilter filter, QueryMin min2, ITerm scopeTerm, ITerm resultTerm) {
        this(filter, min2, scopeTerm, resultTerm, null, null);
    }

    public CResolveQuery(QueryFilter filter, QueryMin min2, ITerm scopeTerm, ITerm resultTerm, @Nullable IMessage message) {
        this(filter, min2, scopeTerm, resultTerm, null, message);
    }

    public CResolveQuery(QueryFilter filter, QueryMin min2, ITerm scopeTerm, ITerm resultTerm, @Nullable IConstraint cause, @Nullable IMessage message) {
        this.filter = filter;
        this.min = min2;
        this.scopeTerm = scopeTerm;
        this.resultTerm = resultTerm;
        this.cause = cause;
        this.message = message;
    }

    public QueryFilter filter() {
        return this.filter;
    }

    public QueryMin min() {
        return this.min;
    }

    public ITerm scopeTerm() {
        return this.scopeTerm;
    }

    public ITerm resultTerm() {
        return this.resultTerm;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CResolveQuery withCause(@Nullable IConstraint cause) {
        return new CResolveQuery(this.filter, this.min, this.scopeTerm, this.resultTerm, cause, this.message);
    }

    @Override
    public Optional<IMessage> message() {
        return Optional.ofNullable(this.message);
    }

    @Override
    public CResolveQuery withMessage(@Nullable IMessage message) {
        return new CResolveQuery(this.filter, this.min, this.scopeTerm, this.resultTerm, this.cause, message);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseResolveQuery(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseResolveQuery(this);
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Transient freeVars = CapsuleUtil.transientSet();
        this.doVisitFreeVars(arg_0 -> freeVars.__insert(arg_0));
        return freeVars.freeze();
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.doVisitFreeVars(onFreeVar);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.scopeTerm.getVars().forEach(onFreeVar::apply);
        this.filter.getDataWF().visitFreeVars(onFreeVar);
        this.min.getDataEquiv().visitFreeVars(onFreeVar);
        this.resultTerm.getVars().forEach(onFreeVar::apply);
        if (this.message != null) {
            this.message.visitVars(onFreeVar);
        }
    }

    @Override
    public CResolveQuery apply(ISubstitution.Immutable subst) {
        return new CResolveQuery(this.filter.apply(subst), this.min.apply(subst), subst.apply(this.scopeTerm), subst.apply(this.resultTerm), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public CResolveQuery unsafeApply(ISubstitution.Immutable subst) {
        return new CResolveQuery(this.filter.unsafeApply(subst), this.min.unsafeApply(subst), subst.apply(this.scopeTerm), subst.apply(this.resultTerm), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public CResolveQuery apply(IRenaming subst) {
        return new CResolveQuery(this.filter.apply(subst), this.min.apply(subst), subst.apply(this.scopeTerm), subst.apply(this.resultTerm), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("query ");
        sb.append(this.filter.toString(termToString));
        sb.append(" ");
        sb.append(this.min.toString(termToString));
        sb.append(" in ");
        sb.append(termToString.format(this.scopeTerm));
        sb.append(" |-> ");
        sb.append(termToString.format(this.resultTerm));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CResolveQuery that = (CResolveQuery)o;
        return Objects.equals(this.filter, that.filter) && Objects.equals(this.min, that.min) && Objects.equals(this.scopeTerm, that.scopeTerm) && Objects.equals(this.resultTerm, that.resultTerm) && Objects.equals(this.cause, that.cause) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.filter, this.min, this.scopeTerm, this.resultTerm, this.cause, this.message);
        }
        return result;
    }
}

